/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.managers.ICompareListener;
import com.ca.mat.views.pages.AnalysisPage;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class CompareManager {
    List<ICompareListener> listeners = new CopyOnWriteArrayList<ICompareListener>();
    IContextActivation splitScreenContext;
    private boolean compare = false;
    private int compareType;
    private String comparePage = "";

    public void CompareManager() {
    }

    public void addCompareListener(ICompareListener listener) {
        this.listeners.add(listener);
    }

    public void removeCompareListener(ICompareListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty() && this.compare) {
            this.compareType = 1;
            this.comparePage = "";
            this.compare = false;
        }
    }

    public void setCompare(boolean compare) {
        if (this.compare != compare) {
            this.compare = compare;
            for (ICompareListener listener : this.listeners) {
                listener.compareChanged(compare);
            }
        }
    }

    public boolean getCompare() {
        return this.compare;
    }

    public String getModelName() {
        return this.comparePage;
    }

    public int getType() {
        return this.compareType;
    }

    public void modeChanged(String newModeIdentifier) {
        if (this.compare) {
            for (ICompareListener listener : this.listeners) {
                listener.modeChanged(newModeIdentifier);
            }
        }
    }

    public void pageChanged(String modelName, AnalysisPage pageToCopy) {
        if (this.compare && modelName != null) {
            this.comparePage = modelName;
            for (ICompareListener listener : this.listeners) {
                listener.pageChanged(modelName, pageToCopy);
            }
        }
    }

    public void typeChanged(int type) {
        if (this.compare) {
            this.compareType = type;
            for (ICompareListener listener : this.listeners) {
                listener.typeChanged(type);
            }
        }
    }

    public void splitScreenActivated() {
        if (this.splitScreenContext == null) {
            IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            this.splitScreenContext = service.activateContext("com.ca.mat.splitscreenmode");
        }
    }

    public void splitScreenDeactivated() {
        if (this.splitScreenContext != null) {
            IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            service.deactivateContext(this.splitScreenContext);
            this.splitScreenContext = null;
        }
    }
}

