/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.CodeView4GLRowModel;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.HistogramRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.CodeView4GLPage;
import com.ca.mat.views.pages.CodeViewPage;
import org.eclipse.core.expressions.PropertyTester;

public class ListingPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2017 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        if ("hasListing".equals(property)) {
            MATTableRow row;
            if (Singletons.getServerProxy().getConnectedServer() == null) {
                return false;
            }
            if (receiver instanceof HistogramRowModel && ((HistogramRowModel)(row = (HistogramRowModel)receiver)).getStatement() != null) {
                return true;
            }
            if (receiver instanceof CallerIdRowModel && ((CallerIdRowModel)(row = (CallerIdRowModel)receiver)).getStatement() != null) {
                return true;
            }
            if (receiver instanceof DelayLocationRowModel && ((DelayLocationRowModel)(row = (DelayLocationRowModel)receiver)).getStatement() != null) {
                return true;
            }
            if (receiver instanceof CodeViewRowModel) {
                row = (CodeViewRowModel)receiver;
                return AnalysisUtils.csectHasStatements(dsn, ((CodeViewRowModel)row).getCSECT());
            }
        } else if (property.equals("canRegisterListing")) {
            if (Singletons.getServerProxy().getConnectedServer() == null) {
                return false;
            }
            if (receiver instanceof CodeViewRowModel && page instanceof CodeViewPage) {
                CodeViewRowModel rowModel = (CodeViewRowModel)receiver;
                String csect = rowModel.getCSECT();
                return csect != null && !csect.trim().isEmpty() && !csect.startsWith(".");
            }
            if (receiver instanceof CodeView4GLRowModel && page instanceof CodeView4GLPage) {
                return true;
            }
        }
        return false;
    }
}

