/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

public class VerifyDSN
implements VerifyListener {
    static String cacopyright = "Copyright \u00a9 2017 CA";
    private static final Pattern p = Pattern.compile("[.$#@0-9A-Z]+");
    private static final int MAX_DSNAME_LENGTH = 44;
    private static final int MAX_SEGMENTS_COUNT = 22;
    private static final int MIN_SEGMENTS_COUNT = 1;
    private static final int MAX_SEGMENT_LENGTH = 8;
    private static final int MIN_SEGMENT_LENGTH = 1;
    private static final String ALLOWED_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@#$-";

    public void verifyText(VerifyEvent e) {
        if (!e.doit) {
            return;
        }
        e.doit = VerifyDSN.isDSN(e.text);
    }

    public static boolean isDSN(String text) {
        if ((text = text.trim()).length() == 0) {
            return false;
        }
        text = text.toUpperCase();
        Matcher m = p.matcher(text);
        return m.matches();
    }

    public static boolean memberCheck(String text) {
        int index = text.indexOf(40);
        return index != -1;
    }

    public static ArrayList<String> isValid(String input, String attribute) {
        ArrayList<String> errors = new ArrayList<String>();
        if (input == null || input.isEmpty()) {
            errors.add(String.valueOf(attribute) + " Data set name is empty");
            return errors;
        }
        errors = VerifyDSN.checkDsName(input);
        return errors;
    }

    public static ArrayList<String> checkDsName(String dsName) {
        String[] nameSegments;
        ArrayList<String> errors = new ArrayList<String>();
        if (dsName.length() > 44) {
            errors.add(String.valueOf(dsName) + " data set name is too long");
        }
        if (dsName.startsWith(".")) {
            errors.add(String.valueOf(dsName) + " data set name starts with a \",\".");
        }
        if (dsName.endsWith(".")) {
            errors.add(String.valueOf(dsName) + " data set name ends with a \",\".");
        }
        if (dsName.toLowerCase().contains("..")) {
            errors.add(String.valueOf(dsName) + " data set contains \",\"..");
        }
        if ((nameSegments = dsName.toUpperCase().split("\\.")).length < 1) {
            errors.add(String.valueOf(dsName) + " data set name doesn't have any node");
        }
        if (nameSegments.length > 22) {
            errors.add(String.valueOf(dsName) + " data set name contains too much nodes ( more than 8)");
        }
        String[] stringArray = nameSegments;
        int n = nameSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String dsNameSegment = stringArray[n2];
            ArrayList<String> temp = VerifyDSN.checkDsNameSegmentFromDataSet(dsName, dsNameSegment);
            if (!temp.isEmpty() && temp != null) {
                for (String tempErrors : temp) {
                    errors.add(tempErrors);
                }
            }
            ++n2;
        }
        return errors;
    }

    public static ArrayList<String> checkDsNameSegmentFromDataSet(String dsName, String dsNameSegment) {
        ArrayList<String> errorsSegment = new ArrayList<String>();
        if (dsNameSegment.length() < 1) {
            errorsSegment.add(String.valueOf(dsName) + " has a node that is too short ( can be .. or start with . )");
        }
        if (dsNameSegment.length() > 8) {
            errorsSegment.add(String.valueOf(dsName) + " following node is too long: " + dsNameSegment);
        }
        if (dsNameSegment.length() >= 1) {
            char firstChar = dsNameSegment.charAt(0);
            if (!Character.isLetter(firstChar) && firstChar != '#' && firstChar != '@' && firstChar != '$') {
                errorsSegment.add(String.valueOf(dsName) + " following node \"" + ",\"" + dsNameSegment + "\"" + ",\" starts with a prohibited character: " + dsNameSegment.charAt(0));
            }
            int i = 1;
            while (i < dsNameSegment.length()) {
                if (!ALLOWED_CHARACTERS.contains(Character.toString(dsNameSegment.charAt(i)))) {
                    errorsSegment.add(String.valueOf(dsName) + " following node \"" + ",\"" + dsNameSegment + "\"" + ",\" contains a prohibited character: " + dsNameSegment.charAt(i));
                }
                ++i;
            }
        }
        return errorsSegment;
    }

    public static ArrayList<String> checkSegmentFromAttribute(String attribute, String dsNameSegment) {
        char firstChar;
        dsNameSegment = dsNameSegment.toUpperCase();
        ArrayList<String> errorsSegment = new ArrayList<String>();
        if (dsNameSegment.length() < 1) {
            errorsSegment.add(String.valueOf(attribute) + " attribute node name is too short: " + dsNameSegment);
        }
        if (dsNameSegment.length() > 8) {
            errorsSegment.add(String.valueOf(attribute) + " attribute node name is too long: " + dsNameSegment);
        }
        if (!Character.isLetter(firstChar = dsNameSegment.charAt(0)) && firstChar != '#' && firstChar != '@' && firstChar != '$') {
            errorsSegment.add(String.valueOf(attribute) + " attribute starts with a prohibited character: " + dsNameSegment);
        }
        if (dsNameSegment.length() > 1) {
            int i = 1;
            while (i < dsNameSegment.length()) {
                if (!ALLOWED_CHARACTERS.contains(Character.toString(dsNameSegment.charAt(i)))) {
                    errorsSegment.add(String.valueOf(attribute) + " attribute contains a prohibited character: " + dsNameSegment);
                }
                ++i;
            }
        }
        return errorsSegment;
    }
}

