/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageBasic;
import org.eclipse.jface.viewers.IDoubleClickListener;

public class TranViewPage
extends AnalysisPageBasic
implements IDoubleClickListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final String ID = "com.ca.mat.pages.tranview";
    private static final String VIEWER_MEMENTO_TYPE = "pages.tranview.viewer";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.tranview";
    public static final String AUTONAV_COMMAND_ID = "com.ca.mat.commands.analysis.tranview.delaydetails";
    public static final String SECTION_NAME = "TranView";

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = null;
        model = manager.getModel(this.dsn, SECTION_NAME, this.type);
        viewer.addColumn("TRAN", 5, "TRAN ", 1, true, false);
        viewer.addColumn("D", 1, "D ", 1, true, true);
        viewer.addColumn("#Trans", 3, "#Trans ", 2, true, true);
        viewer.addColumn("Avg RESP", 5, "Avg RESP ", 2, true, true);
        viewer.addColumn("Tot CPU", 5, "Tot CPU ", 2, true, true);
        viewer.addColumn("Avg CPU", 5, "Avg CPU ", 2, true, true);
        viewer.addColumn("Active %", 4, "Actv% ", 9, true, true);
        viewer.addColumn("Data %", 4, "Data% ", 9, true, true);
        viewer.addColumn("Other %", 4, "Other% ", 9, true, true);
        viewer.addColumn("Total %", 4, "Total% ", 9, true, true);
        viewer.addColumn("Average SUs", 5, "Average SUs ", 2, true, true);
        viewer.addColumn("Total SUs", 5, "Total SUs ", 2, true, true);
        viewer.setSortColumn(9);
        viewer.setSortDirection(1024);
        if (model != null) {
            if (!model.containsColumn("TRNUM")) {
                viewer.setColumnEmpty(2);
            }
            if (!model.containsColumn("RESPSEC")) {
                viewer.setColumnEmpty(3);
            }
            if (!model.containsColumn("CPUSEC")) {
                viewer.setColumnEmpty(4);
            }
            if (!model.containsColumn("CPUTRN")) {
                viewer.setColumnEmpty(5);
            }
            if (!model.containsColumn("AVGSUS")) {
                viewer.setColumnEmpty(10);
            }
            if (!model.containsColumn("TOTSUS")) {
                viewer.setColumnEmpty(11);
            }
        }
        this.setModel(model);
        viewer.addDoubleClickListener(this);
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        this.setModel(model);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    protected String getAutonavigationCommandId() {
        return AUTONAV_COMMAND_ID;
    }
}

