/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.subpages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.views.subpages.AbstractWASSubpage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class WASTransSubpage
extends AbstractWASSubpage
implements IDoubleClickListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private static final String VIEWER_MEMENTO_TYPE = "pages.wastrans";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.wastrans";
    public static final String ID = "com.ca.mat.pages.wastrans";
    private static final String APP_CLASSES_COMMAND = "com.ca.mat.commands.analysis.wasapp";

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        viewer.addColumn("Transaction URL", 9, null, 1, true, false);
        viewer.addColumn("Active %", 5, null, 3, true, true);
        viewer.addColumn("InvWait %", 5, null, 3, true, true);
        viewer.addColumn("VolWait %", 5, null, 3, true, true);
        viewer.addColumn("Total %", 5, null, 3, true, true);
        viewer.addColumn("Total Count", 5, null, 2, true, true);
        viewer.addColumn("Total Resp", 5, null, 3, false, true);
        viewer.addColumn("Avg Resp", 5, null, 3, true, true);
        viewer.addColumn("Max Resp", 5, null, 3, true, true);
        viewer.addColumn("Min Resp", 5, null, 3, true, true);
        viewer.setSortColumn(4);
        viewer.setSortDirection(1024);
        viewer.addDoubleClickListener(this);
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService comm = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        String commandString = APP_CLASSES_COMMAND;
        Command command = comm.getCommand(commandString);
        try {
            if (command.isEnabled()) {
                service.executeCommand(commandString, null);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, commandString, e);
        }
    }
}

