/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.cics.SymCicsAbend;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.CobolVariable;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.PLIVariable;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CicsMemory
implements IMemoryManager {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    private SymCicsAbend abend;
    private TTServer server;
    private static final String SERVICE = "symdump/server";

    public CicsMemory(DumpTreeNode dumpTreeNode) {
        this.abend = (SymCicsAbend)dumpTreeNode.getAbend();
        this.server = this.abend.getServer();
    }

    public Data getMemory(IWatchData variable) {
        if (!this.abend.isEnabled()) {
            return null;
        }
        if (variable instanceof Variable) {
            Variable symbolVariable = (Variable)variable;
            Variable root = symbolVariable.getBaseVariable();
            if (root != null && symbolVariable != root) {
                root.setAttribute("node_key", symbolVariable.getAttribute("node_key"));
            }
            if (root instanceof CobolVariable) {
                return this.cobolData(root);
            }
            if (root instanceof PLIVariable) {
                return this.pliData(root);
            }
            return this.asmData(root);
        }
        if (variable instanceof Data) {
            return (Data)variable;
        }
        return null;
    }

    private Data asmData(Variable root) {
        return this.getData(root);
    }

    private Data pliData(Variable root) {
        return this.getData(root);
    }

    protected Data getData(Variable root) {
        String errMessage;
        ServerConnect connect = new ServerConnect(this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("uuid", this.abend.getUuid());
        map.put("dump", "-1");
        map.put("cicstoken", this.abend.getCICSToken());
        map.put("type", "var");
        int size = root.getDatasize();
        map.put("program", root.getProgramName());
        map.put("disp", root.getAttribute("node_key"));
        map.put("var", root.getDataRequestName());
        map.put("length", Integer.toString(size));
        map.put("stmt", Integer.toString(root.getStatementNumber()));
        XMLRequest xml = null;
        try {
            xml = connect.connect("dump", map, false);
        }
        catch (TTException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        int errorLevel = xml.getErrorLevel();
        if (errorLevel == 8 && (errMessage = xml.getErrorMessage()).equals("disp Return:8 Reason:0. Unable to load the specified block.")) {
            xml.setStatus(4, "This information is not available", "Feature not implemented");
        }
        if (errorLevel != 0) {
            Shell shell;
            String title = "Request CICS Memory";
            Display display = Display.getCurrent();
            Shell shell2 = shell = display == null ? null : display.getActiveShell();
            if (errorLevel < 8) {
                MessageDialog.openWarning((Shell)shell, (String)title, (String)xml.getErrorMessage());
            } else {
                TT_ErrorDialog.openError((Shell)shell, (String)title, (String)xml.getErrorMessage());
            }
            return null;
        }
        ByteArrayOutputStream writer = new ByteArrayOutputStream(1536);
        MFAddress address = MFAddress.ZERO_ADDR;
        Element element = xml.getCommand();
        NodeList nodes = element.getElementsByTagName("Data");
        int index = 0;
        while (index < nodes.getLength()) {
            Element dline = (Element)nodes.item(index);
            try {
                if (index == 0) {
                    address = new MFAddress(dline.getAttribute("MFAddress"));
                    this.log.log(Level.FINE, "Address {0}", address.toString());
                }
                String data = dline.getAttribute("Data");
                this.log.log(Level.FINE, "Data {0}", data);
                byte[] bytes = HexUtil.HextoBytes((String)data);
                this.log.log(Level.FINE, "Data Dump", (Object)bytes);
                writer.write(bytes);
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            ++index;
        }
        Data data = new Data(writer.toByteArray(), address, root.getTitle());
        data.setMemoryManager((IMemoryManager)this);
        return data;
    }

    private Data cobolData(Variable root) {
        return this.getData(root);
    }

    public Data getMemory(MFAddress address, int length) {
        XMLRequest xml;
        ByteArrayOutputStream writer;
        block6: {
            if (!this.abend.isEnabled()) {
                return null;
            }
            TTServer server = this.abend.getServer();
            ServerConnect connect = new ServerConnect(server, SERVICE);
            HashMap<String, String> map = new HashMap<String, String>(10);
            map.put("uuid", this.abend.getUuid());
            map.put("dump", "-1");
            String addrString = String.valueOf(address.getHighString()) + address.getLowString();
            map.put("addr", addrString);
            map.put("type", "addr");
            map.put("length", Integer.toString(length));
            map.put("cicstoken", this.abend.getCICSToken());
            writer = new ByteArrayOutputStream(1536);
            xml = connect.connect("dump", map, false);
            int errorLevel = xml.getErrorLevel();
            if (errorLevel == 0) break block6;
            this.log.log(Level.INFO, "ErrorLevel={0} Text={1}", new Object[]{errorLevel, xml.getErrorMessage()});
            return null;
        }
        try {
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("Data");
            int index = 0;
            while (index < nodes.getLength()) {
                Element dline = (Element)nodes.item(index);
                if (index == 0) {
                    address = new MFAddress(dline.getAttribute("MFAddress"));
                    this.log.log(Level.FINE, "Address {0}", address.toString());
                }
                String data = dline.getAttribute("Data");
                this.log.log(Level.FINE, "Data {0}", data);
                byte[] bytes = HexUtil.HextoBytes((String)data);
                this.log.log(Level.FINE, "Data Dump", (Object)bytes);
                writer.write(bytes);
                ++index;
            }
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            return null;
        }
        Data data = new Data(writer.toByteArray(), address, "");
        data.setStride(32);
        data.setMemoryManager(this.abend.getMemoryManager());
        return data;
    }

    public void init() {
    }
}

