/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.TreeBuild;
import com.ca.symdump.cics.SymCicsAbend;
import com.ca.symdump.cics.SymCicsDumpTreeNode;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.core.ValidateCredentials;
import com.ca.testingtools.protsym.ProtsymDataset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class SymCicsTreeBuild
extends TreeBuild {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String FORMAT = "%s:%s %s %s";
    protected static String openCmdFormat = "http://%s/symdump/server?cmnd=open&symd=%s&user=%s&epassw=%s&cicstoken=%s";

    public DumpTreeNode buildTree(Abend abend) throws TTException {
        TTServer server = abend.getServer();
        SymCicsAbend token = (SymCicsAbend)abend;
        ServerConnect connection = new ServerConnect(server, "symdump/server");
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("symd", abend.getSysd());
        map.put("cicstoken", token.getCICSToken());
        map.put("jobid", token.getColumn(0));
        String ndvrsym = "N";
        String ndvrleasm = "N";
        String enqueue = null;
        ArrayList protsyms = abend.getDataset().getParent().getParent(Profile.class).getAllChildren(ProtsymDataset.class);
        ArrayList<ProtsymDataset> datasets = new ArrayList<ProtsymDataset>();
        if (protsyms.size() != 0) {
            int ix = 0;
            while (ix < protsyms.size()) {
                ITreeWrappedItem obj = ((TT_TreeItem)protsyms.get(ix)).getValue();
                if (obj instanceof ProtsymDataset) {
                    if (((ProtsymDataset)obj).isNdvrsym()) {
                        ndvrsym = "Y";
                        enqueue = "ndvrenq";
                        datasets.add(0, (ProtsymDataset)obj);
                    } else {
                        datasets.add((ProtsymDataset)obj);
                    }
                }
                if (((ProtsymDataset)obj).isRefreshleasm()) {
                    ndvrleasm = "Y";
                }
                ++ix;
            }
            ValidateCredentials validate = new ValidateCredentials(server, datasets.toArray(new Dataset[datasets.size()]));
            validate.run(false);
            ArrayList<String> names = new ArrayList<String>(datasets.size());
            Iterator it = datasets.iterator();
            while (it.hasNext()) {
                Dataset dataset = (Dataset)it.next();
                if (dataset.isFileNotfound()) {
                    it.remove();
                    continue;
                }
                names.add(dataset.getName());
            }
            map.put("protsym", names);
            map.put("ndvrsym", ndvrsym);
            map.put("ndvrleasm", ndvrleasm);
            map.put("enqu", enqueue);
        }
        XMLRequest xml = null;
        xml = connection.connect("open", map, true);
        DumpTreeNode treeNode = null;
        this.errorLevel = xml.getErrorLevel();
        if (this.errorLevel != 0) {
            this.errorMessage = xml.getErrorMessage();
            String msg = String.format("ErrorLevel=%d Text=%s", this.errorLevel, this.errorMessage);
            this.log.warning(msg);
            this.log.log(Level.WARNING, this.errorMessage);
            this.log.log(Level.FINE, this.errorMessage, xml);
            throw new TTException(xml);
        }
        Element command = xml.getCommand();
        abend.setUuid(XMLFile.getSessionID((Element)command));
        abend.setProtsyms(datasets);
        treeNode = this.buildTree(xml);
        if (treeNode != null) {
            treeNode.setObject(Abend.class.getName(), (Object)abend);
            String system = abend.getColumn(8);
            String abendcode = abend.getColumn(3);
            String date = abend.getColumn(4);
            String time = abend.getColumn(5);
            String format = FORMAT;
            treeNode.setMiscData(String.format(format, system, abendcode, date, time));
        }
        return treeNode;
    }

    protected DumpTreeNode buildNode(String objectAddr, String string, String miscdata) {
        return new SymCicsDumpTreeNode(objectAddr, string, miscdata);
    }
}

