/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor;

import com.ca.db2.editor.HostNamesConfigPanel;
import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.widgets.NumberField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DB2Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private Text sqlIdText;
    private Text paginationCountText;
    private Text portText;
    private Button caseSensitiveBtn;
    private PreferenceStore store = new PreferenceStore("fmdb2_profile.pref");
    private org.eclipse.swt.widgets.List subsystemList;
    private static final Logger logger = Logger.getLogger(DB2Preferences.class);
    private boolean isLoggedIn;
    private HostNamesConfigPanel hostNamesConfigPanel;
    private boolean preferenceFileExists;
    public static final Integer DEFAULT_PAGINATION_COUNT = 50;

    public DB2Preferences() {
    }

    public DB2Preferences(String title) {
        super(title);
    }

    public DB2Preferences(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.isLoggedIn = CommonUtils.isLoggedIn();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.db2.editor.preferences");
        return this.createUI(parent);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.restoreDefaults();
    }

    protected void performApply() {
        super.performApply();
        this.apply();
    }

    private void apply() {
        this.saveProfileInfoToStore();
        Context.getInstance().setDefaultSQLID(this.sqlIdText.getText().toUpperCase());
        Context.put(Context.Keys.PAGINATION_COUNT, Integer.parseInt(this.paginationCountText.getText()));
        Context.put(Context.Keys.CASE_INSENSITIVE, this.caseSensitiveBtn.getSelection());
        DSEUtils.refreshDSE(new LparNode(Context.getInstance().getLpar()), this.getSelectedSubsystems());
    }

    private Control createUI(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(2, false));
        Composite secondPanel = new Composite(root, 0){

            public boolean setFocus() {
                return DB2Preferences.this.preferenceFileExists ? super.setFocus() : DB2Preferences.this.hostNamesConfigPanel.setFocus();
            }
        };
        secondPanel.setLayout((Layout)new GridLayout(2, true));
        secondPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label subsystemsLabel = new Label(secondPanel, 0);
        subsystemsLabel.setText(CommonBundle.SUBSYSTEMS_IN_DSE);
        this.subsystemList = new org.eclipse.swt.widgets.List(secondPanel, 2562);
        GridData subsysystemListGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        subsysystemListGridData.heightHint = 100;
        this.subsystemList.setLayoutData((Object)subsysystemListGridData);
        this.subsystemList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DB2Preferences.this.validateUI();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.subsystemList.setEnabled(this.isLoggedIn);
        Label sqlIdlabel = new Label(secondPanel, 0);
        sqlIdlabel.setText(CommonBundle.SQLID);
        this.sqlIdText = new Text(secondPanel, 2048);
        this.sqlIdText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sqlIdText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                DB2Preferences.this.validateUI();
            }
        });
        Label rowCountlabel = new Label(secondPanel, 0);
        rowCountlabel.setText(CommonBundle.SQL_PAGINATION_COUNT);
        this.paginationCountText = new NumberField(secondPanel, 2048).getWidget();
        this.paginationCountText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.paginationCountText.setTextLimit(9);
        this.paginationCountText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                DB2Preferences.this.validateUI();
            }
        });
        Label hostConfigLabel = new Label(secondPanel, 0);
        hostConfigLabel.setText(CommonBundle.HOST);
        this.hostNamesConfigPanel = new HostNamesConfigPanel(secondPanel, 0, this.getTitle());
        this.hostNamesConfigPanel.getAddButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DB2Preferences.this.validateUI();
            }
        });
        this.hostNamesConfigPanel.getRemoveButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DB2Preferences.this.validateUI();
            }
        });
        Label portLabel = new Label(secondPanel, 0);
        portLabel.setText(CommonBundle.PORT);
        NumberField<Integer> field = new NumberField<Integer>(secondPanel, 2048);
        field.setMinValue(1);
        field.setMaxValue(65535);
        this.portText = field.getWidget();
        this.portText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portText.setTextLimit(5);
        this.portText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                DB2Preferences.this.validateUI();
            }
        });
        this.caseSensitiveBtn = new Button(secondPanel, 32);
        this.caseSensitiveBtn.setText(CommonBundle.CASE_INSENSITIVE);
        this.caseSensitiveBtn.setSelection(false);
        new Label(secondPanel, 0);
        this.bindLastSaveDataToUI();
        return root;
    }

    private void bindLastSaveDataToUI() {
        try {
            Object[] subsystems = (String[])Context.get(Context.Keys.ACTIVE_SUBSYSTEMS);
            if (this.isLoggedIn && subsystems != null) {
                Arrays.sort(subsystems);
                this.subsystemList.setItems((String[])subsystems);
            }
            this.store.load();
            this.preferenceFileExists = true;
            String sqlId = this.store.getString("SQLID_PREF_KEY");
            sqlId = this.isLoggedIn && sqlId.isEmpty() ? Context.getInstance().getDefaultSQLID() : sqlId;
            this.sqlIdText.setText(sqlId);
            this.paginationCountText.setText(this.store.getString("SQL_PAGINATION_COUNT_PREF_KEY"));
            if (this.isLoggedIn) {
                String[] selectedSubsystems;
                String[] stringArray = selectedSubsystems = this.store.getString("SELECTED_SUBSYSTEMS_PREF_KEY").isEmpty() ? new String[]{} : this.store.getString("SELECTED_SUBSYSTEMS_PREF_KEY").split(",");
                if (selectedSubsystems.length == 0) {
                    this.subsystemList.selectAll();
                } else {
                    this.subsystemList.setSelection(selectedSubsystems);
                }
            }
            if (!this.store.getString("HOST_NAMES_PREF_KEY").isEmpty()) {
                this.hostNamesConfigPanel.setHostNames(this.store.getString("HOST_NAMES_PREF_KEY").split(","));
            }
            this.portText.setText(this.store.getString("PORT_NUM_PREF_KEY"));
            this.caseSensitiveBtn.setSelection(this.store.getBoolean("CASE_INSENSITIVE_PREF_KEY"));
        }
        catch (IOException iOException) {
            this.restoreDefaults();
        }
    }

    private void restoreDefaults() {
        this.sqlIdText.setText(Context.getInstance().getDefaultSQLID() == null ? "" : Context.getInstance().getDefaultSQLID());
        this.paginationCountText.setText(DEFAULT_PAGINATION_COUNT.toString());
        this.subsystemList.selectAll();
        this.validateUI();
    }

    private void saveProfileInfoToStore() {
        try {
            if (this.isLoggedIn) {
                this.store.putValue("SELECTED_SUBSYSTEMS_PREF_KEY", this.getSelectedItemsInCommaSeperatedString());
            }
            this.store.putValue("SQLID_PREF_KEY", this.sqlIdText.getText().toUpperCase());
            this.store.putValue("SQL_PAGINATION_COUNT_PREF_KEY", this.paginationCountText.getText());
            this.store.putValue("HOST_NAMES_PREF_KEY", this.toCommaSeperatedString(this.hostNamesConfigPanel.getHostNames()));
            this.store.putValue("PORT_NUM_PREF_KEY", this.portText.getText());
            this.store.putValue("CASE_INSENSITIVE_PREF_KEY", String.valueOf(this.caseSensitiveBtn.getSelection()));
            this.store.save();
        }
        catch (IOException e) {
            logger.error((Object)"Error occured while saving Login info to store", (Throwable)e);
        }
    }

    private String getSelectedItemsInCommaSeperatedString() {
        if (this.subsystemList.getItemCount() > 0) {
            String[] selectedItems = this.subsystemList.getSelectionCount() > 0 ? this.subsystemList.getSelection() : this.subsystemList.getItems();
            return this.toCommaSeperatedString(selectedItems);
        }
        return "";
    }

    private String toCommaSeperatedString(String[] arr) {
        StringBuffer items = new StringBuffer();
        if (arr != null) {
            String[] stringArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                items.append(s).append(",");
                ++n2;
            }
            return items.deleteCharAt(items.length() - 1).toString();
        }
        return items.toString();
    }

    public List<SubsystemNode> getSelectedSubsystems() {
        String[] selectedItems = this.subsystemList.getSelectionCount() > 0 ? this.subsystemList.getSelection() : this.subsystemList.getItems();
        ArrayList<SubsystemNode> activeSubsystems = new ArrayList<SubsystemNode>();
        String[] stringArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            activeSubsystems.add(new SubsystemNode(s, null));
            ++n2;
        }
        return activeSubsystems;
    }

    public boolean performOk() {
        this.apply();
        return true;
    }

    private void validateUI() {
        try {
            if (this.subsystemList.getItemCount() > 0 && this.subsystemList.getSelectionCount() == 0) {
                this.setErrorMessage(CommonBundle.ERR_PREF_SELECT_ONE_SSID);
                this.setValid(false);
            } else if (this.paginationCountText.getText().trim().isEmpty()) {
                this.setErrorMessage(CommonBundle.ERR_PREF_PAGINATION_COUNT_MISSING);
                this.setValid(false);
            } else if (Integer.parseInt(this.paginationCountText.getText().trim()) == 0) {
                this.setErrorMessage(CommonBundle.ERR_PREF_PAGINATION_COUNT_RANGE);
                this.setValid(false);
            } else if (Integer.parseInt(this.paginationCountText.getText().trim()) > 5000) {
                this.setErrorMessage(CommonBundle.PAGINATION_COUNT);
                this.setValid(false);
            } else if (this.hostNamesConfigPanel.getHostNames().length == 0) {
                this.setErrorMessage(CommonBundle.ERR_PREF_HOST_MISSING);
                this.setValid(false);
            } else if (this.portText.getText().trim().isEmpty()) {
                this.setErrorMessage(CommonBundle.ERR_PREF_PORT_MISSING);
                this.setValid(false);
            } else {
                this.setErrorMessage(null);
                this.setValid(true);
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(CommonBundle.ERR_MSG_PLEASE_ENTER_VALID_DATA);
            this.setValid(false);
        }
    }
}

