/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.ChangeManager;
import com.ca.db2.editor.views.comm.ViewCommUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.event.EventAdmin;

public class CMRollbackAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private ChangeManager changeManager;
    private String topic = "changemanager/ui";
    private String commandId = "com.ca.db2.editor.ui.actions.CMRollbackAction";

    public CMRollbackAction(ChangeManager changeManager) {
        super(CMBundle.ROLLBACK);
        this.setImageDescriptor(Images.DWROLLBACK);
        this.setChangeManager(changeManager);
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    public void setChangeManager(ChangeManager changeManager) {
        this.changeManager = changeManager;
    }

    public ChangeManager getChangeManager() {
        return this.changeManager;
    }

    @Override
    public void execute() {
        Map<ObjectIdentity, List<ChangeEntrySet>> entrySets = this.changeManager.getSelectedChangeEntrySets();
        this.publishEvent(entrySets);
        this.changeManager.removeEntries(entrySets);
        ObjectIdentity identity = entrySets.entrySet().iterator().next().getKey();
        if (CMUtils.getChangeSet(identity) == null) {
            DWUtils.getDataWindow(identity).setDirty(false);
        }
    }

    private EventAdmin publishEvent(Map<ObjectIdentity, List<ChangeEntrySet>> eventEntries) {
        ViewCommUtil viewCommUtil = new ViewCommUtil();
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.put(this.topic, eventEntries);
        return viewCommUtil.publishEventsOfView(((Object)((Object)this.changeManager.getParent())).getClass(), this.topic, eventProps, ViewCommUtil.EventType.SYNC);
    }

    @Override
    protected boolean checkPreConditions() {
        return this.changeManager.enableContextMenuActions();
    }
}

