/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.Grid;
import com.ca.db2.editor.ui.utils.Validator;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.views.DWView;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;

public class DWCopyRowsAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DWCopyRowsAction.class);
    private String commandId = "com.ca.db2.editor.ui.actions.DWCopyRowsAction";
    private DataWindowManager manager;
    private final String MESSAGE_ROWSCOPIED = " Row(s) copied ";
    private final String MESSAGE_TO = "to ";

    public DWCopyRowsAction(DataWindowManager manager) {
        super(DWBundle.LABEL_COPYROW, 1);
        this.manager = manager;
        this.setId(DWView.ACTION.COPY_ROWS.toString());
        this.registerKeyBinding(this.commandId, 65612);
    }

    @Override
    public void execute() {
        try {
            int rowsToAdd = 1;
            if (!this.getDataWindow().canRowsBeAdded(true)) {
                return;
            }
            RowModel rowModel = this.getDataWindow().getResultSetGrid().getSelectedRows()[0];
            InputDialog dialog = new InputDialog(null, DWBundle.LABEL_COPYROW_INPUT_TITLE, DWBundle.LABEL_COPYROW_INPUT, String.valueOf(rowsToAdd), (IInputValidator)Validator.numericValidator);
            dialog.open();
            if (dialog.getReturnCode() != 0) {
                return;
            }
            rowsToAdd = Integer.parseInt(dialog.getValue());
            int i = 0;
            while (i < rowsToAdd) {
                this.getDataWindow().copyRow(rowModel);
                ++i;
            }
            logger.info((Object)(String.valueOf(rowsToAdd) + " Row(s) copied " + "to " + this.getDataWindow().getIdentity()));
        }
        catch (Exception e) {
            logger.error((Object)"Problem while copying rows:", (Throwable)e);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    @Override
    protected boolean checkPreConditions() {
        boolean enable = false;
        Grid resultGrid = this.getDataWindow().getResultSetGrid();
        if (this.getDataWindow().isEditMode() && this.getDataWindow().isEditable() && this.getDataWindow().isRowSelected() && !resultGrid.getSelectedRows()[0].isAddableRow() && resultGrid.getRightMouseClickedColumn() == null) {
            enable = true;
        }
        return enable;
    }

    private DataWindow getDataWindow() {
        return this.manager.getSelectedDataWindow();
    }
}

