/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.Images;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class CMLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private final Image INSERT = Images.CM_INSERT.createImage();
    private final Image UPDATE = Images.CM_UPDATE.createImage();

    public void update(ViewerCell cell) {
        String value = this.getValue(cell);
        if (value != null) {
            StyledString text = new StyledString();
            text.append(value);
            text.append(this.suffix(cell), StyledString.DECORATIONS_STYLER);
            cell.setImage(this.getImage(cell));
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
        }
        super.update(cell);
    }

    private String getValue(ViewerCell cell) {
        if (CMUtils.isChangeSet(cell.getElement())) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    return ((BaseModel)cell.getElement()).getName();
                }
            }
        }
        if (CMUtils.isChangeEntrySet(cell.getElement())) {
            ChangeEntrySet entrySet = (ChangeEntrySet)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    return entrySet.getName();
                }
            }
        }
        if (CMUtils.isChangeEntry(cell.getElement())) {
            ChangeEntry entry = (ChangeEntry)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return entry.getColumnName();
                }
                case 2: {
                    return entry.getOriginalValue() != null ? entry.getOriginalValue().toString() : null;
                }
                case 3: {
                    return entry.getModifiedValue() != null ? entry.getModifiedValue().toString() : null;
                }
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public String getToolTipText(Object element) {
        return ((BaseModel)element).getTooltip();
    }

    private String suffix(ViewerCell cell) {
        if (cell.getElement() instanceof ChangeEntrySet && cell.getColumnIndex() == 0) {
            ChangeEntrySet entrySet = (ChangeEntrySet)cell.getElement();
            return "   [ " + entrySet.getChangeType().toString() + ", " + entrySet.getStatus().toString() + " ]";
        }
        return "";
    }

    private Image getImage(ViewerCell o) {
        if (o.getElement() instanceof ChangeEntrySet) {
            if (((ChangeEntrySet)o.getElement()).getChangeType() == ChangeEntrySet.ChangeType.INSERT) {
                return this.INSERT;
            }
            return this.UPDATE;
        }
        return null;
    }
}

