/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ChangeSet;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.ComponentUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.SQLGenerator;
import com.ca.db2.editor.ui.widgets.ChangeManager;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.views.CMView;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CMUtils {
    static final String cacopyright = "Copyright \u00a9 2016 CA";

    public static CMView getView() {
        return (CMView)CommonUtils.getView("ChangeManagerView");
    }

    public static ChangeManager getChangeManager() {
        return CMUtils.getView().getChangeManager();
    }

    public static ChangeManager getChangeManagerFocusUnchanged() {
        CMView view = (CMView)ComponentUtils.findView("ChangeManagerView");
        return view != null ? view.getChangeManager() : null;
    }

    public static ChangeSet getChangeSet(ObjectIdentity identity) {
        return CMUtils.getChangeSet(identity, CMUtils.getChangeManager().getData());
    }

    public static ChangeSet getChangeSet(ObjectIdentity identity, List<ChangeSet> changeSets) {
        for (ChangeSet o : changeSets) {
            if (!o.getIdentity().equals(identity)) continue;
            return o;
        }
        return null;
    }

    public static ChangeEntrySet getChangeEntrySet(int rowKey, List<ChangeEntrySet> entrySets) {
        for (ChangeEntrySet o : entrySets) {
            if (!o.getRowKey().equals(rowKey)) continue;
            return o;
        }
        return null;
    }

    public static ChangeEntry getChangeEntry(ChangeEntrySet entrySet, ChangeEntry entry) {
        for (ChangeEntry o : entrySet.getEntries()) {
            if (!o.equals(entry)) continue;
            return o;
        }
        return null;
    }

    public static ChangeSet getChangeSetByIdentity(ObjectIdentity identity, List<ChangeSet> changeSets) {
        for (ChangeSet o : changeSets) {
            if (!o.getIdentity().equals(identity)) continue;
            return o;
        }
        return null;
    }

    public static Map<Integer, String> generateSQLs(ObjectIdentity identity) {
        return CMUtils.generateSQLs(identity, CMUtils.getChangeSet(identity).getChangeEntrySets());
    }

    public static Map<Integer, String> generateSQLs(ObjectIdentity identity, List<ChangeEntrySet> entrySets) {
        LinkedHashMap<Integer, String> rowIndexSQLMap = new LinkedHashMap<Integer, String>();
        DataWindow dataWindow = DWUtils.getDataWindow(identity);
        List<ColumnModel> cm = dataWindow.getResultSetGrid().getTableModel().getColumnModels();
        ColumnModel[] models = cm.toArray(new ColumnModel[cm.size()]);
        for (ChangeEntrySet set : entrySets) {
            Object[] values = (Object[])dataWindow.getValues(set.getRowKey()).clone();
            ChangeEntry[] elements = set.getEntries().toArray(new ChangeEntry[set.getEntries().size()]);
            String SQL = null;
            SQL = set.getChangeType() == ChangeEntrySet.ChangeType.INSERT ? SQLGenerator.generateInsertQuery(identity, models, values) : SQLGenerator.generateUpdateQuery(identity, models, values, elements);
            rowIndexSQLMap.put(set.getRowKey(), SQL);
        }
        return rowIndexSQLMap;
    }

    public static boolean isChangeEntry(Object o) {
        return o instanceof ChangeEntry;
    }

    public static boolean isChangeSet(Object o) {
        return o instanceof ChangeSet;
    }

    public static boolean isChangeEntrySet(Object o) {
        return o instanceof ChangeEntrySet;
    }

    public static boolean containsChangeSets(ObjectIdentity identity) {
        ChangeManager changeManager = CMUtils.getChangeManagerFocusUnchanged();
        if (changeManager == null) {
            return false;
        }
        return CMUtils.getChangeSet(identity, changeManager.getData()) != null;
    }

    public static boolean containsChangeSets() {
        return CMUtils.getChangeManager().getData() != null && !CMUtils.getChangeManager().getData().isEmpty();
    }

    public static void addChangeEntrySet(ObjectIdentity identity, ChangeEntrySet entrySet) {
        CMUtils.getChangeManager().addEntrySet(identity, entrySet);
    }

    public static boolean commitChanges(ObjectIdentity identity) {
        return CMUtils.getChangeManager().commitChanges(identity);
    }

    public static void removeEntries(ObjectIdentity identity, Integer[] rowKeys) {
        CMUtils.getChangeManager().removeEntries(identity, rowKeys);
    }

    public static void removeAllEntries() {
        CMUtils.getChangeManager().removeAllEntries();
    }

    public static ChangeEntrySet getChangeEntrySet(ObjectIdentity identity, Integer rowKey) {
        ChangeSet changeSet = CMUtils.getChangeSet(identity);
        if (changeSet != null) {
            for (ChangeEntrySet entrySet : changeSet.getChangeEntrySets()) {
                if (!entrySet.getRowKey().equals(rowKey)) continue;
                return entrySet;
            }
        }
        return null;
    }

    public static List<ChangeEntry> getChangeEntries(ObjectIdentity identity, Integer rowKey) {
        ChangeEntrySet entrySet = CMUtils.getChangeEntrySet(identity, rowKey);
        return entrySet == null ? null : entrySet.getEntries();
    }

    public static void refreshChangeManager() {
        CMUtils.getChangeManager().refresh();
    }
}

