/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.CommonBundle;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.LayoutFilterObject;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.OrderByModel;
import com.ca.db2.editor.ui.model.SelectClauseModel;
import com.ca.db2.editor.ui.model.WhereClauseModel;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.FileUtils;
import com.ca.db2.editor.ui.utils.QueryUtils;
import com.ca.db2.editor.ui.utils.SQLGenerator;
import com.ca.db2.editor.ui.utils.SelectColumnValidator;
import com.ca.db2.editor.ui.widgets.ShuttleWidget;
import com.ca.db2.editor.ui.widgets.ShuttleWidgetBuilder;
import com.ca.db2.editor.ui.widgets.StyleModel;
import com.ca.db2.editor.ui.widgets.WhereClauseGrid;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DWLayoutFilterDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(DWLayoutFilterDialog.class);
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private List<ColumnModel> allColumns;
    private List<ColumnModel> selectedColumns;
    private List<ColumnModel> orderByColumns;
    private StyledText queryEditor;
    private ObjectIdentity identity;
    private String sql;
    private String SQLID;
    private String whereClause = "";
    private static final String WHERE = "WHERE";
    private ColumnModel singleSelectedItem;
    private WhereClauseGrid grid;
    private ExpandBar expandBar;
    private Clipboard cb;
    private final Color KEYWORD_COLOR = new Color(null, 127, 0, 85);
    private final Color VALUES_COLOR = new Color(null, 0, 0, 255);
    private final int BUTTON_ID_COPY_SQL = 92;
    private final int BUTTON_ID_RESET = 93;
    private List<StyleModel> styleModels = new ArrayList<StyleModel>();
    private StringBuffer sqlBuffer = null;
    private ShuttleWidget colSelectionShuttle;
    private ShuttleWidget orderByShuttle;
    private Button ascRadio;
    private Button descRadio;
    private LayoutFilterObject filterObj;
    private Map<String, Integer> allColNames;

    public DWLayoutFilterDialog(Shell parentShell, ObjectIdentity identity, List<ColumnModel> allColumns) {
        super(parentShell);
        this.setAllColumns(new ArrayList<ColumnModel>(allColumns));
        this.setIdentity(identity);
        this.setHelpAvailable(false);
        DWLayoutFilterDialog.setDialogHelpAvailable((boolean)false);
        this.SQLID = Context.getInstance().getSQLID(identity.getFQN());
    }

    public void create() {
        super.create();
        this.setMessage(DWBundle.FILTER_DIALOG_MSG, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayoutData((Object)new GridData(1808));
        this.expandBar = new ExpandBar(area, 512);
        this.expandBar.setSpacing(5);
        this.expandBar.setLayoutData((Object)new GridData(1808));
        this.createColumnSelectionComponent((Composite)this.expandBar);
        this.createWhereClauseComponent((Composite)this.expandBar);
        this.createOrderByComponent((Composite)this.expandBar);
        this.createQueryEditor((Composite)this.expandBar);
        this.cb = new Clipboard(null);
        return area;
    }

    protected boolean isResizable() {
        return false;
    }

    private void createColumnSelectionComponent(Composite container) {
        Composite control = new Composite(container, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        try {
            ArrayList<ColumnModel> availableItems = new ArrayList<ColumnModel>();
            ArrayList<ColumnModel> selectedItems = new ArrayList<ColumnModel>();
            if (this.filterObj != null) {
                SelectClauseModel selectClauseModel = this.filterObj.getSelectClauseModel();
                List<String> availableCols = selectClauseModel.getAvailableColumns();
                List<String> selectedCols = selectClauseModel.getSelectedColumns();
                int index = -1;
                for (String colName : selectedCols) {
                    index = this.allColNames.get(colName);
                    selectedItems.add(this.allColumns.get(index));
                }
                index = -1;
                for (String colName : availableCols) {
                    index = this.allColNames.get(colName);
                    availableItems.add(this.allColumns.get(index));
                }
                this.setSelectedColumns(selectedItems);
            } else {
                selectedItems.addAll(this.allColumns);
            }
            this.colSelectionShuttle = new ShuttleWidgetBuilder(control, selectedItems, availableItems).showButtonLabels().setListDimensions(310, 200).setValidator(new SelectColumnValidator()).build();
            ListViewer selectedListViewer = this.colSelectionShuttle.getSelectedListViewer();
            selectedListViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    List selectionList = DWLayoutFilterDialog.this.colSelectionShuttle.getSelectedItems();
                    DWLayoutFilterDialog.this.setSelectedColumns(selectionList);
                    DWLayoutFilterDialog.this.buildQuery();
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Exception in ColumnSelection", (Throwable)e);
        }
        this.createExpandItem((ExpandBar)container, "Column Selection", (Control)control, 4);
    }

    private void createWhereClauseComponent(Composite container) {
        Composite control = new Composite(container, 0);
        control.setLayout((Layout)new FillLayout());
        ColumnModel[] columnModels = this.allColumns.toArray(new ColumnModel[this.allColumns.size()]);
        List<WhereClauseModel> whereClauseModels = null;
        if (this.filterObj != null) {
            whereClauseModels = this.filterObj.getWhereClauseModels();
        }
        this.grid = new WhereClauseGrid(control, columnModels, whereClauseModels){

            @Override
            public String generateWhereClause() {
                String whereClause = super.generateWhereClause();
                DWLayoutFilterDialog.this.setWhereClause(whereClause);
                DWLayoutFilterDialog.this.buildQuery();
                return whereClause;
            }
        };
        if (this.filterObj != null) {
            this.grid.generateWhereClause();
        }
        ExpandItem item = this.createExpandItem((ExpandBar)container, DWBundle.WHERE_CLAUSE, (Control)control, 2);
        item.setHeight(200);
    }

    private void createOrderByComponent(Composite container) {
        Composite control = new Composite(container, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        try {
            if (this.filterObj == null) {
                this.setSelectedColumns(this.allColumns);
            }
            ArrayList<ColumnModel> availableItems = new ArrayList<ColumnModel>();
            ArrayList<ColumnModel> selectedItems = new ArrayList<ColumnModel>();
            OrderByModel orderByModel = null;
            if (this.filterObj != null) {
                orderByModel = this.filterObj.getOrderByModel();
                List<String> availableCols = orderByModel.getAvailableColumns();
                List<String> selectedCols = orderByModel.getSelectedColumns();
                int index = -1;
                int orderByIndex = 0;
                ColumnModel colModel = null;
                for (String colName : selectedCols) {
                    index = this.allColNames.get(colName);
                    colModel = this.allColumns.get(index);
                    if (!orderByModel.getOrderByAscs().isEmpty()) {
                        colModel.setOrderByAsc(orderByModel.getOrderByAscs().get(orderByIndex));
                        ++orderByIndex;
                    }
                    selectedItems.add(colModel);
                }
                index = -1;
                for (String colName : availableCols) {
                    index = this.allColNames.get(colName);
                    availableItems.add(this.allColumns.get(index));
                }
                this.setOrderByColumns(selectedItems);
            } else {
                availableItems.addAll(this.allColumns);
            }
            this.orderByShuttle = new ShuttleWidgetBuilder(control, selectedItems, availableItems).showButtonLabels().setListDimensions(310, 200).setPropertyName("displayLabel").build();
            Group radioBtnGroup = new Group(control, 0);
            radioBtnGroup.setText("Sort Order");
            radioBtnGroup.setLayout((Layout)new GridLayout(2, false));
            GridData gridData = new GridData(131072, 0x1000000, true, false);
            radioBtnGroup.setLayoutData((Object)gridData);
            this.ascRadio = new Button((Composite)radioBtnGroup, 16);
            this.ascRadio.setText("ASC");
            this.ascRadio.setEnabled(this.singleSelectedItem != null);
            this.ascRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DWLayoutFilterDialog.this.getSingleSelectedItem().setOrderByAsc(DWLayoutFilterDialog.this.ascRadio.getSelection());
                    DWLayoutFilterDialog.this.orderByShuttle.getSelectedListViewer().refresh();
                    DWLayoutFilterDialog.this.buildQuery();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DWLayoutFilterDialog.this.getSingleSelectedItem().setOrderByAsc(DWLayoutFilterDialog.this.ascRadio.getSelection());
                    DWLayoutFilterDialog.this.orderByShuttle.getSelectedListViewer().refresh();
                    DWLayoutFilterDialog.this.buildQuery();
                }
            });
            this.descRadio = new Button((Composite)radioBtnGroup, 16);
            this.descRadio.setText("DESC");
            this.descRadio.setEnabled(this.singleSelectedItem != null);
            this.descRadio.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DWLayoutFilterDialog.this.getSingleSelectedItem().setOrderByAsc(!DWLayoutFilterDialog.this.descRadio.getSelection());
                    DWLayoutFilterDialog.this.orderByShuttle.getSelectedListViewer().refresh();
                    DWLayoutFilterDialog.this.buildQuery();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DWLayoutFilterDialog.this.getSingleSelectedItem().setOrderByAsc(!DWLayoutFilterDialog.this.descRadio.getSelection());
                    DWLayoutFilterDialog.this.orderByShuttle.getSelectedListViewer().refresh();
                    DWLayoutFilterDialog.this.buildQuery();
                }
            });
            ListViewer selectedListViewer = this.orderByShuttle.getSelectedListViewer();
            selectedListViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    List selectionList = DWLayoutFilterDialog.this.orderByShuttle.getSelectedItems();
                    DWLayoutFilterDialog.this.setOrderByColumns(selectionList);
                    DWLayoutFilterDialog.this.setSingleSelectedItem(null);
                    boolean enableRadios = false;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty() && selection.size() == 1) {
                        ColumnModel column = (ColumnModel)selection.getFirstElement();
                        DWLayoutFilterDialog.this.setSingleSelectedItem(column);
                        enableRadios = true;
                        if (column.getOrderByAsc() != null) {
                            DWLayoutFilterDialog.this.ascRadio.setSelection(column.getOrderByAsc().booleanValue());
                            DWLayoutFilterDialog.this.descRadio.setSelection(column.getOrderByAsc() == false);
                        } else {
                            DWLayoutFilterDialog.this.ascRadio.setSelection(false);
                            DWLayoutFilterDialog.this.descRadio.setSelection(false);
                        }
                    } else {
                        DWLayoutFilterDialog.this.ascRadio.setSelection(false);
                        DWLayoutFilterDialog.this.descRadio.setSelection(false);
                    }
                    DWLayoutFilterDialog.this.ascRadio.setEnabled(enableRadios);
                    DWLayoutFilterDialog.this.descRadio.setEnabled(enableRadios);
                    DWLayoutFilterDialog.this.buildQuery();
                }
            });
            final ListViewer availableListViewer = this.orderByShuttle.getAvailableListViewer();
            availableListViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        Iterator itr = selection.iterator();
                        while (itr.hasNext()) {
                            ((ColumnModel)itr.next()).setOrderByAsc(null);
                        }
                        availableListViewer.refresh();
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Exception in OrderBy", (Throwable)e);
        }
        ExpandItem item = this.createExpandItem((ExpandBar)container, DWBundle.ORDER_BY, (Control)control, 3);
        item.setExpanded(false);
    }

    private void createQueryEditor(Composite container) {
        Composite control = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 1;
        layout.marginRight = 1;
        layout.marginTop = 1;
        layout.marginLeft = 1;
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        this.queryEditor = new StyledText(control, 770);
        this.queryEditor.setLayoutData((Object)new GridData(1808));
        this.queryEditor.setEditable(false);
        this.queryEditor.setFont(new Font(null, new FontData("Courier New", 10, 0)));
        this.queryEditor.setBackground(Display.getCurrent().getSystemColor(1));
        this.queryEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DWLayoutFilterDialog.this.getButton(0).setEnabled(!DWLayoutFilterDialog.this.queryEditor.getText().trim().isEmpty());
            }
        });
        ExpandItem item = this.createExpandItem((ExpandBar)container, DWBundle.QUERY_EDITOR, (Control)control, 4);
        item.setHeight(250);
    }

    private ExpandItem createExpandItem(ExpandBar bar, String text, Control control, int index) {
        ExpandItem item = new ExpandItem(bar, 0);
        item.setText(text);
        item.setHeight(control.computeSize((int)-1, (int)-1).y);
        item.setControl(control);
        item.setExpanded(true);
        return item;
    }

    public void setAllColumns(List<ColumnModel> allColumns) {
        this.allColumns = allColumns;
        this.allColNames = new HashMap<String, Integer>();
        int i = 0;
        while (i < allColumns.size()) {
            this.allColNames.put(allColumns.get(i).getName(), i);
            ++i;
        }
    }

    public List<ColumnModel> getAllColumns() {
        return this.allColumns;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSQLID(String SQLID) {
        this.SQLID = SQLID;
    }

    public String getSQLID() {
        return this.SQLID;
    }

    private void buildQuery() {
        if (this.queryEditor == null) {
            return;
        }
        this.styleModels.clear();
        this.sqlBuffer = new StringBuffer(this.getSelectClause());
        if (this.selectedColumns == null || this.selectedColumns.isEmpty()) {
            this.setSql("");
            this.queryEditor.setText(this.getSql());
        } else {
            this.sqlBuffer.append("\n\t");
            this.sqlBuffer.append(SQLGenerator.formatCreatorAndObjectName(this.identity));
            if (!this.getWhereClause().isEmpty()) {
                this.sqlBuffer.append("\n");
                this.styleModels.add(new StyleModel(this.sqlBuffer.length(), WHERE.length(), true));
                this.sqlBuffer.append(WHERE);
                this.sqlBuffer.append("\n\t");
                for (StyleModel m : this.grid.getStyleModels()) {
                    this.styleModels.add(new StyleModel(m.getStartIndex() + this.sqlBuffer.length(), m.getEndIndex(), m.isKeyword()));
                }
                this.sqlBuffer.append(this.getWhereClause());
            }
            if (this.orderByColumns != null && !this.orderByColumns.isEmpty()) {
                this.sqlBuffer.append("\n");
                this.styleModels.add(new StyleModel(this.sqlBuffer.length(), "ORDER BY".length(), true));
                this.sqlBuffer.append("ORDER BY");
                this.sqlBuffer.append("\n\t");
                for (ColumnModel model : this.orderByColumns) {
                    this.sqlBuffer.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(model.getName())));
                    if (model.getOrderByAsc() != null) {
                        this.styleModels.add(new StyleModel(this.sqlBuffer.length(), model.getOrderByAsc() != false ? 3 : 4, true));
                        this.sqlBuffer.append(model.getOrderByAsc() != false ? " ASC" : " DESC");
                    }
                    this.sqlBuffer.append(", ");
                }
                this.sqlBuffer.deleteCharAt(this.sqlBuffer.length() - 2);
            }
            this.queryEditor.setText(this.sqlBuffer.toString());
            this.setSql("\n" + this.queryEditor.getText());
            this.applyStylingToQuery();
        }
    }

    private String getSelectClause() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ").append("\n").append("\t");
        this.styleModels.add(new StyleModel(0, "SELECT ".length(), true));
        for (ColumnModel model : this.allColumns) {
            String columnName = QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(model.getName()));
            String colType = model.getColType();
            if (DataTypeUtils.isDate(colType) || DataTypeUtils.isTime(colType) || DataTypeUtils.isTimestamp(colType) || DataTypeUtils.isTimeSTZ(colType)) {
                columnName = "CHAR(" + columnName + ")";
            }
            buffer.append(columnName).append(", ");
        }
        buffer.deleteCharAt(buffer.length() - 2);
        this.styleModels.add(new StyleModel(buffer.length(), "FROM ".length(), true));
        buffer.append("\n").append("FROM ");
        return buffer.toString();
    }

    private void applyStylingToQuery() {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        for (StyleModel model : this.styleModels) {
            if (model.isKeyword()) {
                styleRanges.add(this.getKeywordStyle(model.getStartIndex(), model.getEndIndex()));
                continue;
            }
            styleRanges.add(this.getValueStyle(model.getStartIndex(), model.getEndIndex()));
        }
        this.queryEditor.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
    }

    public ObjectIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(ObjectIdentity identity) {
        this.identity = identity;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    protected Point getInitialSize() {
        return new Point(800, 976);
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(540, 100);
    }

    public void setSelectedColumns(List<ColumnModel> selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public List<ColumnModel> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setOrderByColumns(List<ColumnModel> orderByColumns) {
        this.orderByColumns = orderByColumns;
    }

    public List<ColumnModel> getOrderByColumns() {
        return this.orderByColumns;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.buildQuery();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.db2.editor.layoutfilter");
        return control;
    }

    private StyleRange getStyle(int startIndex, int endIndex, Color color) {
        Font font;
        StyleRange customStyle = new StyleRange();
        customStyle.start = startIndex;
        customStyle.length = endIndex;
        customStyle.foreground = color;
        customStyle.font = font = new Font(null, new FontData("Courier New", 10, 1));
        return customStyle;
    }

    private StyleRange getKeywordStyle(int startIndex, int endIndex) {
        return this.getStyle(startIndex, endIndex, this.KEYWORD_COLOR);
    }

    private StyleRange getValueStyle(int startIndex, int endIndex) {
        return this.getStyle(startIndex, endIndex, this.VALUES_COLOR);
    }

    public ColumnModel getSingleSelectedItem() {
        return this.singleSelectedItem;
    }

    public void setSingleSelectedItem(ColumnModel singleSelectedItem) {
        this.singleSelectedItem = singleSelectedItem;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label sqlIdLabel = new Label(comp, 0);
        sqlIdLabel.setText(CommonBundle.SQLID);
        final Text sqlIdText = new Text(comp, 2052);
        sqlIdText.setText(this.SQLID);
        sqlIdText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (sqlIdText.getText() == null || sqlIdText.getText().trim().isEmpty()) {
                    DWLayoutFilterDialog.this.getButton(0).setEnabled(false);
                } else {
                    DWLayoutFilterDialog.this.getButton(0).setEnabled(true);
                    DWLayoutFilterDialog.this.setSQLID(sqlIdText.getText());
                }
            }
        });
        this.createButton(parent, 93, DWBundle.RESET_BTN, false);
        this.createButton(parent, 92, DWBundle.COPY_SQL, false);
        super.createButtonsForButtonBar(parent);
        ++((GridLayout)parent.getLayout()).numColumns;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveFilter();
        } else if (buttonId == 93) {
            this.resetFilter();
        } else if (buttonId == 92) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.cb.setContents(new Object[]{this.getSql()}, new Transfer[]{textTransfer});
        }
        super.buttonPressed(buttonId);
    }

    private void saveFilter() {
        try {
            long t1 = System.currentTimeMillis();
            if (this.filterObj == null) {
                this.filterObj = new LayoutFilterObject();
            }
            this.filterObj.setAllColumns(this.allColumns);
            this.filterObj.setWhereClauseModels(this.grid.getModels());
            SelectClauseModel selectClauseModel = new SelectClauseModel();
            List selectedList1 = (List)this.colSelectionShuttle.getSelectedListViewer().getInput();
            ArrayList<String> selectedColNames1 = new ArrayList<String>();
            int index = 0;
            for (ColumnModel column : selectedList1) {
                selectedColNames1.add(column.getName());
                column.setVisible(true);
                column.setIndex(index++);
            }
            List availableList1 = (List)this.colSelectionShuttle.getAvailableListViewer().getInput();
            ArrayList<String> availableColNames1 = new ArrayList<String>();
            for (ColumnModel column : availableList1) {
                availableColNames1.add(column.getName());
                column.setVisible(false);
                column.setIndex(index++);
            }
            selectClauseModel.setSelectedColumns(selectedColNames1);
            selectClauseModel.setAvailableColumns(availableColNames1);
            this.filterObj.setSelectClauseModel(selectClauseModel);
            OrderByModel orderByModel = new OrderByModel();
            List selectedList2 = (List)this.orderByShuttle.getSelectedListViewer().getInput();
            ArrayList<String> selectedColNames2 = new ArrayList<String>();
            ArrayList<Boolean> orderByAscs = new ArrayList<Boolean>();
            for (ColumnModel column : selectedList2) {
                selectedColNames2.add(column.getName());
                orderByAscs.add(column.getOrderByAsc());
            }
            List availableList2 = (List)this.orderByShuttle.getAvailableListViewer().getInput();
            ArrayList<String> availableColNames2 = new ArrayList<String>();
            for (ColumnModel column : availableList2) {
                availableColNames2.add(column.getName());
            }
            orderByModel.setSelectedColumns(selectedColNames2);
            orderByModel.setAvailableColumns(availableColNames2);
            orderByModel.setOrderByAscs(orderByAscs);
            this.filterObj.setOrderByModel(orderByModel);
            long t2 = System.currentTimeMillis();
            StringBuffer filepath = new StringBuffer("filters").append("\\").append(this.identity.getSsid()).append("\\").append(this.identity.getCreator());
            FileUtils.makeDirectory(filepath.toString());
            filepath.append("\\").append(this.identity.getObjectName()).append(".xml");
            long t3 = System.currentTimeMillis();
            Context context = Context.getInstance();
            Marshaller marshaller = context.getMarshaller();
            if (marshaller == null) {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{LayoutFilterObject.class});
                marshaller = ctx.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                context.setMarshaller(marshaller);
            }
            marshaller.marshal((Object)this.filterObj, new File(filepath.toString()));
            long t4 = System.currentTimeMillis();
            logger.debug((Object)("Object creation took(ms):" + (t2 - t1)));
            logger.debug((Object)("File IO took(ms):" + (t3 - t2)));
            logger.debug((Object)("Marshalling took(ms):" + (t4 - t3)));
            logger.debug((Object)("Filter persistence took(ms):" + (t4 - t1)));
        }
        catch (JAXBException e) {
            logger.error((Object)"Problem while saving Layout-Filter", (Throwable)e);
        }
    }

    private void resetFilter() {
        List selectedList1 = (List)this.colSelectionShuttle.getSelectedListViewer().getInput();
        selectedList1.clear();
        selectedList1.addAll(new ArrayList<ColumnModel>(this.allColumns));
        this.colSelectionShuttle.getSelectedListViewer().refresh();
        List availableList1 = (List)this.colSelectionShuttle.getAvailableListViewer().getInput();
        availableList1.clear();
        this.colSelectionShuttle.getAvailableListViewer().refresh();
        this.setSelectedColumns(selectedList1);
        this.grid.getModels().clear();
        this.grid.addNewModel();
        List availableList2 = (List)this.orderByShuttle.getAvailableListViewer().getInput();
        availableList2.clear();
        availableList2.addAll(new ArrayList<ColumnModel>(this.allColumns));
        for (ColumnModel colModel : availableList2) {
            colModel.setOrderByAsc(null);
        }
        this.orderByShuttle.getAvailableListViewer().refresh();
        List selectedList2 = (List)this.orderByShuttle.getSelectedListViewer().getInput();
        selectedList2.clear();
        this.orderByShuttle.getSelectedListViewer().refresh();
        this.setOrderByColumns(selectedList2);
        this.ascRadio.setSelection(false);
        this.ascRadio.setEnabled(false);
        this.descRadio.setSelection(false);
        this.descRadio.setEnabled(false);
        this.grid.generateWhereClause();
    }

    public boolean close() {
        this.KEYWORD_COLOR.dispose();
        this.VALUES_COLOR.dispose();
        this.cb.dispose();
        this.grid.dispose();
        return super.close();
    }

    private String getColumnName(ColumnModel m) {
        if (m.getColType().trim().equals(DataType.FLOAT.toString())) {
            this.styleModels.add(new StyleModel(this.sqlBuffer.length(), 4, true));
            this.styleModels.add(new StyleModel(this.sqlBuffer.length() + 5 + m.getName().length() + 2, 2, true));
            return "CHAR(" + m.getName() + ") AS " + m.getName();
        }
        return m.getName();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DWBundle.FILTER_DIALOG_TITLE);
    }

    public LayoutFilterObject getFilterObj() {
        return this.filterObj;
    }

    public void setFilterObj(LayoutFilterObject filterObj) {
        this.filterObj = filterObj;
    }
}

