/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ChangeSet;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Grid;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.utils.Validator;
import com.ca.db2.editor.ui.widgets.ChangeManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataWindow
extends Composite {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DataWindow.class);
    static final String spaces = "                     ";
    private CLabel messageBar;
    private Label statusBar;
    private Text filterText;
    private Grid grid;
    private boolean editMode;
    private boolean editable;
    private boolean dirty;
    private List keyConstraints;
    private IDataSourceHandler dataSourceHandler;
    private Image WARN = Images.WARN.createImage();
    private Image INFO = Images.INFO.createImage();
    private Image ERROR = Images.ERROR.createImage();

    public DataWindow(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, false, 1, 1));
    }

    public void setMessageBar(CLabel messageBar) {
        this.messageBar = messageBar;
    }

    public CLabel getMessagePanel() {
        return this.messageBar;
    }

    public void setFilterText(Text filterText) {
        this.filterText = filterText;
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
    }

    public Grid getResultSetGrid() {
        return this.grid;
    }

    public ObjectIdentity getIdentity() {
        return this.grid.getIdentity();
    }

    public boolean hasAutoGeneratedIdentityColumn() {
        return this.grid.hasAutoGeneratedIdentityColumn();
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        DWUtils.getView().triggerUpdateforActions();
        if (this.statusBar != null) {
            this.updateStatusBar();
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean canRowsBeAdded(boolean showDialog) {
        if (!this.isEditable()) {
            if (showDialog) {
                MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, MsgDialogBundle.ERROR_ADDROW_MULTISOURCE_VIEW);
            } else {
                logger.info((Object)MsgDialogBundle.ERROR_ADDROW_MULTISOURCE_VIEW);
            }
            return false;
        }
        return true;
    }

    public boolean addRows() {
        InputDialog dialog = new InputDialog(null, DWBundle.LABEL_ADDROW_INPUT_TITLE, DWBundle.LABEL_ADDROW_INPUT, String.valueOf(1), (IInputValidator)Validator.numericValidator);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return false;
        }
        int rowsToAdd = Integer.parseInt(dialog.getValue());
        List<RowModel> rowModels = this.addNewRows(rowsToAdd);
        this.grid.reveal(rowModels.get(0));
        logger.info((Object)DWBundle.bind((String)DWBundle.MSG_ROWS_ADDED_TO_DW, (Object[])new Object[]{rowsToAdd, this.getIdentity()}));
        return true;
    }

    public List<RowModel> addNewRows(int numberOfRows) {
        List<RowModel> rowModels = this.grid.addNewRows(numberOfRows);
        for (RowModel model : rowModels) {
            this.addRowChangeEvent(model, ChangeEntrySet.ChangeType.INSERT);
        }
        return rowModels;
    }

    public Object[] getValues(int rowKey) {
        return this.grid.getRow(rowKey).getData();
    }

    public boolean isFilterApplied() {
        return !this.filterText.getText().isEmpty();
    }

    public boolean isRowSelected() {
        RowModel[] selectedRows = this.grid.getSelectedRows();
        return selectedRows != null && selectedRows.length == 1;
    }

    public void addRowChangeEvent(RowModel rowModel, ChangeEntrySet.ChangeType changeType) {
        ObjectIdentity identity = this.getIdentity();
        ChangeEntrySet entrySet = new ChangeEntrySet(identity, rowModel);
        entrySet.setChangeType(changeType);
        CMUtils.addChangeEntrySet(identity, entrySet);
        this.setDirty(true);
    }

    public void addColChangeEvent(RowModel rowModel, ColumnModel columnModel, int columnIndex, Object value) {
        ChangeEntry entry = new ChangeEntry();
        entry.setColumnName(columnModel.getName());
        entry.setOriginalValue(rowModel.getData()[columnIndex]);
        entry.setModifiedValue(value);
        entry.setColumnIndex(columnIndex);
        CMUtils.getChangeManager().addEntry(this.getResultSetGrid().getIdentity(), rowModel, entry);
        this.setDirty(true);
        CommonUtils.showView("ChangeManagerView");
    }

    public boolean canBeClosedOrRefreshed() {
        String objectName = this.getIdentity().getSimpleName();
        if (CMUtils.containsChangeSets(this.getIdentity())) {
            String confirmationMessage = NLS.bind((String)MsgDialogBundle.CONFIRM_CLOSING_TABLE_PENDING_CHANGES, (Object)objectName);
            int returnCode = MsgDialog.showQuestionDialogWithCancel(null, MsgDialogBundle.CONFIRM_DIALOG_DEFAULT_TITLE, confirmationMessage, 2);
            ChangeManager changeManager = CMUtils.getChangeManager();
            if (returnCode == 0) {
                boolean isCommitted = changeManager.commitChanges(this.getIdentity());
                if (!isCommitted) {
                    return false;
                }
            } else if (returnCode == 1) {
                boolean isRolledBack = changeManager.removeEntries(this.getIdentity());
                if (!isRolledBack) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public RowModel copyRow(RowModel rowModel) {
        RowModel copyInstance = this.grid.copyRow(rowModel);
        this.addRowChangeEvent(copyInstance, ChangeEntrySet.ChangeType.INSERT);
        return copyInstance;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        DWUtils.getView().triggerUpdateforActions();
        try {
            CTabItem tabItem = DWUtils.getDataWindowManager().getTabItem(this.getIdentity());
            if (tabItem != null) {
                String tabLabel = this.getIdentity().getSimpleName();
                if (dirty) {
                    tabLabel = "*" + tabLabel;
                }
                tabItem.setText(tabLabel);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean rollbackAllChanges() {
        try {
            ChangeSet changeSet = CMUtils.getChangeSet(this.getIdentity());
            List<ChangeEntrySet> changeEntrySets = changeSet.getChangeEntrySets();
            HashMap<ObjectIdentity, List<ChangeEntrySet>> changeEntrySetMap = new HashMap<ObjectIdentity, List<ChangeEntrySet>>();
            changeEntrySetMap.put(this.getIdentity(), changeEntrySets);
            this.rollbackChanges(changeEntrySetMap);
            CMUtils.getChangeManager().removeEntries(this.getIdentity());
        }
        catch (Exception e) {
            logger.error((Object)("Rollback operation failed for " + this.getIdentity()), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean rollbackChanges(Map<ObjectIdentity, List<ChangeEntrySet>> changeEntrySetMap) {
        if (changeEntrySetMap == null || changeEntrySetMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<ObjectIdentity, List<ChangeEntrySet>> entry : changeEntrySetMap.entrySet()) {
            List<ChangeEntrySet> changeEntrySets = entry.getValue();
            for (ChangeEntrySet changeEntrySet : changeEntrySets) {
                int changeRowKey = changeEntrySet.getRowKey();
                RowModel rowModel = this.grid.getRow(changeRowKey);
                if (changeEntrySet.getChangeType().equals((Object)ChangeEntrySet.ChangeType.INSERT)) {
                    this.grid.removeRow(rowModel);
                    continue;
                }
                if (!changeEntrySet.getChangeType().equals((Object)ChangeEntrySet.ChangeType.UPDATE)) continue;
                this.rollbackColumnData(changeEntrySet, changeRowKey);
            }
            this.grid.refreshUI();
        }
        return true;
    }

    private boolean rollbackColumnData(ChangeEntrySet changeEntrySet, int rowKey) {
        RowModel row = this.grid.getRow(rowKey);
        List<ChangeEntry> changeEntries = changeEntrySet.getEntries();
        for (ChangeEntry changeEntry : changeEntries) {
            row.getData()[changeEntry.getColumnIndex()] = changeEntry.getOriginalValue();
        }
        this.grid.getViewer().update(row, null);
        return true;
    }

    public void setKeyConstraints(List keyConstraints) {
        this.keyConstraints = keyConstraints;
    }

    public List getKeyConstraints() {
        return this.keyConstraints;
    }

    public boolean hasUniqueConstraints() throws FMDB2Exception {
        Map<Integer, List<Object>> result;
        block5: {
            if (this.keyConstraints != null) {
                return this.keyConstraints.size() > 0;
            }
            result = this.dataSourceHandler.fetchUniqueConstraints(this.getIdentity());
            this.keyConstraints = new ArrayList();
            if (result != null && result.size() >= 1) break block5;
            return false;
        }
        try {
            this.keyConstraints.addAll(result.values());
            return true;
        }
        catch (FMDB2Exception e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Problem while finding if object has unique constraints:", (Throwable)e);
            throw new FMDB2Exception(e.getMessage());
        }
    }

    public void showMessage(MsgType type, String msg) {
        MsgType msgType = type = type == null ? MsgType.INFO : type;
        if (type == MsgType.WARN) {
            this.messageBar.setImage(this.WARN);
        } else if (type == MsgType.INFO) {
            this.messageBar.setImage(this.INFO);
        } else if (type == MsgType.ERROR) {
            this.messageBar.setImage(this.ERROR);
        }
        this.messageBar.setText(msg);
    }

    public void clearMessagePanel() {
        this.messageBar.setText("");
    }

    public IDataSourceHandler getDataSourceHandler() {
        return this.dataSourceHandler;
    }

    public void setDataSourceHandler(IDataSourceHandler dataSourceHandler) {
        this.dataSourceHandler = dataSourceHandler;
    }

    public void paginate() {
        try {
            int rowKey = this.grid.getLastGeneratedRowKey() + 1;
            List<RowModel> rowModels = this.dataSourceHandler.paginate(this.getIdentity(), this.grid.getTableModel().getColumnModels());
            if (!rowModels.isEmpty()) {
                for (RowModel rm : rowModels) {
                    rm.setRowKey(rowKey++);
                }
                this.grid.addRows(rowModels);
                this.grid.refreshUI();
                this.grid.reveal(rowModels.get(0));
            }
        }
        catch (FMDB2Exception e) {
            logger.error((Object)("Problem while paginating for " + this.getIdentity()), (Throwable)e);
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
    }

    public Label getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(Label statusBar) {
        this.statusBar = statusBar;
        this.updateStatusBar();
    }

    private void updateStatusBar() {
        String mode = " Mode : " + (this.editMode ? "Edit     " : "Read-Only");
        String type = " Type : " + this.getIdentity().getObjectType().getTypeFullName();
        this.statusBar.setText(String.valueOf(mode) + spaces + type + spaces + this.getIdentity());
    }

    public void updateCellValue(ObjectIdentity identity, int rowKey, Map<String, Integer> generatedKeys) {
        this.grid.updateAutoGeneratedKeysFromDB(identity, rowKey, generatedKeys);
    }

    public void gotToFirstRow() {
        int rowKey = this.grid.getTableModel().getRowModels().get(0).getRowKey();
        this.grid.highlightRow(rowKey);
    }

    public void goToLastRow() {
        int size = this.grid.getTableModel().getRowModels().size();
        int rowKey = this.grid.getTableModel().getRowModels().get(size - 1).getRowKey();
        this.grid.highlightRow(rowKey);
    }

    public static enum MsgType {
        WARN,
        INFO,
        ERROR;

    }
}

