/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryUpdateTable;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DataUpdateMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.MFAddress;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class MemoryUpdate {
    private static final String EMPTY = "";
    private int errorLevel = 0;
    private int c;
    private int idx;
    private MFAddress celladdress;
    private DataUpdateMessage msg;
    private String chex;
    private String shex;
    private String cell;
    private String oldcell;
    private String password = "";
    private CVMI cvmi;
    private ArrayList<MemoryUpdateTable> tab;
    private debugSession session;

    public MemoryUpdate(debugSession session) {
        this.session = session;
        this.password = session.getMemoryUpdatePassword();
    }

    private void createMessage() {
        this.msg = new DataUpdateMessage();
        this.msg.setPassword(this.password);
        MFAddress addr = this.celladdress.add((long)(this.idx - this.cell.length() / 2));
        this.msg.setAddress(addr);
        byte[] bytes = new byte[this.cell.length() / 2];
        HexUtil.HextoBytes((String)this.cell, (byte[])bytes);
        this.msg.setHexdata(bytes);
        bytes = new byte[this.cell.length() / 2];
        HexUtil.HextoBytes((String)this.oldcell, (byte[])bytes);
        this.cvmi.addMessage((DebugMessage)this.msg);
        this.tab.add(new MemoryUpdateTable(this.cell, this.oldcell, addr));
        this.c = 0;
        this.cell = EMPTY;
        this.oldcell = EMPTY;
    }

    public void sendMemoryUpdateMessage(String coredata, String savedata, MFAddress address) {
        this.celladdress = address;
        this.tab = new ArrayList();
        DebugTalker talker = this.session.getTalker();
        this.password = this.session.getMemoryUpdatePassword();
        if (talker != null && !this.celladdress.equals((Object)MFAddress.ZERO_ADDR)) {
            CVMO cvmo = null;
            this.cvmi = new CVMI();
            this.cell = EMPTY;
            this.oldcell = EMPTY;
            this.c = 0;
            this.idx = 0;
            while (this.idx < coredata.length() / 2) {
                this.chex = coredata.substring(this.idx * 2, this.idx * 2 + 2);
                this.shex = savedata.substring(this.idx * 2, this.idx * 2 + 2);
                if (this.chex.equals(this.shex)) {
                    if (this.c > 0) {
                        this.createMessage();
                    }
                } else {
                    ++this.c;
                    this.cell = String.valueOf(this.cell) + this.chex;
                    this.oldcell = String.valueOf(this.oldcell) + this.shex;
                }
                ++this.idx;
            }
            if (this.c > 0) {
                this.createMessage();
            }
            try {
                cvmo = talker.process(this.cvmi);
                this.processCVMO(cvmo, this.tab);
                this.doNotifyListeners();
            }
            catch (Exception exception) {}
        }
    }

    private void processCVMO(CVMO cvmo, ArrayList<MemoryUpdateTable> tab) {
        this.errorLevel = 0;
        int ptr = 0;
        if (cvmo != null && cvmo.size() > 0) {
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                try {
                    int result = -1;
                    if (message.getMessageID() == 18) {
                        IStatusMessage msg = (IStatusMessage)message;
                        int seq = msg.getRequestseqno() - 1;
                        if (seq < 0) {
                            seq = ptr++;
                        }
                        MemoryUpdateTable detail = tab.get(seq);
                        MFAddress doubleAddr = detail.getCelladdr();
                        String smsg = String.format(Messages.MemoryUpdate_RESULT, detail.getOldcell(), detail.getHexcell(), doubleAddr.getAddrString());
                        result = msg.getStatus();
                        if (result > 0) {
                            detail.setSuccess(false);
                            ++this.errorLevel;
                            String errmsg = String.format(result == 20 ? Messages.MemoryUpdate_PASSWORD_REQD : Messages.MemoryUpdate_FAILED, smsg);
                            Logger.loggit(result, errmsg);
                            if (result == 20) {
                                MessageDialog.openError(null, (String)"Update Error", (String)"Memory request required password.\nIf you have access to the password, enter it in next dialog and repeat the memory request.");
                                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                                handlerService.executeCommand("com.ca.intertest.cics.command.password", null);
                            }
                        } else {
                            this.session.setMemoryUpdatePassword(this.password);
                            detail.setSuccess(true);
                            Logger.loggit(0, String.format(Messages.MemoryUpdate_SUCCEEDED, smsg));
                        }
                        tab.set(seq, detail);
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
                ++n2;
            }
        }
    }

    public void doNotifyListeners() {
        for (MemoryUpdateTable table : this.tab) {
            if (!table.getSuccessFlag()) continue;
            PropertyChangeEvent event = new PropertyChangeEvent((Object)table, "MEMORY_UPDATE", null, this.tab);
            this.session.firePropertyChangeListeners(event);
            for (debugFile item : this.session.getMonitored(true)) {
                item.firePropertyChangeListeners(event);
            }
        }
    }

    public boolean isError() {
        return this.errorLevel != 0;
    }
}

