/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class MonitorAction
implements IViewActionDelegate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IStructuredSelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        for (Object obj : this.selection.toList()) {
            debugFile debugfile;
            Object treeitem;
            if (!(obj instanceof IT_TreeItem) || !((treeitem = ((IT_TreeItem)obj).getObj()) instanceof debugFile)) continue;
            debugfile.setMonitor(!(debugfile = (debugFile)treeitem).isMonitor());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        IStructuredSelection sel = (IStructuredSelection)selection;
        for (Object obj : sel.toList()) {
            if (!(obj instanceof IT_TreeItem) || !((obj = ((IT_TreeItem)obj).getObj()) instanceof debugFile)) continue;
            debugFile file = (debugFile)obj;
            switch (file.getFiletype()) {
                case PROGID: {
                    if (file.isSubModule()) {
                        enabled = false;
                        break;
                    }
                    debugSession session = file.getSession();
                    if (session.isBatch() && session.isDebugging() && file.isMonitor()) {
                        enabled = false;
                        break;
                    }
                    enabled = true;
                    break;
                }
                default: {
                    enabled = true;
                }
            }
            if (file.isMonitor()) {
                action.setImageDescriptor(IntertestPlugin.getDefault().getImageRegistry().getDescriptor("MONITOR_OFF_ICON"));
                break;
            }
            action.setImageDescriptor(IntertestPlugin.getDefault().getImageRegistry().getDescriptor("MONITOR_ON_ICON"));
            break;
        }
        this.selection = enabled ? sel : null;
        action.setEnabled(enabled);
    }
}

