/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.ExecuteMessage;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.ui.lister.ListerEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ResetBPAction
extends Action
implements IUpdate {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private ListerEditor lister;
    private IVerticalRuler vRuler = null;
    private int statement = 0;
    debugSession session = null;

    public ResetBPAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.setText(Messages.ResetBPAction_0);
        this.setToolTipText(Messages.ResetBPAction_1);
        if (editor instanceof ListerEditor) {
            this.lister = (ListerEditor)editor;
        }
        if (rulerInfo instanceof IVerticalRuler) {
            this.vRuler = (IVerticalRuler)rulerInfo;
        }
        if (this.lister != null) {
            this.session = Debug.getInstance().getSession(this.lister.getResource());
        }
    }

    public void update() {
        this.setEnabled(this.session.isAtBreakpoint() && this.isValidStatement());
    }

    private boolean isValidStatement() {
        StatementType sType;
        this.statement = 0;
        int line = this.vRuler.getLineOfLastMouseButtonActivity();
        if (line++ < 0) {
            return false;
        }
        Statement stmt = this.lister.getOutline().hasLinenumber(line);
        if (stmt != null && ((sType = stmt.getType()) == StatementType.VERB || sType == StatementType.LABEL) && line == stmt.getLine()) {
            this.statement = stmt.getStatement();
            return true;
        }
        return false;
    }

    public void run() {
        if (this.session != null && this.session.isAtBreakpoint()) {
            DebugTalker talker = this.session.getTalker();
            BreakMessage breakmessage = talker.getBreakmessage();
            try {
                ExecuteMessage msg = new ExecuteMessage();
                msg.setMessageID((short)11);
                msg.setProgram(breakmessage.getProgram());
                msg.setStatement(this.statement);
                talker.processExecute(msg);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }
}

