/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.util;

import com.ca.intertest.common.Logger;
import com.ca.intertest.ui.lister.util.IListerTokenScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyleRange;

public abstract class AbstractPresentationRepairer
implements IPresentationRepairer {
    static String cacopyright = "Copyright (c) 2016 CA";
    private IDocument document;
    protected IListerTokenScanner scanner;
    private TextAttribute defaultTextAttribute = new TextAttribute(null);

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        int damageOffset = damage.getOffset();
        int damageLength = damage.getLength();
        String damageType = damage.getType();
        try {
            int firstLine = this.document.getLineOfOffset(damageOffset);
            int lastLine = this.document.getLineOfOffset(damageOffset + damageLength);
            int i = firstLine;
            while (i <= lastLine) {
                IToken token;
                IRegion line = this.document.getLineInformation(i);
                this.scanner.setPartialRange(this.document, line.getOffset(), line.getLength(), damageType, 0);
                while (!(token = this.scanner.nextToken()).isEOF()) {
                    int tokenOffset = this.scanner.getTokenOffset();
                    int tokenLength = this.scanner.getTokenLength();
                    TextAttribute textAttribute = this.getTokenAttribute(token);
                    this.addRange(presentation, tokenOffset, tokenLength, textAttribute);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            Logger.loggit(e);
        }
    }

    public TextAttribute getTokenAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.defaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            presentation.addStyleRange(styleRange);
        }
    }
}

