/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.preferences;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.MRUList;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.server.ServerList;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private BooleanFieldEditor clearit;
    private BooleanFieldEditor resetSize;
    private IntegerFieldEditor connecttime;
    private BooleanFieldEditor exitWithoutConfirmation;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.intertest"));
        this.setDescription(Messages.PreferencePage_description);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        IntegerFieldEditor localport = new IntegerFieldEditor("LISTENER_PORT", Messages.PreferencePage_listener_port, parent, 5);
        localport.setValidRange(0, 65534);
        localport.setTextLimit(5);
        Text text = localport.getTextControl(parent);
        text.setToolTipText(Messages.PreferencePage_port_tooltip);
        GridData data = (GridData)text.getLayoutData();
        GC gc = new GC((Drawable)text);
        try {
            Point extent = gc.textExtent("8");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.rightAlignLabel(parent, (FieldEditor)localport, null);
        this.addField((FieldEditor)localport);
        IntegerFieldEditor mru = new IntegerFieldEditor("PROTSYM.MAX_MRU", Messages.PreferencePage_max_list, parent, 5);
        mru.setValidRange(0, 99);
        mru.setTextLimit(2);
        text = mru.getTextControl(parent);
        data = (GridData)text.getLayoutData();
        gc = new GC((Drawable)text);
        try {
            Point extent = gc.textExtent("W");
            data.widthHint = 2 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        mru.getTextControl(parent).addVerifyListener((VerifyListener)new verifyDigit(false));
        this.rightAlignLabel(parent, (FieldEditor)mru, Messages.PreferencePage_max_list_tooltip);
        this.addField((FieldEditor)mru);
        this.clearit = new BooleanFieldEditor("MRU_CLEAR", Messages.PreferencePage_clear_mru, 1, parent);
        this.rightAlignLabel(parent, (FieldEditor)this.clearit, null);
        this.clearit.loadDefault();
        this.addField((FieldEditor)this.clearit);
        IntegerFieldEditor coresize = new IntegerFieldEditor("CORE_MEMLENGTH", Messages.PreferencePage_core_size, parent);
        coresize.setValidRange(24, 8192);
        coresize.setTextLimit(4);
        text = coresize.getTextControl(parent);
        text.setToolTipText(Messages.PreferencePage_core_size_tooltip);
        text.addVerifyListener((VerifyListener)new verifyDigit(false));
        data = (GridData)text.getLayoutData();
        gc = new GC((Drawable)text);
        try {
            Point extent = gc.textExtent("W");
            data.widthHint = 4 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.rightAlignLabel(parent, (FieldEditor)coresize, null);
        this.addField((FieldEditor)coresize);
        BooleanFieldEditor logging = new BooleanFieldEditor("logging", Messages.PreferencePage_logging, 1, parent);
        this.rightAlignLabel(parent, (FieldEditor)logging, null);
        this.addField((FieldEditor)logging);
        BooleanFieldEditor addrsize = new BooleanFieldEditor("addrsize", Messages.PreferencePage_addr_size, 1, parent);
        this.rightAlignLabel(parent, (FieldEditor)addrsize, null);
        this.addField((FieldEditor)addrsize);
        this.resetSize = new BooleanFieldEditor("SIZE_CLEAR", Messages.PreferencePage_0, 1, parent);
        this.rightAlignLabel(parent, (FieldEditor)this.resetSize, null);
        this.resetSize.loadDefault();
        this.addField((FieldEditor)this.resetSize);
        this.connecttime = new IntegerFieldEditor("DEFAULT_SERVER_CONNECT_TIMEOUT", Messages.PreferencePage_timeout, parent, 5);
        this.connecttime.setValidRange(-1, 99999);
        this.connecttime.setTextLimit(5);
        text = this.connecttime.getTextControl(parent);
        text.addVerifyListener((VerifyListener)new verifyDigit(false));
        text.setToolTipText(Messages.PreferencePage_1);
        data = (GridData)text.getLayoutData();
        gc = new GC((Drawable)text);
        try {
            Point extent = gc.textExtent("8");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.rightAlignLabel(parent, (FieldEditor)this.connecttime, null);
        this.addField((FieldEditor)this.connecttime);
        IntegerFieldEditor expressionLength = new IntegerFieldEditor("DATAVIEW_ASM_VAR_DEFAULT_LENGTH", Messages.PreferencePage_expression_length, parent, 2);
        expressionLength.setValidRange(24, 99);
        expressionLength.setTextLimit(2);
        text = expressionLength.getTextControl(parent);
        text.setToolTipText(Messages.PreferencePage_expression_length_tooltip);
        data = (GridData)text.getLayoutData();
        gc = new GC((Drawable)text);
        try {
            Point extent = gc.textExtent("8");
            data.widthHint = 2 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.rightAlignLabel(parent, (FieldEditor)expressionLength, null);
        this.addField((FieldEditor)expressionLength);
        this.exitWithoutConfirmation = new BooleanFieldEditor("EXIT_WITHOUT_CONFIRMATION", Messages.PreferencePage_confirmExit, 1, parent);
        this.rightAlignLabel(parent, (FieldEditor)this.exitWithoutConfirmation, null);
        this.addField((FieldEditor)this.exitWithoutConfirmation);
    }

    private void rightAlignLabel(Composite parent, FieldEditor editor, String tooltip) {
        Label label = editor.getLabelControl(parent);
        label.setAlignment(131072);
        GridData data = (GridData)label.getLayoutData();
        if (data == null) {
            data = new GridData();
            label.setLayoutData((Object)data);
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        ServerList.getInstance().setConnecttime(this.connecttime.getIntValue());
        boolean result = super.performOk();
        if (result) {
            if (this.clearit.getBooleanValue()) {
                MRUList names = new MRUList("PROTSYM");
                names.clear();
                this.getPreferenceStore().setValue("MRU_CLEAR", false);
            }
            if (this.resetSize.getBooleanValue()) {
                this.getPreferenceStore().setValue("SIZE_CLEAR", false);
                IDialogSettings workbenchSettings = IntertestPlugin.getDefault().getDialogSettings();
                if (workbenchSettings != null) {
                    this.resetSizes(workbenchSettings);
                }
            }
        }
        return result;
    }

    private void resetSizes(IDialogSettings settings) {
        if (settings.get("class_length") != null) {
            settings.put("class_length", 0L);
        }
        IDialogSettings[] iDialogSettingsArray = settings.getSections();
        int n = iDialogSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings child = iDialogSettingsArray[n2];
            this.resetSizes(child);
            ++n2;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
    }
}

