/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Structures;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.ViewData;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class SessionViewData
extends ViewData {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected IResourceChangeListener resourcelistener;
    private IDebugListener debuglistener;

    public SessionViewData(IResource resource, AbstractDataViewPage viewpage) {
        super(resource, viewpage);
        this.refreshed = false;
        this.resourcelistener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] markerdeltas = event.findMarkerDeltas("com.ca.intertest.keep", false);
                TreeObject[] objects = null;
                IMarkerDelta[] iMarkerDeltaArray = markerdeltas;
                int n = markerdeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta element = iMarkerDeltaArray[n2];
                    if (element.getResource().equals((Object)SessionViewData.this.debugitem.getResource())) {
                        IMarker marker = element.getMarker();
                        switch (element.getKind()) {
                            case 1: {
                                TreeObject item;
                                objects = SessionViewData.this.makeTreeObjects(marker);
                                boolean changed = false;
                                TreeObject[] treeObjectArray = objects;
                                int n3 = objects.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    item = treeObjectArray[n4];
                                    if (!SessionViewData.this.keepObjects.contains(item)) {
                                        item.setAttribute(SessionViewData.this.UniqueKey, Long.toString(marker.getId()));
                                        if (SessionViewData.this.addObject(item)) {
                                            changed = true;
                                            SessionViewData.this.fetchBackingData(item);
                                        }
                                    }
                                    ++n4;
                                }
                                if (!changed) break;
                                Object[] elements = SessionViewData.this.viewer.getExpandedElements();
                                TreePath[] treePaths = SessionViewData.this.viewer.getExpandedTreePaths();
                                SessionViewData.this.fetchBackingData(true);
                                SessionViewData.this.viewer.refresh();
                                SessionViewData.this.viewer.setExpandedElements(elements);
                                SessionViewData.this.viewer.setExpandedTreePaths(treePaths);
                                break;
                            }
                            case 2: {
                                TreeObject item;
                                TreeObject[] treeObjectArray = objects = SessionViewData.this.getTreeObjects(element.getAttribute("name", ""));
                                int n3 = objects.length;
                                int n5 = 0;
                                while (n5 < n3) {
                                    item = treeObjectArray[n5];
                                    SessionViewData.this.removeObject(item);
                                    SessionViewData.this.viewer.remove((Object)item);
                                    ++n5;
                                }
                                break;
                            }
                            case 4: {
                                TreeObject item;
                                TreeObject[] treeObjectArray = objects = SessionViewData.this.getTreeObjects(element.getAttribute("name", ""));
                                int n3 = objects.length;
                                int n6 = 0;
                                while (n6 < n3) {
                                    item = treeObjectArray[n6];
                                    SessionViewData.this.viewer.refresh((Object)item, true);
                                    ++n6;
                                }
                                break;
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourcelistener, 1);
        this.debuglistener = new IDebugListener(){

            @Override
            public void debugEventOccured(final debugEvent event) {
                if (SessionViewData.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Display display = Display.getDefault();
                if (display != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object source = event.getSource();
                            if (source instanceof CVMO) {
                                SessionViewData.this.fetchBackingData(true);
                            } else if (source instanceof CVMI) {
                                for (TreeObject item : (this).SessionViewData.this.keepObjects) {
                                    item.nullBackingdata();
                                }
                            }
                        }
                    });
                }
            }
        };
        this.debugitem.addDebugListener(this.debuglistener);
    }

    @Override
    public void sendMemoryMessage(TreeObject treeobject, TreeObject parent) {
    }

    public TreeObject getKeywordObject(String name, IMarker marker) {
        TreeObject treeobject = null;
        if (name == null || name.trim().length() < 1) {
            return treeobject;
        }
        String servertype = marker.getAttribute("servertype", "");
        String keeptype = marker.getAttribute("keeptype", "");
        String version = marker.getAttribute("serverversion", "");
        String keyword = marker.getAttribute("keyword", "");
        String altname = marker.getAttribute("altname", "");
        try {
            if (keeptype.equals("DATAVIEW_EXPRESSION")) {
                treeobject = Expressions.getTree(keyword, "CORE_EXPRESSION");
            } else {
                treeobject = version.length() > 0 ? Keywords.getTree(keyword, servertype, version) : Structures.getTree(altname, 1, this.session);
                treeobject.setAttribute("dataflag", "DATAVIEW_KEYWORD");
            }
            treeobject.setAttribute("isclean", "true");
            treeobject.setAlternateName(altname);
            treeobject.setKeyword(keyword);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return treeobject;
    }

    private TreeObject[] makeTreeObjects(IMarker marker) {
        if (marker.exists() && (marker.getAttribute("keeptype", "").equals("DATAVIEW_EXPRESSION") || marker.getAttribute("keeptype", "").equals("DATAVIEW_KEYWORD"))) {
            String postView = marker.getAttribute("postview", "");
            if (postView == "" || postView.equals("com.ca.intertest.ui.views.sessionview")) {
                TreeObject treeobject = this.getKeywordObject(marker.getAttribute("name", ""), marker);
                if (treeobject != null) {
                    return new TreeObject[]{treeobject};
                }
            } else {
                return new TreeObject[0];
            }
        }
        return new TreeObject[0];
    }

    @Override
    public TreeObject[] findObjects(String name) {
        return null;
    }

    @Override
    public boolean deleteObject(TreeObject treeobject) {
        boolean result = false;
        String markerid = treeobject.getAttribute(this.getUniqueKey());
        if (markerid != null) {
            try {
                long id = Long.parseLong(markerid);
                IMarker marker = this.debugitem.getResource().getMarker(id);
                if (marker != null && marker.exists()) {
                    marker.delete();
                    result = true;
                }
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        return result;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        try {
            IMarker[] markers;
            this.keepObjects.clear();
            IMarker[] iMarkerArray = markers = this.debugitem.getResource().findMarkers("com.ca.intertest.keep", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttribute("postview", "").equals("com.ca.intertest.ui.views.sessionview")) {
                    TreeObject[] objects;
                    TreeObject[] treeObjectArray = objects = this.makeTreeObjects(marker);
                    int n3 = objects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeObject item = treeObjectArray[n4];
                        item.setAttribute(this.UniqueKey, Long.toString(marker.getId()));
                        this.addObject(item);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
        this.fetchBackingData(false);
        return this.keepObjects.toArray(new Object[this.keepObjects.size()]);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected TreeObject[] getTreeObjects(String name) {
        ArrayList<TreeObject> list = new ArrayList<TreeObject>();
        for (TreeObject item : this.keepObjects) {
            boolean exprFlag = item.getAttribute("dataflag").equals("CORE_EXPRESSION");
            if (!exprFlag) {
                exprFlag = item.getAttribute("dataflag").equals("DATAVIEW_KEYWORD");
            }
            if (!exprFlag || !name.equals(item.getName())) continue;
            list.add(item);
        }
        return list.toArray(new TreeObject[list.size()]);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourcelistener);
        this.debugitem.removeDebugListener(this.debuglistener);
        super.dispose();
    }
}

