/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.debugMarkerGroup;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.wizards.AbstractSettingsPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractSettingsWizard
extends Wizard {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected debugSession session = null;
    protected HashMap<String, String> settings;
    protected boolean submit = false;
    protected ServerElement debugServer = null;
    protected FileServer fileServer = null;

    public AbstractSettingsWizard(debugSession session, boolean submit) {
        this.session = session;
        this.submit = submit;
        this.setWindowTitle(Messages.AbstractSettingsWizard_0);
        this.refreshAttributes();
        this.fileServer = session.getFileServer();
        this.debugServer = session.getDebugServer();
    }

    public void refreshAttributes() {
        HashMap<String, String> attrs = this.session.getStore().getAttributes();
        if (this.settings == null) {
            this.settings = new HashMap(attrs.size());
        } else {
            this.settings.clear();
        }
        this.settings.putAll(attrs);
    }

    public abstract void addPages();

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public debugSession getSession() {
        return this.session;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    public void buttonPressed(int buttonID) {
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performFinish() {
        ((AbstractSettingsPage)this.getStartingPage()).saveSettings();
        ResourceProperty store = this.session.getStore();
        for (Map.Entry<String, String> item : this.settings.entrySet()) {
            String backtrace;
            String key = item.getKey();
            String oldvalue = store.getString(key);
            String newvalue = item.getValue();
            if (oldvalue != null && oldvalue.equals(newvalue)) continue;
            store.setValue(key, newvalue);
            if (key.equals("back_trace")) {
                try {
                    this.session.addStatementTrace(this.session, true);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!key.equals("data_monitor") || !Boolean.parseBoolean(backtrace = this.settings.get("back_trace"))) continue;
            try {
                this.session.addDataMonitor(this.session, true);
            }
            catch (Exception exception) {}
        }
        this.session.setFileServer(this.fileServer);
        this.session.setDebugServer(this.debugServer);
        String stepafter = this.settings.get("step_after");
        this.session.setAfter(Boolean.parseBoolean(stepafter));
        store.save();
        try {
            this.session.post(null);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return true;
    }

    public boolean containsKey(String key) {
        return this.settings.containsKey(key);
    }

    public String get(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        return "";
    }

    public String put(String key, String value) {
        return this.settings.put(key, value);
    }

    public debugMarkerGroup getMarkergroup() {
        return this.session.getMarkergroup();
    }

    public ServerElement getDebugServer() {
        return this.debugServer;
    }

    public FileServer getFileServer() {
        return this.fileServer;
    }

    public void setDebugServer(ServerElement debugServer) {
        this.debugServer = debugServer;
    }

    public void setFileServer(FileServer fileServer) {
        this.fileServer = fileServer;
    }

    public boolean performSubmit() {
        boolean ok = true;
        if (this.canSubmit() && this.canFinish()) {
            ok = this.performFinish();
        }
        if (ok) {
            return this.canSubmit();
        }
        return false;
    }

    public boolean canSubmit() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (!((AbstractSettingsPage)page).canSubmit()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Image getDefaultPageImage() {
        ImageDescriptor newimage = IntertestPlugin.getDefault().getImageRegistry().getDescriptor("BANNER_ICON_BREAKPOINT");
        if (newimage != null) {
            return newimage.createImage(true);
        }
        return super.getDefaultPageImage();
    }
}

