/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class IntertestWizardDialog
extends WizardDialog {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private IDialogSettings dialogSettings = null;
    private boolean first = true;
    private static final Bundle bundle = IntertestPlugin.getDefault().getBundle();
    private static final int BUF_SIZE = 4096;
    private int boundsStrategy = -1;

    public IntertestWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        if (newWizard instanceof Wizard) {
            this.dialogSettings = newWizard.getDialogSettings();
            if (this.dialogSettings == null) {
                String name = newWizard.getClass().getSimpleName();
                IDialogSettings workbenchSettings = IntertestPlugin.getDefault().getDialogSettings();
                this.dialogSettings = workbenchSettings.getSection(name);
                if (this.dialogSettings == null) {
                    this.dialogSettings = workbenchSettings.addNewSection(name);
                }
                ((Wizard)newWizard).setDialogSettings(this.dialogSettings);
            }
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.dialogSettings != null) {
            return this.dialogSettings;
        }
        return super.getDialogBoundsSettings();
    }

    public Button getButton(int id) {
        return super.getButton(id);
    }

    public void finishPressed() {
        super.finishPressed();
    }

    protected void initializeBounds() {
        super.initializeBounds();
    }

    protected int getDialogBoundsStrategy() {
        long oldlength = 0L;
        this.boundsStrategy = super.getDialogBoundsStrategy();
        IWizard wizard = this.getWizard();
        byte[] buf = new byte[4096];
        IWizardPage[] iWizardPageArray = wizard.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IWizardPage page = iWizardPageArray[n2];
                Class<?> pageclass = page.getClass();
                String shortname = pageclass.getSimpleName();
                IDialogSettings programsettings = this.dialogSettings.getSection(shortname);
                if (programsettings == null) {
                    programsettings = this.dialogSettings.addNewSection(shortname);
                }
                try {
                    oldlength = programsettings.getLong("class_length");
                }
                catch (NumberFormatException numberFormatException) {
                    oldlength = 0L;
                }
                if (this.first || oldlength == 0L) {
                    String name = pageclass.getName();
                    String urlname = String.valueOf(name.replace('.', '/')) + ".class";
                    URL url = bundle.getEntry(urlname);
                    if (url == null) {
                        urlname = "bin/" + urlname;
                        url = bundle.getEntry(urlname);
                    }
                    if (url != null) {
                        try {
                            InputStream stream = url.openStream();
                            long length = 1L;
                            int readcount = 0;
                            while (readcount != -1) {
                                readcount = stream.read(buf, 0, 4096);
                                length += (long)readcount;
                            }
                            if (length != oldlength) {
                                programsettings.put("class_length", length);
                                this.boundsStrategy = 0;
                                break;
                            }
                            break block11;
                        }
                        catch (IOException e) {
                            Logger.loggit(e);
                            break block11;
                        }
                    }
                    Logger.loggit(0, String.format("could not locate %1$s in %2$s", urlname, bundle.toString()));
                }
            }
            ++n2;
        }
        this.first = false;
        return this.boundsStrategy;
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }
}

