/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.dialogs.SchedulingChangeDialog;
import com.ca.intertest.dialogs.SchedulingDatasetDialog;
import com.ca.intertest.server.BatchConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.SchedulingTransferMessage;
import com.ca.intertest.wizards.SchedulingData;
import com.ca.intertest.wizards.SchedulingRow;
import com.ca.intertest.wizards.SchedulingWizard;
import com.ca.testingtools.common.TTException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class SchedulingPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    static final String EMPTY_MSG = "NO MATCHING SCHEDULE";
    static final int DELETE = 4;
    static final int ADD = 0;
    static final int CHANGE = 8;
    static final int NEWROW = 12;
    static final short IMPORT = 0;
    static final short EXPORT = 1;
    private static final int SCROLL_LINES = 5;
    private static int pbLth = 80;
    static final String COL_WIDTH = "column_width";
    private Combo servers;
    private ArrayList<FileServer> serverlist;
    private FileServer server = null;
    private String dsn = "";
    private String member = "";
    private String filetype = "";
    private static final String MRU_DATABASE = "MRU_DATABASE";
    private static final String SOURCE = "SOURCE";
    private static final String MEMBER = "MEMBER";
    private static final String FILETYPE = "settingsDSNType";
    private SchedulingWizard wizard;
    private IDialogSettings settings;
    private Action doubleClickAction;
    private Group group;
    private GridData gridData;
    private Button db2RadioButton;
    private Button imsRadioButton;
    private boolean isDB2 = true;
    private boolean isEmpty = true;
    private boolean autoRefresh = false;
    private Button insertPush;
    private Button deletePush;
    private Button changePush;
    private Button importPush;
    private Button exportPush;
    private SchedulingData rowData;
    private TableViewer tableViewer;
    private Table table;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.schedulingPage";
    private final int JOBNAME = 0;
    private final int PROGRAM = 1;
    private final int ONETIME = 2;
    private final int DATABASE = 3;
    private final int USERID = 4;
    private final int TRANSACTION = 5;
    protected int[] order;
    protected int[] COLUMN_WIDTHS;
    protected int[] width;
    private final String JOBNAME_COLUMN;
    private final String PROGRAM_COLUMN;
    private final String ONETIME_COLUMN;
    private final String DATABASE_COLUMN;
    private final String USERID_COLUMN;
    private final String TRANSACTION_COLUMN;
    private String[] columnNames;

    protected SchedulingPage(String pageName) {
        super(pageName);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.order = nArray;
        this.COLUMN_WIDTHS = new int[]{15, 15, 10, 20, 15, 15};
        this.width = null;
        this.JOBNAME_COLUMN = Messages.SchedulingPage_5;
        this.PROGRAM_COLUMN = Messages.SchedulingPage_6;
        this.ONETIME_COLUMN = Messages.SchedulingPage_7;
        this.DATABASE_COLUMN = Messages.SchedulingPage_8;
        this.USERID_COLUMN = Messages.SchedulingPage_95;
        this.TRANSACTION_COLUMN = Messages.SchedulingPage_96;
        this.columnNames = new String[]{this.JOBNAME_COLUMN, this.PROGRAM_COLUMN, this.ONETIME_COLUMN, this.DATABASE_COLUMN, this.USERID_COLUMN, this.TRANSACTION_COLUMN};
    }

    public void createControl(Composite parent) {
        this.wizard = (SchedulingWizard)this.getWizard();
        this.settings = this.wizard.getDialogSettings();
        this.isDB2 = this.settings.getBoolean(MRU_DATABASE);
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        this.checkWidth(control);
        GridLayout gridLayout = new GridLayout(1, true);
        control.setLayout((Layout)gridLayout);
        this.serverlist = ServerList.getInstance().getFileServers();
        this.createServersGroup(control);
        this.createTypeGroup(control);
        this.createButtonsGroup(control);
        this.createTable(control);
        this.createColumnSorter();
        this.servers.forceFocus();
        this.servers.addSelectionListener((SelectionListener)this);
        this.setTitle(Messages.SchedulingPage_9);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.schedulingPage");
    }

    private void createServersGroup(Composite parent) {
        this.group = new Group(parent, 16);
        this.group.setLayout((Layout)new GridLayout(1, true));
        this.group.setText(Messages.SchedulingPage_10);
        this.servers = new Combo((Composite)this.group, 2060);
        int defaultIndex = -1;
        int availableIndex = -1;
        int numAvailable = 0;
        for (FileServer item : this.serverlist) {
            this.servers.add(item.getName());
            if (!item.getStatusText().equalsIgnoreCase("Available")) continue;
            ++numAvailable;
            if (item.isDefaultserver()) {
                defaultIndex = this.servers.indexOf(item.getName());
                continue;
            }
            if (numAvailable != 1) continue;
            availableIndex = this.servers.indexOf(item.getName());
        }
        if (defaultIndex >= 0) {
            this.servers.select(defaultIndex);
            this.autoRefresh = true;
        } else if (this.servers.getItemCount() == 1) {
            this.servers.select(0);
            this.autoRefresh = true;
            ServerList.getInstance().getServer(this.servers.getItem(0)).setDefaultserver(true);
        } else if (numAvailable == 1) {
            this.servers.select(availableIndex);
            this.autoRefresh = true;
        } else {
            this.servers.select(-1);
            this.autoRefresh = false;
        }
    }

    private void createTypeGroup(Composite parent) {
        this.group = new Group(parent, 16);
        this.group.setLayout((Layout)new GridLayout(2, true));
        this.group.setText(Messages.SchedulingPage_11);
        this.gridData = new GridData(32);
        this.group.setLayoutData((Object)this.gridData);
        this.db2RadioButton = new Button((Composite)this.group, 16);
        this.db2RadioButton.setText(Messages.SchedulingPage_12);
        this.db2RadioButton.setSelection(this.isDB2);
        this.db2RadioButton.setEnabled(false);
        this.gridData = new GridData(4, 2, true, false, 1, 1);
        this.gridData.widthHint = 80;
        this.db2RadioButton.setLayoutData((Object)this.gridData);
        this.db2RadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SchedulingPage.this.isDB2) {
                    SchedulingPage.this.isDB2 = true;
                    SchedulingPage.this.setTitle(Messages.SchedulingPage_13);
                    SchedulingPage.this.setDescription(" ");
                    SchedulingPage.this.rowData = new SchedulingData();
                    SchedulingPage.this.doFetchRequest(true);
                }
            }
        });
        this.imsRadioButton = new Button((Composite)this.group, 16);
        this.imsRadioButton.setText(Messages.SchedulingPage_15);
        this.imsRadioButton.setSelection(!this.isDB2);
        this.imsRadioButton.setEnabled(false);
        this.gridData = new GridData(4, 2, true, false, 1, 1);
        this.gridData.widthHint = 80;
        this.imsRadioButton.setLayoutData((Object)this.gridData);
        this.imsRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchedulingPage.this.isDB2) {
                    SchedulingPage.this.isDB2 = false;
                    SchedulingPage.this.setTitle(Messages.SchedulingPage_16);
                    SchedulingPage.this.setDescription(" ");
                    SchedulingPage.this.rowData = new SchedulingData();
                    SchedulingPage.this.doFetchRequest(true);
                }
            }
        });
        if (this.autoRefresh) {
            this.db2RadioButton.setEnabled(true);
            this.imsRadioButton.setEnabled(true);
        }
    }

    private void createButtonsGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.SchedulingPage_18);
        GridLayout groupLayout = new GridLayout(5, false);
        this.group.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.group.setLayoutData((Object)this.gridData);
        this.insertPush = new Button((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.gridData.widthHint = pbLth;
        this.insertPush.setLayoutData((Object)this.gridData);
        this.insertPush.setText(Messages.SchedulingPage_19);
        this.insertPush.setEnabled(false);
        this.insertPush.setToolTipText(Messages.SchedulingPage_20);
        this.insertPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulingPage.this.setErrorMessage(null);
                SchedulingPage.this.setDescription(" ");
                SchedulingPage.this.doInsertRequest();
            }
        });
        this.deletePush = new Button((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.gridData.widthHint = pbLth;
        this.deletePush.setLayoutData((Object)this.gridData);
        this.deletePush.setText(Messages.SchedulingPage_22);
        this.deletePush.setEnabled(false);
        this.deletePush.setToolTipText(Messages.SchedulingPage_23);
        this.deletePush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulingPage.this.setErrorMessage(null);
                SchedulingPage.this.setDescription(" ");
                SchedulingPage.this.doDeleteRequest();
            }
        });
        this.changePush = new Button((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.gridData.widthHint = pbLth;
        this.changePush.setLayoutData((Object)this.gridData);
        this.changePush.setText(Messages.SchedulingPage_25);
        this.changePush.setEnabled(false);
        this.changePush.setToolTipText(Messages.SchedulingPage_26);
        this.changePush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulingPage.this.setErrorMessage(null);
                SchedulingPage.this.setDescription(" ");
                SchedulingPage.this.doChangeRequest();
            }
        });
        this.importPush = new Button((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.gridData.widthHint = pbLth;
        this.importPush.setLayoutData((Object)this.gridData);
        this.importPush.setText(Messages.SchedulingPage_28);
        this.importPush.setEnabled(false);
        this.importPush.setToolTipText(Messages.SchedulingPage_29);
        this.importPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulingPage.this.setErrorMessage(null);
                SchedulingPage.this.setDescription(" ");
                SchedulingPage.this.doTransferRequest((short)0);
            }
        });
        this.exportPush = new Button((Composite)this.group, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.gridData.widthHint = pbLth;
        this.exportPush.setLayoutData((Object)this.gridData);
        this.exportPush.setText(Messages.SchedulingPage_31);
        this.exportPush.setEnabled(false);
        this.exportPush.setToolTipText(Messages.SchedulingPage_32);
        this.exportPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchedulingPage.this.setErrorMessage(null);
                SchedulingPage.this.setDescription(" ");
                SchedulingPage.this.doTransferRequest((short)1);
            }
        });
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.table = this.tableViewer.getTable();
        int[] styles = new int[]{16384, 16384, 16384, 16384, 16384, 16384, 16384};
        int columnIndex = 0;
        while (columnIndex < this.columnNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((SchedulingRow)element).getJobname();
                        }
                    });
                    column.getColumn().setWidth(this.width[0]);
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((SchedulingRow)element).getProgram();
                        }
                    });
                    column.getColumn().setWidth(this.width[1]);
                    break;
                }
                case 2: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            boolean enable = ((SchedulingRow)element).isOneTime();
                            return enable ? "Yes" : "";
                        }
                    });
                    column.getColumn().setWidth(this.width[2]);
                    break;
                }
                case 3: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((SchedulingRow)element).getDatabase();
                        }
                    });
                    column.getColumn().setWidth(this.width[3]);
                    break;
                }
                case 4: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((SchedulingRow)element).getImsUserId();
                        }
                    });
                    column.getColumn().setWidth(this.width[4]);
                    break;
                }
                case 5: {
                    column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                        public String getText(Object element) {
                            return ((SchedulingRow)element).getImsTransaction();
                        }
                    });
                    column.getColumn().setWidth(this.width[5]);
                }
            }
            column.getColumn().setText(this.columnNames[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData(COL_WIDTH, (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            ++columnIndex;
        }
        this.gridData = new GridData(1808);
        this.gridData.grabExcessVerticalSpace = true;
        this.gridData.grabExcessHorizontalSpace = false;
        this.table.setLayoutData((Object)this.gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(JFaceResources.getTextFont());
        Control control = this.tableViewer.getControl();
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        GC gc = new GC((Drawable)control);
        int height = gc.stringExtent((String)"W").y;
        gc.dispose();
        Point size = control.computeSize(-1, height * 5);
        control.setSize(size);
        gridData.heightHint = size.y;
        control.setLayoutData((Object)gridData);
        this.rowData = new SchedulingData();
        this.tableViewer.setContentProvider((IContentProvider)this.rowData);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.setControl(this.tableViewer.getControl());
        this.makeActions();
        this.hookDoubleClickAction();
        this.tableViewer.setInput((Object)this.rowData);
    }

    private void hookDoubleClickAction() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SchedulingPage.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                boolean goFlag = false;
                ISelection selection = SchedulingPage.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof SchedulingRow) {
                    SchedulingRow rw = (SchedulingRow)obj;
                    ArrayList<SchedulingRow> changeList = new ArrayList<SchedulingRow>();
                    changeList.add(rw);
                    SchedulingChangeDialog dialog = new SchedulingChangeDialog(SchedulingPage.this.getShell());
                    dialog.init(changeList, rw.getDatabase());
                    dialog.create();
                    int rc = dialog.open();
                    if (rc == 1) {
                        return;
                    }
                    ArrayList<Object> newList = new ArrayList();
                    newList = dialog.getRowList();
                    if (newList != null) {
                        int i = 0;
                        while (i < newList.size()) {
                            boolean result = SchedulingPage.this.rowData.updateRow(changeList.get(i), (SchedulingRow)newList.get(i));
                            if (result) {
                                goFlag = true;
                            }
                            ++i;
                        }
                    }
                }
                if (!goFlag) {
                    this.setDescription(Messages.SchedulingPage_38);
                } else {
                    boolean b = SchedulingPage.this.rowData.sendUpdateRequest(SchedulingPage.this.getShell(), SchedulingPage.this.isDB2, SchedulingPage.this.server);
                    if (!b || SchedulingPage.this.rowData.getStatusRc() > 0 && SchedulingPage.this.rowData.getStatusRc() < 24) {
                        String msg = SchedulingPage.this.fixRc(SchedulingPage.this.rowData.getStatusRc(), SchedulingPage.this.rowData.getStatusMsg());
                        SchedulingPage.this.setErrorMessage(String.format(Messages.SchedulingPage_39, msg));
                    } else if (SchedulingPage.this.rowData.getStatusRc() >= 24) {
                        String description = String.valueOf(Messages.SchedulingPage_41) + Messages.SchedulingPage_58;
                        if (SchedulingPage.this.rowData.getStatusRc() == 28) {
                            description = String.valueOf(description) + "  " + Messages.SchedulingPage_59;
                        }
                        SchedulingPage.this.setErrorMessage(null);
                        this.setDescription(description);
                    } else {
                        SchedulingPage.this.setErrorMessage(null);
                        this.setDescription(Messages.SchedulingPage_41);
                    }
                    SchedulingPage.this.tableViewer.setInput((Object)SchedulingPage.this.rowData);
                    SchedulingPage.this.sortOnColumn(SchedulingPage.this.table.getSortColumn());
                }
            }
        };
    }

    public void reSize() {
        Table tab;
        if (this.tableViewer != null && (tab = this.tableViewer.getTable()) != null && !tab.isDisposed()) {
            tab.setColumnOrder(this.order);
            TableColumn[] tableColumnArray = tab.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                Integer colid = (Integer)column.getData(COL_WIDTH);
                column.setWidth(this.width[colid]);
                ++n2;
            }
        }
    }

    private void doFetchRequest(boolean msgFlag) {
        boolean refresh;
        if (this.rowData.getRowlist() != null) {
            this.rowData.getRowlist().clear();
        }
        if (refresh = this.rowData.sendFetchRequest(this.getShell(), this.isDB2, this.server, msgFlag)) {
            if (msgFlag) {
                String text = String.format(Messages.SchedulingPage_42, this.isDB2 ? Messages.SchedulingPage_43 : Messages.SchedulingPage_44);
                this.setErrorMessage(null);
                this.setDescription(text);
            }
            this.tableViewer.setInput((Object)this.rowData);
            this.insertPush.setEnabled(true);
            this.deletePush.setEnabled(true);
            this.changePush.setEnabled(true);
            this.exportPush.setEnabled(true);
            this.importPush.setEnabled(true);
        } else {
            this.tableViewer.setInput((Object)this.rowData);
            this.insertPush.setEnabled(true);
            this.deletePush.setEnabled(false);
            this.changePush.setEnabled(false);
            this.exportPush.setEnabled(true);
            this.importPush.setEnabled(true);
            this.isEmpty = this.rowData.getStatusMsg().indexOf(EMPTY_MSG) > 0;
            String msg = this.fixRc(this.rowData.getStatusRc(), this.rowData.getStatusMsg());
            String text = String.format(Messages.SchedulingPage_45, this.isDB2 ? Messages.SchedulingPage_43 : Messages.SchedulingPage_44, msg);
            this.setErrorMessage(null);
            this.setDescription(text);
        }
    }

    private void doInsertRequest() {
        boolean goFlag = false;
        int hitCnt = 0;
        String db = this.isDB2 ? Messages.SchedulingPage_43 : Messages.SchedulingPage_44;
        SchedulingChangeDialog dialog = new SchedulingChangeDialog(this.getShell());
        dialog.init(null, db);
        dialog.create();
        int rc = dialog.open();
        if (rc == 1) {
            return;
        }
        ArrayList<Object> newList = new ArrayList();
        newList = dialog.getRowList();
        if (newList != null) {
            int i = 0;
            while (i < newList.size()) {
                boolean result = this.rowData.addRow((SchedulingRow)newList.get(i));
                if (result) {
                    goFlag = true;
                    ++hitCnt;
                }
                ++i;
            }
        }
        if (!goFlag) {
            String sMsg = Messages.SchedulingPage_51;
            this.setDescription(sMsg);
        } else {
            boolean b = this.rowData.sendUpdateRequest(this.getShell(), this.isDB2, this.server);
            if (!b || this.rowData.getStatusRc() > 0 && this.rowData.getStatusRc() < 24) {
                String msg = this.fixRc(this.rowData.getStatusRc(), this.rowData.getStatusMsg());
                this.setErrorMessage(String.format(Messages.SchedulingPage_52, msg));
                this.doFetchRequest(false);
            } else {
                String sRow = hitCnt == 1 ? Messages.SchedulingPage_54 : Messages.SchedulingPage_55;
                String sMsg = String.format(Messages.SchedulingPage_56, hitCnt, sRow);
                if (this.rowData.getStatusRc() >= 24) {
                    sMsg = String.valueOf(sMsg) + Messages.SchedulingPage_58;
                }
                if (this.rowData.getStatusRc() == 28) {
                    sMsg = String.valueOf(sMsg) + "  " + Messages.SchedulingPage_59;
                }
                this.setErrorMessage(null);
                this.setDescription(sMsg);
                this.deletePush.setEnabled(true);
                this.changePush.setEnabled(true);
                this.tableViewer.setInput((Object)this.rowData);
                this.sortOnColumn(this.table.getSortColumn());
            }
        }
    }

    private void doDeleteRequest() {
        int hitCnt = 0;
        ISelection selection = this.tableViewer.getSelection();
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int cnt = objs.length;
        if (cnt > 0) {
            int i = 0;
            while (i < cnt) {
                SchedulingRow rw;
                boolean result;
                Object obj = objs[i];
                if (obj instanceof SchedulingRow && (result = this.rowData.deleteRow(rw = (SchedulingRow)obj))) {
                    ++hitCnt;
                }
                ++i;
            }
        }
        if (hitCnt > 0) {
            String sMsg;
            boolean b = this.rowData.sendUpdateRequest(this.getShell(), this.isDB2, this.server);
            if (!b || this.rowData.getStatusRc() > 0 && this.rowData.getStatusRc() < 24) {
                String msg = this.fixRc(this.rowData.getStatusRc(), this.rowData.getStatusMsg());
                this.setErrorMessage(String.format(Messages.SchedulingPage_57, msg));
                this.doFetchRequest(false);
                if (this.isEmpty) {
                    sMsg = Messages.SchedulingPage_94;
                    this.setErrorMessage(null);
                    this.setDescription(sMsg);
                }
            } else {
                String sRow = hitCnt == 1 ? Messages.SchedulingPage_54 : Messages.SchedulingPage_55;
                sMsg = String.format(Messages.SchedulingPage_61, hitCnt, sRow);
                if (this.rowData.getStatusRc() >= 24) {
                    sMsg = String.valueOf(sMsg) + Messages.SchedulingPage_58;
                }
                if (this.rowData.getStatusRc() == 28) {
                    sMsg = String.valueOf(sMsg) + "  " + Messages.SchedulingPage_59;
                }
                this.setErrorMessage(null);
                this.setDescription(sMsg);
                this.tableViewer.setInput((Object)this.rowData);
                this.sortOnColumn(this.table.getSortColumn());
            }
            int i = 0;
            while (i < cnt) {
                Object obj = objs[i];
                if (obj instanceof SchedulingRow) {
                    SchedulingRow rw = (SchedulingRow)obj;
                    this.rowData.removeRow(rw);
                }
                ++i;
            }
        } else {
            String sMsg = Messages.SchedulingPage_62;
            this.setDescription(sMsg);
        }
    }

    private void doChangeRequest() {
        boolean goFlag = false;
        ArrayList<SchedulingRow> changeList = null;
        String db = this.isDB2 ? Messages.SchedulingPage_43 : Messages.SchedulingPage_44;
        int hitCnt = 0;
        ISelection selection = this.tableViewer.getSelection();
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int cnt = objs.length;
        if (cnt > 0) {
            changeList = new ArrayList<SchedulingRow>();
            int i = 0;
            while (i < cnt) {
                Object obj = objs[i];
                if (obj instanceof SchedulingRow) {
                    SchedulingRow rw = (SchedulingRow)obj;
                    changeList.add(rw);
                    ++hitCnt;
                }
                ++i;
            }
        }
        if (hitCnt > 0) {
            SchedulingChangeDialog dialog = new SchedulingChangeDialog(this.getShell());
            dialog.init(changeList, db);
            dialog.create();
            int rc = dialog.open();
            if (rc == 1) {
                return;
            }
            ArrayList<Object> newList = new ArrayList();
            newList = dialog.getRowList();
            if (newList != null) {
                int i = 0;
                while (i < newList.size()) {
                    boolean result = this.rowData.updateRow(changeList.get(i), (SchedulingRow)newList.get(i));
                    if (result) {
                        goFlag = true;
                    }
                    ++i;
                }
            }
        }
        if (!goFlag) {
            String sMsg = Messages.SchedulingPage_66;
            this.setDescription(sMsg);
        } else {
            boolean b = this.rowData.sendUpdateRequest(this.getShell(), this.isDB2, this.server);
            if (!b || this.rowData.getStatusRc() > 0 && this.rowData.getStatusRc() < 24) {
                String msg = this.fixRc(this.rowData.getStatusRc(), this.rowData.getStatusMsg());
                this.setErrorMessage(String.format(Messages.SchedulingPage_67, msg));
                this.doFetchRequest(false);
            } else {
                String sRow = hitCnt == 1 ? Messages.SchedulingPage_69 : Messages.SchedulingPage_70;
                String sMsg = String.format(Messages.SchedulingPage_71, hitCnt, sRow);
                if (this.rowData.getStatusRc() >= 24) {
                    sMsg = String.valueOf(sMsg) + Messages.SchedulingPage_58;
                }
                if (this.rowData.getStatusRc() == 28) {
                    sMsg = String.valueOf(sMsg) + "  " + Messages.SchedulingPage_59;
                }
                this.setErrorMessage(null);
                this.setDescription(sMsg);
                this.tableViewer.setInput((Object)this.rowData);
                this.sortOnColumn(this.table.getSortColumn());
            }
        }
    }

    private void doTransferRequest(short flag) {
        String process = flag == 0 ? Messages.SchedulingPage_73 : Messages.SchedulingPage_74;
        String name = this.settings.get(SOURCE);
        String mem = this.settings.get(MEMBER);
        String ftype = this.settings.get(FILETYPE);
        SchedulingDatasetDialog dialog = new SchedulingDatasetDialog(this.getShell());
        dialog.init(name, mem, ftype, process);
        dialog.create();
        int rc = dialog.open();
        if (rc == 1) {
            return;
        }
        this.dsn = dialog.getDSN();
        this.member = dialog.getMember();
        this.filetype = dialog.getFiletype();
        if (this.dsn.length() > 0) {
            this.putSettings();
            boolean result = this.sendTransferRequest(flag, this.dsn, this.member);
            if (result) {
                this.doFetchRequest(false);
            }
        } else {
            String sMsg = String.valueOf(Messages.SchedulingPage_75) + process;
            this.setErrorMessage(sMsg);
        }
    }

    private boolean sendTransferRequest(short flag, String file, String member) {
        if (this.server == null) {
            return false;
        }
        try {
            if (!this.server.isEnabled(false)) {
                this.server.reportCavhconfError(false);
                return false;
            }
        }
        catch (TTException e) {
            this.server.reportCavhconfError(false, e);
            return false;
        }
        boolean result = false;
        BatchConnection connection = new BatchConnection(this.server);
        SchedulingTransferMessage msg = null;
        CVMO cvmo = null;
        try {
            connection.connect(false);
            if (connection.getErrorLevel() == 0) {
                CVMI cvmi = new CVMI();
                msg = new SchedulingTransferMessage();
                msg.setSubmessageID(flag);
                msg.setDSName(file);
                msg.setMember(member);
                msg.setDstype(member.length() == 0 ? "S" : "P");
                cvmi.addMessage((DebugMessage)msg);
                cvmo = connection.process(cvmi);
            } else {
                String text = String.format(Messages.SchedulingPage_78, connection.getErrorLevel(), connection.getErrorMessage());
                this.setErrorMessage(text);
            }
            connection.disconnect();
            if (cvmo != null) {
                result = this.processCVMO(cvmo, flag);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            String text = String.format(Messages.SchedulingPage_79, e.getMessage());
            this.setErrorMessage(text);
        }
        return result;
    }

    protected boolean processCVMO(CVMO cvmo, short flag) {
        String process = flag == 0 ? Messages.SchedulingPage_80 : Messages.SchedulingPage_81;
        int rcode = 0;
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 18: {
                    String msg;
                    String text;
                    StatusMessage smsg = (StatusMessage)message;
                    int rc = smsg.getStatus();
                    if (rc >= 24) {
                        text = String.valueOf(Messages.SchedulingPage_68) + Messages.SchedulingPage_58;
                        if (rc == 28) {
                            text = String.valueOf(text) + "  " + Messages.SchedulingPage_59;
                        }
                        this.setDescription(text);
                        break;
                    }
                    if (rc > 0) {
                        rcode = rc;
                        msg = String.format(Messages.SchedulingPage_83, this.fixRc(smsg.getStatus(), smsg.getMessage()));
                        text = String.format(Messages.SchedulingPage_82, process, msg);
                        this.setErrorMessage(text);
                        break;
                    }
                    msg = String.format(Messages.SchedulingPage_85, this.fixRc(smsg.getStatus(), smsg.getMessage()));
                    text = String.format(Messages.SchedulingPage_82, process, msg);
                    this.setDescription(text);
                    break;
                }
                default: {
                    String text = String.format(Messages.SchedulingPage_82, process, Messages.SchedulingPage_87);
                    rcode = 32;
                    this.setErrorMessage(text);
                }
            }
            ++n2;
        }
        return rcode == 0;
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        if (this.autoRefresh) {
            this.server = this.serverlist.get(this.servers.getSelectionIndex());
            this.doFetchRequest(true);
            this.autoRefresh = false;
        }
        if (this.servers.getItemCount() < 1) {
            this.setErrorMessage(Messages.SchedulingPage_88);
            return false;
        }
        if (this.servers.getSelectionIndex() < 0) {
            this.setErrorMessage(Messages.SchedulingPage_89);
            return false;
        }
        return super.isPageComplete();
    }

    public boolean finishPage() {
        this.putSettings();
        return true;
    }

    public void putSettings() {
        this.settings.put(SOURCE, this.dsn);
        this.settings.put(MEMBER, this.member);
        this.settings.put(FILETYPE, this.filetype);
        this.settings.put(MRU_DATABASE, this.db2RadioButton.getSelection());
    }

    public void modifyText(ModifyEvent e) {
        this.wizard.getContainer().updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.servers.equals(event.widget)) {
            this.importPush.setEnabled(true);
            this.insertPush.setEnabled(true);
            this.db2RadioButton.setEnabled(true);
            this.imsRadioButton.setEnabled(true);
            this.server = this.serverlist.get(this.servers.getSelectionIndex());
            this.doFetchRequest(true);
            if (this.isDB2) {
                this.db2RadioButton.setSelection(true);
                this.imsRadioButton.setSelection(false);
                this.setTitle(Messages.SchedulingPage_90);
            } else {
                this.db2RadioButton.setSelection(false);
                this.imsRadioButton.setSelection(true);
                this.setTitle(Messages.SchedulingPage_91);
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void dispose() {
    }

    private void checkWidth(Composite parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[this.COLUMN_WIDTHS.length];
            int j = 0;
            while (j < this.COLUMN_WIDTHS.length) {
                this.width[j] = this.COLUMN_WIDTHS[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    private String fixRc(int rc, String msg) {
        int ptr = msg.indexOf("RC");
        if (ptr < 0) {
            return String.format(Messages.SchedulingPage_92, String.valueOf(rc), msg);
        }
        if (msg.length() < (ptr += 2) + 2) {
            return String.format(Messages.SchedulingPage_92, String.valueOf(rc), msg);
        }
        try {
            Integer.parseInt(msg.substring(ptr, ptr + 2));
        }
        catch (Exception exception) {
            return String.format(Messages.SchedulingPage_92, String.valueOf(rc), msg);
        }
        return msg;
    }

    private void createColumnSorter() {
        Table tab;
        if (this.tableViewer != null && (tab = this.tableViewer.getTable()) != null && !tab.isDisposed()) {
            TableColumn[] tableColumnArray = tab.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableColumn col = (TableColumn)e.widget;
                        Table t = col.getParent();
                        if (col.equals(t.getSortColumn())) {
                            t.setSortDirection(t.getSortDirection() == 128 ? 1024 : 128);
                        } else {
                            t.setSortColumn(col);
                            t.setSortDirection(128);
                        }
                        SchedulingPage.this.sortOnColumn(col);
                    }
                });
                ++n2;
            }
        }
    }

    private void sortOnColumn(TableColumn column) {
        if (column != null) {
            String columnName = column.getText();
            if (columnName.equalsIgnoreCase("Job Name")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        return r1.getJobname().compareToIgnoreCase(r2.getJobname());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Program")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        return r1.getProgram().compareToIgnoreCase(r2.getProgram());
                    }
                });
            } else if (columnName.equalsIgnoreCase("One Time")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        String ot1 = "N";
                        String ot2 = "N";
                        if (r1.isOneTime()) {
                            ot1 = "Y";
                        }
                        if (r2.isOneTime()) {
                            ot2 = "Y";
                        }
                        return ot1.compareToIgnoreCase(ot2);
                    }
                });
            } else if (columnName.equalsIgnoreCase("Database")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        return r1.getDatabase().compareToIgnoreCase(r2.getDatabase());
                    }
                });
            } else if (columnName.equalsIgnoreCase("User ID")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        return r1.getImsUserId().compareToIgnoreCase(r2.getImsUserId());
                    }
                });
            } else if (columnName.equalsIgnoreCase("Transaction")) {
                Collections.sort(this.rowData.getRowlist(), new Comparator<SchedulingRow>(){

                    @Override
                    public int compare(SchedulingRow r1, SchedulingRow r2) {
                        return r1.getImsTransaction().compareToIgnoreCase(r2.getImsTransaction());
                    }
                });
            }
            if (this.table != null && !this.table.isDisposed() && this.table.getSortDirection() == 1024) {
                Collections.reverse(this.rowData.getRowlist());
            }
            if (this.tableViewer != null) {
                this.tableViewer.refresh();
            }
        }
    }
}

