/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExpandCollapseWatchTreeNodeHandler
extends AbstractHandler {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final ServerTreeModel model = ServerTreeModel.getInstance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean parm = Boolean.parseBoolean(event.getParameter("com.ca.testingtools.command.expandwatchnode"));
        boolean all = Boolean.parseBoolean(event.getParameter("com.ca.testingtools.command.expandallwatchnode"));
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof WatchData) {
            TreeViewer viewer = ((WatchData)part).getViewer();
            ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (!all && sel instanceof IStructuredSelection && !sel.isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)sel;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    this.doIt(selected, viewer, parm, all);
                    ++n2;
                }
            } else {
                this.doIt(null, viewer, parm, all);
            }
        }
        return null;
    }

    private void doIt(Object selected, TreeViewer viewer, boolean parm, boolean all) {
        if (selected == null) {
            all = true;
        }
        if (parm) {
            if (all) {
                viewer.expandAll();
            } else {
                viewer.expandToLevel(selected, -1);
            }
        } else if (all) {
            viewer.collapseAll();
        } else {
            viewer.collapseToLevel(selected, -1);
        }
    }

    public boolean isEnabled() {
        return model.getServers().length > 0;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
    }
}

