/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat;

import com.ca.mat.Constants;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.ListingManager;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.MonitorHistoryRowModel;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.rowmodels.tuntables.ScheduleRowModel;
import com.ca.mat.rowmodels.tuntables.TunprofRowModel;
import com.ca.mat.rowmodels.tuntables.TunsspRowModel;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private final HashMap<Matcher, IXmlAttrHandler> classMap = Constants.getCATableRowClassMap();
    private IXmlAttrHandler classToUse = null;
    private MATTableModel model = null;
    private String modelName = null;
    private boolean inAnalysisSegment = false;
    private boolean inListingSegment = false;
    private boolean inMonitorSegment = false;
    private String path;
    private InputStream stream;
    private String dsn;
    private int analysisType = 1;
    private static final String sourceClass = XMLParser.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    List<String> staticSections = new ArrayList<String>();
    Display display;
    AnalysisManager analysisManager;
    MonitorManager monitorManager;
    ServerProxy server;

    public XMLParser(String dsn, InputStream stream, Display display) throws Exception {
        this.stream = stream;
        this.path = null;
        this.dsn = dsn;
        this.display = display;
        this.staticSections.add("TUNDELAY");
        this.staticSections.add("TUNDESC");
        this.staticSections.add("TUNPSEDO");
        this.staticSections.add("TUN4GLS");
        this.staticSections.add("TUNLISTS");
        this.staticSections.add("TUNLISTI");
        this.staticSections.add("LISTING-");
        this.analysisManager = Singletons.getAnalysisManager(display);
        this.monitorManager = Singletons.getMonitorManager(display);
        this.server = Singletons.getServerProxy(display);
        this.parse();
        stream.close();
    }

    private void parse() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        if (this.path != null) {
            saxParser.parse(new File(this.path), (DefaultHandler)this);
        } else {
            saxParser.parse(this.stream, (DefaultHandler)this);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name;
        super.startElement(uri, localName, qName, attributes);
        if (qName.equals("listing")) {
            this.inListingSegment = true;
        }
        if (qName.equals("segment")) {
            String name2 = attributes.getValue("name");
            if ("monitor".equals(name2)) {
                this.inMonitorSegment = true;
            }
            if ("analysis".equals(name2)) {
                this.inAnalysisSegment = true;
                String type = attributes.getValue("type");
                if ("normal".equalsIgnoreCase(type)) {
                    this.analysisType = 0;
                }
                if ("all".equalsIgnoreCase(type)) {
                    this.analysisType = 1;
                }
                if ("active".equalsIgnoreCase(type)) {
                    this.analysisType = 2;
                }
                if ("wait".equalsIgnoreCase(type)) {
                    this.analysisType = 3;
                }
            }
            if ("listing".equals(name2)) {
                this.inListingSegment = true;
            }
        }
        if (qName.equals("section")) {
            String sectionName = attributes.getValue("name");
            for (Matcher matcher : this.classMap.keySet()) {
                Matcher newMatch = matcher.reset(sectionName);
                if (!newMatch.find()) continue;
                this.classToUse = this.classMap.get(matcher);
                break;
            }
            this.model = new MATTableModel(this.dsn, this.analysisType);
            this.modelName = attributes.getValue("name");
        }
        if (qName.equals("format")) {
            int i = 0;
            while (i < attributes.getLength()) {
                name = attributes.getQName(i);
                String format = attributes.getValue(i);
                this.model.addColumnFormat(name, format);
                ++i;
            }
        }
        if (qName.equals("descriptions")) {
            int i = 0;
            while (i < attributes.getLength()) {
                name = attributes.getQName(i);
                String desc = attributes.getValue(i);
                this.model.addColumnDescription(name, desc);
                ++i;
            }
        }
        if (qName.equals("row") && this.classToUse != null) {
            MATTableRow row = this.classToUse.handleAttributes(attributes, this.model, this.modelName);
            if (row instanceof TunprofRowModel) {
                this.monitorManager.setTunProfile((TunprofRowModel)row);
            } else if (row instanceof TunsspRowModel) {
                this.server.getConnectedServer().setTunssp((TunsspRowModel)row);
            } else {
                this.model.addRow(row);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (qName.equals("segment") && this.inAnalysisSegment) {
            this.analysisManager.analysisParsingCompleted(this.dsn, this.analysisType);
            this.analysisManager.put(this.dsn, "LogMessages", new MATTableModel(this.dsn), this.analysisType);
        }
        if (qName.equals("section")) {
            if (this.inMonitorSegment) {
                if (this.classToUse instanceof MonitorProfileRowModel) {
                    this.monitorManager.setProfiles(this.model);
                }
                if (this.classToUse instanceof MonitorHistoryRowModel) {
                    this.monitorManager.addHistory(this.model);
                }
                if (this.classToUse instanceof ScheduleRowModel) {
                    this.monitorManager.setSchedules(this.model);
                }
                if (this.modelName.equals("TUNLISTS")) {
                    this.analysisManager.putStatic(this.modelName, this.model);
                }
            }
            if (this.inAnalysisSegment) {
                if (this.staticSections.contains(this.modelName)) {
                    this.analysisManager.putStatic(this.modelName, this.model);
                } else {
                    this.analysisManager.put(this.dsn, this.modelName, this.model, this.analysisType);
                }
            }
            if (this.inListingSegment) {
                ListingManager manager = Singletons.getListingManager(this.display);
                if (this.modelName.startsWith("Listing Verbs ")) {
                    String[] nameParts = this.modelName.split(" ");
                    if (nameParts.length > 4) {
                        manager.listingVerbsParsed(nameParts[2], nameParts[3], nameParts[4], this.model);
                    } else {
                        manager.listingVerbsParsed(nameParts[2], null, null, this.model);
                    }
                } else if (this.modelName.equals("TUNLISTS")) {
                    this.analysisManager.putStatic(this.modelName, this.model);
                } else {
                    manager.listingMetadataParsed(this.model, this.dsn);
                }
            }
            this.classToUse = null;
        }
        qName.equals("request");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
    }

    public static String rightTrim(String value) {
        int i = value.length() - 1;
        while (i >= 0 && Character.isWhitespace(value.charAt(i))) {
            --i;
        }
        return value.substring(0, i + 1);
    }
}

