/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.dashboard;

import com.ca.mat.Activator;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.MATServer;
import com.ca.mat.dashboard.IDashboard;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.AdabasStatementRowModel;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.rowmodels.DataViewRowModel;
import com.ca.mat.rowmodels.DatacomStatementRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.DelayViewRowModel;
import com.ca.mat.rowmodels.IDMSViewRowModel;
import com.ca.mat.rowmodels.IMSStatementRowModel;
import com.ca.mat.rowmodels.JVMInfoRowModel;
import com.ca.mat.rowmodels.MQViewRowModel;
import com.ca.mat.rowmodels.USSViewRowModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class Dashboard
implements IDashboard,
ProgressListener,
StatusTextListener {
    Browser browser;
    BrowserFunction getRightChartData;
    BrowserFunction getCallerId;
    MATTableModel leftChartData;
    MATTableModel rightChartData;
    AnalysisManager analManager;
    boolean ready = true;
    String dsn;
    String profile;
    int type;
    Composite parent;
    long timeToCreate;
    public List<String> jsQueue = new CopyOnWriteArrayList<String>();
    Thread jsExecutorThread;
    public static final String ACTIVE_COLOR = "#FF9B00";
    public static final String WAIT_COLOR = "#0C93E8";
    public static final String ACTIVE_TYPE_NAME = "Active";
    public static final String WAIT_TYPE_NAME = "Wait";

    @Override
    public void createDashboard(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addProgressListener((ProgressListener)this);
        long time = System.nanoTime();
        this.browser.setText(this.readHTMLFile());
        this.attachJSCallback(this.browser);
        System.nanoTime();
        this.analManager = Singletons.getAnalysisManager();
        this.createJSExecutorThread();
    }

    private void createJSExecutorThread() {
        this.jsExecutorThread = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        1.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (Dashboard.this.browser.isDisposed()) break;
                    if (Dashboard.this.jsQueue.isEmpty()) continue;
                    Dashboard.this.browser.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            while (!(this).Dashboard.this.jsQueue.isEmpty()) {
                                try {
                                    (this).Dashboard.this.browser.execute((this).Dashboard.this.jsQueue.get(0));
                                    (this).Dashboard.this.jsQueue.remove(0);
                                }
                                catch (IllegalStateException illegalStateException) {
                                    break;
                                }
                            }
                        }
                    });
                }
            }
        };
        this.jsExecutorThread.start();
    }

    private void attachJSCallback(Browser browser) {
        if (this.getRightChartData != null) {
            this.getRightChartData.dispose();
        }
        this.getRightChartData = new BrowserFunction(browser, "getRightChartData"){

            public Object function(Object[] arguments) {
                Singletons.setDisplayForCurrentThread(Dashboard.this.parent.getDisplay());
                if (arguments.length == 2) {
                    try {
                        int index = (int)Math.round(Double.valueOf(arguments[0].toString()));
                        String type = arguments[1].toString();
                        if (index < 0 || index >= Dashboard.this.leftChartData.getRows().length || !type.equals(Dashboard.ACTIVE_TYPE_NAME) && !type.equals(Dashboard.WAIT_TYPE_NAME)) {
                            throw new IllegalArgumentException("getRightChartData arguments invalid, needs to a number 1-5 and 'Active' or 'Wait'");
                        }
                        Dashboard.this.displayDataDetails(index, type);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public void dispose() {
        this.getRightChartData.dispose();
        this.jsExecutorThread.interrupt();
    }

    private static String getServerUrl() {
        MATServer server = Singletons.getServerProxy().getConnectedServer();
        if (server != null) {
            return "http://" + server.getHostname() + ":" + server.getPort() + "/mat";
        }
        return "";
    }

    public void displayDataDetails(int index, String type) {
        DelayViewRowModel delayRow = (DelayViewRowModel)this.leftChartData.getRows()[index];
        this.rightChartData = this.getRightChartData(type.equals(ACTIVE_TYPE_NAME), type.equals(WAIT_TYPE_NAME), delayRow);
        this.runJS("var rightChartData = " + this.createJSONForDetails(this.rightChartData, type, type.equals(ACTIVE_TYPE_NAME) ? ACTIVE_COLOR : WAIT_COLOR));
        this.runJS("createRightChart(rightChartData, " + index + ")");
        this.runJS("var tablecontent = " + this.createJSONForTable(this.rightChartData, type));
        this.runJS("createTable(tablecontent)");
        this.displayTooltipContent(delayRow, type);
    }

    private void displayTooltipContent(DelayViewRowModel delayRow, String type) {
        int i = 0;
        while (i < this.rightChartData.getRows().length && i < 5) {
            if (this.rightChartData.getRows()[i] instanceof DelayLocationRowModel) {
                DelayLocationRowModel delayLocationRow = (DelayLocationRowModel)this.rightChartData.getRows()[i];
                MATTableModel callerIdTable = this.getCallerId(delayLocationRow, delayRow);
                Double active = callerIdTable.summarizeColumn(6);
                Double wait = callerIdTable.summarizeColumn(7);
                if (type.equals(ACTIVE_TYPE_NAME) && active > 0.0 || type.equals(WAIT_TYPE_NAME) && wait > 0.0) {
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        callerIdTable.sortByColumn(6, false);
                    } else {
                        callerIdTable.sortByColumn(7, false);
                    }
                    this.runJS("var tooltipContent = " + this.createJSONForTable(callerIdTable, type));
                    this.runJS("createTableTooltip(tooltipContent, " + i + ")");
                }
            }
            ++i;
        }
    }

    @Override
    public void updateDashboard(MATTableModel data, String dsn, String profile, int type) {
        if (this.leftChartData != data) {
            if (Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(dsn, "TimeView", type) == null) {
                return;
            }
            if (Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(dsn, "OverView", type) == null) {
                return;
            }
            this.timeToCreate = System.nanoTime();
            long time = System.nanoTime();
            data.sortByColumn(4, false);
            this.leftChartData = data;
            this.type = type;
            this.dsn = dsn;
            this.profile = profile;
            this.updateCharts();
            System.nanoTime();
        }
    }

    @Override
    public Control getControl() {
        return this.browser;
    }

    private MATTableModel getRightChartData(boolean active, boolean wait, DelayViewRowModel delayRow) {
        if (!active && !wait) {
            return new MATTableModel();
        }
        HashMap<String, Object[]> delayLocArgs = new HashMap<String, Object[]>();
        delayLocArgs.put("ttype1", new Object[]{delayRow.getTType1()});
        delayLocArgs.put("ttype2", new Object[]{delayRow.getTType2()});
        MATTableModel model = Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(this.dsn, "TimeView", this.type);
        model = model.filterBy(delayLocArgs, false);
        String autonav = delayRow.getAutonav();
        MATTableModel result = null;
        if (delayRow.getTType1() == 8 || delayRow.getTType1() == 14 || delayRow.getTType1() == 19 || delayRow.getTType1() == 3 && delayRow.getTType2() != 50 && delayRow.getTType2() != 51 && delayRow.getTType2() != 52 && delayRow.getTType2() != 53 && delayRow.getTType2() != 70) {
            autonav = "DataView";
        } else if (autonav == null) {
            result = AnalysisUtils.calculateDelayLocations(model, this.dsn, this.type, this.browser.getDisplay());
        } else if (autonav.equals("USSView")) {
            result = Singletons.getAnalysisManager().getModel(this.dsn, "TimeView", this.type);
            result = AnalysisUtils.calculateUSSViewExperimental(result, this.dsn, this.type, delayRow.getTType2());
        } else if (autonav.equals("JVM Applications")) {
            autonav = "JVM Information";
            result = Singletons.getAnalysisManager().getModel(this.dsn, "JVM Information", this.type);
            result = AnalysisUtils.aggregateJVM(result, "group_by_process", "data_mode_application", "display_mode_process", this.dsn);
        } else if (autonav.equals("IMS TranNameView")) {
            autonav = "IMS Statements";
        } else if (autonav.equals("CA-IDMS Delays")) {
            autonav = "IDMS Delays";
        } else if (autonav.equals("Queue Manager Activity")) {
            autonav = "MQ Series Activity";
        }
        if (result == null) {
            result = this.analManager.getModel(this.dsn, autonav, this.type);
        }
        if (result == null) {
            return new MATTableModel();
        }
        result = AnalysisUtils.removeZeroValueRows(result, this.getSortColumnForDelayDetails(autonav, active, wait));
        result.sortByColumn(this.getSortColumnForDelayDetails(autonav, active, wait), false);
        return result;
    }

    public int getSortColumnForDelayDetails(String autonav, boolean active, boolean wait) {
        if (autonav == null && active) {
            return 8;
        }
        if (autonav == null && wait) {
            return 9;
        }
        if (autonav.equals("USSView") && active) {
            return 2;
        }
        if (autonav.equals("USSView") && wait) {
            return 3;
        }
        if (autonav.equals("JVM Information")) {
            return 2;
        }
        if (autonav.equals("DataView")) {
            return 2;
        }
        if (autonav.equals("DB2 View") && active) {
            return 58;
        }
        if (autonav.equals("DB2 View") && wait) {
            return 59;
        }
        if (autonav.equals("IMS Statements") && active) {
            return 6;
        }
        if (autonav.equals("IMS Statements") && wait) {
            return 7;
        }
        if (autonav.equals("IDMS Delays")) {
            return 4;
        }
        if (autonav.equals("MQ Series Activity") && active) {
            return 2;
        }
        if (autonav.equals("MQ Series Activity") && wait) {
            return 3;
        }
        if (autonav.equals("DATACOM Statements") && active) {
            return 3;
        }
        if (autonav.equals("DATACOM Statements") && wait) {
            return 4;
        }
        return 0;
    }

    private MATTableModel getCallerId(DelayLocationRowModel locationRow, DelayViewRowModel delayRow) {
        HashMap<String, Object[]> callerIdArgs = new HashMap<String, Object[]>();
        callerIdArgs.put("Module", new Object[]{locationRow.getModule()});
        callerIdArgs.put("Csect", new Object[]{locationRow.getCsect()});
        callerIdArgs.put("Offset", locationRow.getAllCorrespondingOffsets().toArray());
        callerIdArgs.put("ttype1", new Object[]{delayRow.getTType1()});
        callerIdArgs.put("ttype2", new Object[]{delayRow.getTType2()});
        MATTableModel model = this.analManager.getModel(this.dsn, "TimeView", 1);
        model = model.filterBy(callerIdArgs);
        model = AnalysisUtils.calculateCallerId(model, this.dsn, 1, Display.getCurrent());
        return model;
    }

    private String readHTMLFile() {
        BufferedReader reader = null;
        try {
            Bundle bundle = Activator.plugin.getBundle();
            Path path = new Path("HTML/dashboard.html");
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            StringBuilder stringBuilder = new StringBuilder();
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void changed(ProgressEvent event) {
    }

    public void completed(ProgressEvent event) {
        System.out.println("Completed called, event " + event.time);
        Thread dataPreparation = new Thread(){

            @Override
            public void run() {
                Singletons.setDisplayForCurrentThread(Dashboard.this.parent.getDisplay());
                if (Dashboard.this.leftChartData != null) {
                    System.nanoTime();
                    String headerJSON = Dashboard.this.createJSONForHeader();
                    String dataJSON = Dashboard.this.createJSON(Dashboard.this.leftChartData);
                    DelayViewRowModel delayRow = (DelayViewRowModel)Dashboard.this.leftChartData.getRows()[0];
                    String type = delayRow.getActive() > delayRow.getWait() ? Dashboard.ACTIVE_TYPE_NAME : Dashboard.WAIT_TYPE_NAME;
                    Dashboard.this.rightChartData = Dashboard.this.getRightChartData(type.equals(Dashboard.ACTIVE_TYPE_NAME), type.equals(Dashboard.WAIT_TYPE_NAME), delayRow);
                    Dashboard.this.runJS("var serverUrl = \"" + Dashboard.getServerUrl() + "\"");
                    Dashboard.this.runJS("var headerData = " + headerJSON + ";");
                    Dashboard.this.runJS("var selection = 0;");
                    Dashboard.this.runJS("createHeader(headerData);");
                    Dashboard.this.runJS("var leftChartData = " + dataJSON + ";");
                    Dashboard.this.runJS("createLeftChart();");
                    Dashboard.this.runJS("updateLeftChart();");
                    Dashboard.this.runJS("moveBubble(0, \"" + type + "\");");
                    Dashboard.this.runJS("var rightChartData = " + Dashboard.this.createJSONForDetails(Dashboard.this.rightChartData, type, type.equals(Dashboard.ACTIVE_TYPE_NAME) ? Dashboard.ACTIVE_COLOR : Dashboard.WAIT_COLOR));
                    Dashboard.this.runJS("createRightChart(rightChartData, 0)");
                    Dashboard.this.runJS("var tablecontent = " + Dashboard.this.createJSONForTable(Dashboard.this.rightChartData, type));
                    Dashboard.this.runJS("createTable(tablecontent)");
                    Dashboard.this.displayTooltipContent(delayRow, type);
                    Dashboard.this.ready = true;
                }
            }
        };
        dataPreparation.start();
    }

    public void updateCharts() {
        if (this.ready) {
            if (this.browser != null) {
                this.browser.removeProgressListener((ProgressListener)this);
                this.browser.dispose();
            }
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.browser.addProgressListener((ProgressListener)this);
            this.attachJSCallback(this.browser);
            long time = System.nanoTime();
            this.browser.setText(this.readHTMLFile());
            System.nanoTime();
        }
    }

    private void runJS(String jscript) {
        this.jsQueue.add(jscript);
    }

    public String createJSON(MATTableModel data) {
        DelayViewRowModel delayRow;
        MATTableRow row;
        int n;
        int n2;
        MATTableRow[] mATTableRowArray;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.type != 3) {
            sb.append("{key: \"Active\", color: \"#FF9B00\", values: [");
            i = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n2 = mATTableRowArray.length;
                n = 0;
                while (n < n2) {
                    row = mATTableRowArray[n];
                    if (row instanceof DelayViewRowModel) {
                        delayRow = (DelayViewRowModel)row;
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append("{\"x\" : \"" + delayRow.getText(1) + "\",");
                        sb.append("\"y\" : " + this.format(delayRow.getActive() / 100.0, 4) + ",");
                        sb.append("\"x2\" : \"" + delayRow.getText(0) + "\",");
                        sb.append("\"desc\" : \" " + AnalysisUtils.getDelayDescription(delayRow.getTType1(), delayRow.getTType2()) + "\"}");
                    }
                    if (++i == 5) break;
                    ++n;
                }
            }
            sb.append("]}");
        }
        if (this.type != 2 && this.type != 3) {
            sb.append(",");
        }
        if (this.type != 2) {
            sb.append("{key: \"Wait\", color: \"#0C93E8\", values: [");
            i = 0;
            if (data != null) {
                mATTableRowArray = data.getRows();
                n2 = mATTableRowArray.length;
                n = 0;
                while (n < n2) {
                    row = mATTableRowArray[n];
                    if (row instanceof DelayViewRowModel) {
                        delayRow = (DelayViewRowModel)row;
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append("{\"x\" : \"" + delayRow.getText(1) + "\",");
                        sb.append("\"y\" : " + this.format(delayRow.getWait() / 100.0, 4) + "}");
                    }
                    if (++i == 5) break;
                    ++n;
                }
            }
            sb.append("]}");
        }
        sb.append("]");
        return sb.toString();
    }

    public String createJSONForHeader() {
        MATTableModel overviewModel = Singletons.getAnalysisManager(this.browser.getDisplay()).getModel(this.dsn, "OverView", this.type);
        if (overviewModel == null) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("profile: \"" + this.profile + "\"");
        sb.append(", dsn: \"" + this.dsn + "\"");
        int startIndex = 0;
        MATTableRow[] mATTableRowArray = overviewModel.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            if (row.getText(0).startsWith("-- Job Information --")) break;
            ++startIndex;
            ++n2;
        }
        try {
            String lineText = overviewModel.getRows()[startIndex + 2].getText(0);
            sb.append(", jobname: \"" + lineText.substring(13, 21) + "\"");
            sb.append(", tcbtime: \"" + lineText.substring(40, 51) + "\"");
            sb.append(", startdate: \"" + lineText.substring(68) + "\"");
            lineText = overviewModel.getRows()[startIndex + 3].getText(0);
            sb.append(", stepname: \"" + lineText.substring(13, 21) + "\"");
            sb.append(", srbtime: \"" + lineText.substring(40, 51) + "\"");
            sb.append(", starttime: \"" + lineText.substring(68) + "\"");
            lineText = overviewModel.getRows()[startIndex + 4].getText(0);
            sb.append(", procstep: \"" + lineText.substring(13, 21) + "\"");
            sb.append(", duration: \"" + lineText.substring(68) + "\"");
            lineText = overviewModel.getRows()[startIndex + 5].getText(0);
            sb.append(", program: \"" + lineText.substring(13, 21) + "\"");
            sb.append(", subsystems: [");
            int i = 0;
            while (i <= 5) {
                lineText = overviewModel.getRows()[startIndex + 11 + i].getText(0);
                if (lineText.startsWith("DB2 Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"DB2 Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("CICS Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"CICS Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("USS Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"USS Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("Ideal Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"Ideal Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("Adabas Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"Adabas Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("MQS Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"MQS Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                if (lineText.startsWith("Natural Lvl")) {
                    sb.append(String.valueOf(i != 0 ? "," : "") + "{name: \"Natural Lvl\", value: \"" + lineText.substring(13, 21) + "\"}");
                }
                ++i;
            }
            sb.append("]");
        }
        catch (Exception exception) {}
        sb.append("}");
        return sb.toString();
    }

    public String createJSONForDetails(MATTableModel dataDetails, String categoryName, String color) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{key: \"" + categoryName + "\", color: \"" + color + "\", values: [");
        int i = 0;
        if (dataDetails != null) {
            MATTableRow[] mATTableRowArray = dataDetails.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                if (row instanceof DelayLocationRowModel) {
                    DelayLocationRowModel delayRow = (DelayLocationRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + delayRow.getModule() + " " + delayRow.getCsect() + " " + delayRow.getOffset() + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + delayRow.getActive() + "}");
                    } else {
                        sb.append("\"y\" : " + delayRow.getWait() + "}");
                    }
                } else if (row instanceof DB2ViewRowModel) {
                    DB2ViewRowModel db2Row = (DB2ViewRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + db2Row.getDbrm() + " " + db2Row.getStmtNum() + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + db2Row.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + db2Row.getWait() + "}");
                    }
                } else if (row instanceof IMSStatementRowModel) {
                    IMSStatementRowModel IMSRow = (IMSStatementRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + IMSRow.getPSB() + " " + IMSRow.getSegment() + " " + IMSRow.getCallType() + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + IMSRow.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + IMSRow.getWait() + "}");
                    }
                } else if (row instanceof AdabasStatementRowModel) {
                    AdabasStatementRowModel adabasRow = (AdabasStatementRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + adabasRow.getText(0) + " " + adabasRow.getText(3) + " " + adabasRow.getText(4) + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + adabasRow.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + adabasRow.getWait() + "}");
                    }
                } else if (row instanceof IDMSViewRowModel) {
                    IDMSViewRowModel IDMSRow = (IDMSViewRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + IDMSRow.getText(0) + " " + IDMSRow.getText(1) + " " + IDMSRow.getText(2) + " " + IDMSRow.getText(3) + "\",");
                    sb.append("\"y\" : " + IDMSRow.getTot() + "}");
                } else if (row instanceof JVMInfoRowModel) {
                    JVMInfoRowModel JVMRow = (JVMInfoRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + JVMRow.getText(0) + " " + JVMRow.getText(1) + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + JVMRow.getPct() + "}");
                    } else {
                        sb.append("\"y\" : " + JVMRow.getPct() + "}");
                    }
                } else if (row instanceof MQViewRowModel) {
                    MQViewRowModel MQRow = (MQViewRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + MQRow.getText(0) + " " + MQRow.getText(1) + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + MQRow.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + MQRow.getWait() + "}");
                    }
                } else if (row instanceof DatacomStatementRowModel) {
                    DatacomStatementRowModel DTCMRow = (DatacomStatementRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + DTCMRow.getText(0) + " " + DTCMRow.getText(1) + " " + DTCMRow.getText(2) + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + DTCMRow.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + DTCMRow.getWait() + "}");
                    }
                } else if (row instanceof USSViewRowModel) {
                    USSViewRowModel USSRow = (USSViewRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + USSRow.getText(0) + " " + USSRow.getText(1) + "\",");
                    if (categoryName.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"y\" : " + USSRow.getAct() + "}");
                    } else {
                        sb.append("\"y\" : " + USSRow.getWait() + "}");
                    }
                } else if (row instanceof DataViewRowModel) {
                    DataViewRowModel dataRow = (DataViewRowModel)row;
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + dataRow.getText(0) + " " + dataRow.getText(1) + " " + dataRow.getText(16) + "\",");
                    sb.append("\"y\" : " + dataRow.getText(2) + "}");
                } else {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"x\" : \"" + row.getText(0) + "\",");
                    sb.append("\"y\" : " + i + "}");
                }
                if (++i == 5) break;
                ++n2;
            }
        }
        sb.append("]}");
        sb.append("]");
        return sb.toString();
    }

    public String createJSONForTable(MATTableModel dataDetails, String type) {
        if (dataDetails.getRows().length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (dataDetails.getRows()[0] instanceof DelayLocationRowModel) {
            sb.append("[\"Module\", \"Csect\", \"Offset\", \"Csect Description\", \"Stmt\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"8\", \"8\", \"20\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof CallerIdRowModel) {
            sb.append("[\"Module\", \"Csect\", \"Offset\", \"Csect Description\", \"Stmt\", \"" + type + " %\"]");
            sb.append(",[\"8\", \"8\", \"8\", \"20\", \"8\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof DB2ViewRowModel) {
            sb.append("[\"DBRM or Package\", \"D S\", \"Data From\", \"Stmt Num\", \"Type\", \"Call Count\", \"Total CPU\", \"CPU-P-Call\", \"Average Response Time\", \"Total Samps\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"2\", \"8\", \"8\", \"8\", \"8\", \"8\", \"8\", \"8\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof IMSStatementRowModel) {
            sb.append("[\"PSB Name\", \"PCB#\", \"DBD Name\", \"Segment\", \"Call\", \"P-Opts\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"4\", \"8\", \"8\", \"8\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof AdabasStatementRowModel) {
            sb.append("[\"DB ID\", \"File #\", \"CMD\", \"CMD-IDX\", \"CMD-ID\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"4\", \"4\", \"8\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof IDMSViewRowModel) {
            sb.append("[\"TaskCode\", \"Module\", \"Offset\", \"Status\",\"Wait Reason\", \"Total %\"]");
            sb.append(",[\"8\", \"8\", \"8\", \"8\", \"20\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof JVMInfoRowModel) {
            sb.append("[\"Process ID\", \"JVM Release\", \"JVM Information\", \"Pct %\"]");
            sb.append(",[\"8\", \"8\", \"20\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof MQViewRowModel) {
            sb.append("[\"Queue Manager\", \"Queue Description\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"20\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof DatacomStatementRowModel) {
            sb.append("[\"TABLE ID\", \"TBL Key\", \"Call\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"8\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof USSViewRowModel) {
            sb.append("[\"Process ID\", \"Initial Command\", \"" + type + " %\", \"Total %\"]");
            sb.append(",[\"8\", \"8\", \"4\", \"4\"]");
        }
        if (dataDetails.getRows()[0] instanceof DataViewRowModel) {
            sb.append("[\"DD Name\", \"Dataset name\", \"Seq Nr.\", \"Delay %\"]");
            sb.append(",[\"8\", \"44\", \"4\", \"4\"]");
        }
        if (dataDetails != null) {
            int i = 0;
            MATTableRow[] mATTableRowArray = dataDetails.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                sb.append(",[");
                if (row instanceof DelayLocationRowModel) {
                    DelayLocationRowModel delayRow = (DelayLocationRowModel)row;
                    sb.append("\"" + delayRow.getModule() + "\", " + "\"" + delayRow.getCsect() + "\", " + "\"" + delayRow.getText(2) + "\", " + "\"" + delayRow.getText(3) + "\", " + "\"" + delayRow.getText(4) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(delayRow.getActive(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(delayRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(delayRow.getTotal(), 2) + "\"");
                }
                if (row instanceof CallerIdRowModel) {
                    CallerIdRowModel callerIdRow = (CallerIdRowModel)row;
                    if (type.equals(ACTIVE_TYPE_NAME) && callerIdRow.getActive() > 0.0 || type.equals(WAIT_TYPE_NAME) && callerIdRow.getWait() > 0.0) {
                        sb.append("\"" + callerIdRow.getText(0) + "\", " + "\"" + callerIdRow.getText(1) + "\", " + "\"" + callerIdRow.getText(2) + "\", " + "\"" + callerIdRow.getText(4) + "\", " + "\"" + callerIdRow.getText(3) + "\", ");
                        if (type.equals(ACTIVE_TYPE_NAME)) {
                            sb.append("\"" + this.format(callerIdRow.getActive(), 2) + "\",");
                        } else {
                            sb.append("\"" + this.format(callerIdRow.getWait(), 2) + "\",");
                        }
                        sb.append("\"" + this.format(callerIdRow.getTotal(), 2) + "\"");
                    }
                }
                if (row instanceof DB2ViewRowModel) {
                    DB2ViewRowModel db2Row = (DB2ViewRowModel)row;
                    sb.append("\"" + db2Row.getText(0) + "\", " + "\"" + db2Row.getText(1) + "\", " + "\"" + db2Row.getText(2) + "\", " + "\"" + db2Row.getStmtNum() + "\", " + "\"" + db2Row.getText(4) + "\", " + "\"" + db2Row.getText(5) + "\", " + "\"" + this.format(db2Row.getTotalCPU(), 6) + "\", " + "\"" + this.format(db2Row.getCPUPCall(), 6) + "\", " + "\"" + this.format(db2Row.getAverageRespType(), 6) + "\", " + "\"" + db2Row.getText(56) + "\",");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(db2Row.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(db2Row.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(db2Row.getTotl(), 2) + "\"");
                }
                if (row instanceof IMSStatementRowModel) {
                    IMSStatementRowModel IMSRow = (IMSStatementRowModel)row;
                    sb.append("\"" + IMSRow.getText(0) + "\", " + "\"" + IMSRow.getText(1) + "\", " + "\"" + IMSRow.getText(2) + "\", " + "\"" + IMSRow.getText(3) + "\", " + "\"" + IMSRow.getText(4) + "\", " + "\"" + IMSRow.getText(5) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(IMSRow.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(IMSRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(IMSRow.getTotal(), 2) + "\"");
                }
                if (row instanceof AdabasStatementRowModel) {
                    AdabasStatementRowModel adabasRow = (AdabasStatementRowModel)row;
                    sb.append("\"" + adabasRow.getText(0) + "\", " + "\"" + adabasRow.getText(1) + "\", " + "\"" + adabasRow.getText(2) + "\", " + "\"" + adabasRow.getText(3) + "\", " + "\"" + adabasRow.getText(4) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(adabasRow.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(adabasRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(adabasRow.getTot(), 2) + "\"");
                }
                if (row instanceof IDMSViewRowModel) {
                    IDMSViewRowModel IDMSRow = (IDMSViewRowModel)row;
                    sb.append("\"" + IDMSRow.getText(0) + "\", " + "\"" + IDMSRow.getText(1) + "\", " + "\"" + IDMSRow.getText(2) + "\", " + "\"" + IDMSRow.getText(3) + "\", ");
                    sb.append("\"" + IDMSRow.getWait() + "\",\"" + this.format(IDMSRow.getTot(), 2) + "\"");
                }
                if (row instanceof JVMInfoRowModel) {
                    JVMInfoRowModel JVMRow = (JVMInfoRowModel)row;
                    sb.append("\"" + JVMRow.getText(0) + "\", " + "\"" + JVMRow.getText(1) + "\", " + "\"" + JVMRow.getText(3) + "\", " + "\"" + this.format(JVMRow.getPct(), 2) + "\"");
                }
                if (row instanceof MQViewRowModel) {
                    MQViewRowModel MQRow = (MQViewRowModel)row;
                    sb.append("\"" + MQRow.getText(0) + "\", " + "\"" + MQRow.getText(1) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(MQRow.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(MQRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(MQRow.getTot(), 2) + "\"");
                }
                if (row instanceof DatacomStatementRowModel) {
                    DatacomStatementRowModel DTCMRow = (DatacomStatementRowModel)row;
                    sb.append("\"" + DTCMRow.getText(0) + "\", " + "\"" + DTCMRow.getText(1) + "\", " + "\"" + DTCMRow.getText(2) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(DTCMRow.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(DTCMRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(DTCMRow.getTot(), 2) + "\"");
                }
                if (row instanceof USSViewRowModel) {
                    USSViewRowModel USSRow = (USSViewRowModel)row;
                    sb.append("\"" + USSRow.getText(0) + "\", " + "\"" + USSRow.getText(1) + "\", ");
                    if (type.equals(ACTIVE_TYPE_NAME)) {
                        sb.append("\"" + this.format(USSRow.getAct(), 2) + "\",");
                    } else {
                        sb.append("\"" + this.format(USSRow.getWait(), 2) + "\",");
                    }
                    sb.append("\"" + this.format(USSRow.getTot(), 2) + "\"");
                }
                if (row instanceof DataViewRowModel) {
                    DataViewRowModel dataRow = (DataViewRowModel)row;
                    sb.append("\"" + dataRow.getText(0) + "\", " + "\"" + dataRow.getText(1) + "\", " + "\"" + dataRow.getText(16) + "\", ");
                    try {
                        sb.append("\"" + this.format(Double.parseDouble(dataRow.getText(2)), 2) + "\",");
                    }
                    catch (NumberFormatException numberFormatException) {
                        sb.append("\" \",");
                    }
                }
                sb.append("]");
                if (++i == 5) break;
                ++n2;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public void changed(StatusTextEvent event) {
    }

    private String format(Number number, int digits) {
        NumberFormat form = NumberFormat.getInstance();
        form.setMinimumFractionDigits(digits);
        form.setMaximumFractionDigits(digits);
        try {
            return form.format(number).replace(",", ".");
        }
        catch (Exception exception) {
            return String.valueOf(number);
        }
    }
}

