/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.logging.Logging;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.XMLFileRowModel;
import com.ca.mat.views.LocalXMLFilesView;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class AnalyzeLocalHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof LocalXMLFilesView) {
            IStructuredSelection sel = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                String commandId = event.getCommand().getId();
                if (obj instanceof XMLFileRowModel && commandId.equals("com.ca.mat.commands.analyzelocal")) {
                    XMLFileRowModel fileRow = (XMLFileRowModel)obj;
                    String dsn = fileRow.getDsn();
                    SequenceInputStream is = null;
                    AnalysisManager analManager = Singletons.getAnalysisManager(part.getSite().getShell().getDisplay());
                    try {
                        File[] localFiles = analManager.getLocalXMLFiles(dsn, fileRow.getProfile());
                        if (localFiles != null && localFiles.length > 0) {
                            ArrayList<InputStream> streams = new ArrayList<InputStream>();
                            streams.add(new ByteArrayInputStream("<dummyRoot>".getBytes()));
                            File[] fileArray = localFiles;
                            int n3 = localFiles.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                File fil = fileArray[n4];
                                streams.add(new FileInputStream(fil));
                                ++n4;
                            }
                            streams.add(new ByteArrayInputStream("</dummyRoot>".getBytes()));
                            is = new SequenceInputStream(Collections.enumeration(streams));
                        }
                    }
                    catch (FileNotFoundException e) {
                        Logger log = Logging.getLogger(part.getSite().getShell().getDisplay());
                        log.log(Level.WARNING, "File not found for local analysis: " + dsn, e);
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                        Shell shell = window.getShell();
                        MessageDialog.openWarning((Shell)shell, (String)"File not found", (String)"File not found on local filesystem.");
                        analManager.refreshLocalXMLViews();
                        return null;
                    }
                    if (analManager.getAnalysisState(dsn, 1) != 2) {
                        int[] nArray = new int[4];
                        nArray[0] = 1;
                        nArray[2] = 2;
                        nArray[3] = 3;
                        analManager.processAnalysis(is, dsn, fileRow.getProfile(), nArray, true, "");
                    } else {
                        int[] nArray = new int[4];
                        nArray[0] = 1;
                        nArray[2] = 2;
                        nArray[3] = 3;
                        analManager.processAnalysis(is, dsn, fileRow.getProfile(), nArray, false, "");
                    }
                    analManager.refreshLocalXMLViews();
                }
                ++n2;
            }
        }
        return null;
    }
}

