/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CallerIdRowModel;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.ModViewRowModel;
import com.ca.mat.rowmodels.ModuleCsectInfoRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CodeViewModuleInfoHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MATTableRow row;
        event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        String section = "Module-Csect Info";
        MATTableModel detail = Singletons.getAnalysisManager().getModel(dsn, section, type);
        String module = null;
        String csect = null;
        HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
        boolean showCsectDetails = true;
        boolean checkPseudoModule = true;
        if (obj instanceof CodeViewRowModel) {
            row = (CodeViewRowModel)obj;
            CodeViewPage codeView = (CodeViewPage)page;
            arguments.put("modnm", new Object[]{((CodeViewRowModel)row).getModule()});
            module = ((CodeViewRowModel)row).getModule();
            if (codeView.getModeType() == CodeViewRowModel.TYPE_CSECT) {
                arguments.put("cscsect", new Object[]{((CodeViewRowModel)row).getCSECT()});
                csect = ((CodeViewRowModel)row).getCSECT();
            }
            if (!((CodeViewRowModel)row).getMode().equals(CodeViewRowModel.TYPE_CSECT)) {
                showCsectDetails = false;
                csect = "";
            }
        } else if (obj instanceof CallerIdRowModel) {
            row = (CallerIdRowModel)obj;
            checkPseudoModule = false;
            arguments.put("cscsect", new Object[]{((CallerIdRowModel)row).getOutCsect()});
            arguments.put("modnm", new Object[]{((CallerIdRowModel)row).getOutModule()});
            module = ((CallerIdRowModel)row).getOutModule();
            csect = ((CallerIdRowModel)row).getOutCsect();
        } else if (obj instanceof DelayLocationRowModel) {
            row = (DelayLocationRowModel)obj;
            arguments.put("cscsect", new Object[]{((DelayLocationRowModel)row).getCsect()});
            arguments.put("modnm", new Object[]{((DelayLocationRowModel)row).getModule()});
            module = ((DelayLocationRowModel)row).getModule();
            csect = ((DelayLocationRowModel)row).getCsect();
        } else if (obj instanceof ModViewRowModel) {
            row = (ModViewRowModel)obj;
            checkPseudoModule = false;
            arguments.put("cscsect", new Object[]{((ModViewRowModel)row).getCsect()});
            arguments.put("modnm", new Object[]{((ModViewRowModel)row).getModule()});
            module = ((ModViewRowModel)row).getModule();
            csect = ((ModViewRowModel)row).getCsect();
        }
        if (module == null || module.startsWith(".") && checkPseudoModule && csect.startsWith(".") || module.startsWith(".") && checkPseudoModule && csect.isEmpty()) {
            return null;
        }
        ModuleCsectInfoRowModel detailsRow = null;
        MATTableModel result = null;
        if ((detail = detail.filterBy(arguments)) != null) {
            if (detail.getRows().length == 0) {
                detail = Singletons.getAnalysisManager().getModel(dsn, section, type);
                arguments.put("cscsect", new Object[]{"N/A"});
                detail = detail.filterBy(arguments);
            }
            if (detail.getRows().length > 0) {
                detailsRow = (ModuleCsectInfoRowModel)detail.getRows()[0];
                result = this.populateRowModel(detailsRow, showCsectDetails);
            }
        }
        IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.modulecsectinfo", result);
        String format = csect == null ? "Info - Module:%1$s" : "Info - Module:%1$s : CSECT:%2$s";
        detachedView.setPresentationName(String.format(format, module, csect));
        return null;
    }

    private MATTableModel populateRowModel(ModuleCsectInfoRowModel detailsRow, boolean showCsectDetails) {
        MATTableModel model = new MATTableModel();
        ModuleCsectDetail detail = null;
        detail = new ModuleCsectDetail(model, "Module name ", detailsRow.getModuleName());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Address ", detailsRow.getAddress());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Length ", detailsRow.getModuleLength());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Date stamp ", detailsRow.getDateStamp());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Link component ", detailsRow.getLinkComponent());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Rent ", detailsRow.getRent());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Reus ", detailsRow.getReus());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Ovly ", detailsRow.getOvly());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Load ", detailsRow.getLoad());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Exec ", detailsRow.getExec());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "Dataset ", detailsRow.getDataset());
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, " ", " ");
        model.addRow(detail);
        String value = "N/A";
        if (showCsectDetails) {
            value = detailsRow.getCsect();
        }
        detail = new ModuleCsectDetail(model, "Csect name ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getOffset();
        }
        detail = new ModuleCsectDetail(model, "Offset ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getCSECTLength();
        }
        detail = new ModuleCsectDetail(model, "Length ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getTranslatorId();
        }
        detail = new ModuleCsectDetail(model, "TranslatorId ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getCompileDate();
        }
        detail = new ModuleCsectDetail(model, "Compile Date ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getAmode();
        }
        detail = new ModuleCsectDetail(model, "Amode ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getRmode();
        }
        detail = new ModuleCsectDetail(model, "Rmode ", value);
        model.addRow(detail);
        if (showCsectDetails) {
            value = detailsRow.getType();
        }
        detail = new ModuleCsectDetail(model, "Type ", value);
        model.addRow(detail);
        detail = new ModuleCsectDetail(model, "CA Endevor SCM Footprint ", detailsRow.getEndevor());
        model.addRow(detail);
        return model;
    }

    private class ModuleCsectDetail
    extends MATTableRow {
        private String value;
        private String fieldName;

        public ModuleCsectDetail(MATTableModel model, String fieldName, String value) {
            super(model);
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        protected Object[] getArray() {
            return new String[]{this.fieldName, this.value};
        }
    }
}

