/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisUtils;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.rowmodels.overview.JobInformationRowModel;
import com.ca.mat.rowmodels.tuntables.TunsqlRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.subpages.DB2DeclareDisplaySubpage;
import com.ca.mat.views.subpages.DB2SQLDisplaySubpage;
import com.ca.mat.views.subpages.TextDisplaySubpage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DB2ViewNavigationHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String commandId = event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        presentation.getProfile();
        JobInformationRowModel jobInformation = (JobInformationRowModel)Singletons.getAnalysisManager().getModel(dsn, "Job Information", 1).getRows()[0];
        if (obj instanceof DB2ViewRowModel) {
            DB2ViewRowModel rowModel = (DB2ViewRowModel)obj;
            if (commandId.equals("com.ca.mat.commands.analysis.db2view.selectsql")) {
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNSQL", 1);
                HashMap<String, Object[]> args = new HashMap<String, Object[]>();
                args.put("name", new Object[]{rowModel.getDbrmKey()});
                model = model.filterBy(args);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DB2SQLDisplaySubpage.class, "", dsn, type, presentation, "com.ca.mat.help.selectsql", model);
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setDBRMname(rowModel.getDbrm());
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setStatement(rowModel.getStmtNum());
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setStatementType(rowModel.getType());
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setSSID(jobInformation.getDB2SSID());
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setRelease(jobInformation.getDB2Release());
                if (model.getRows().length > 0) {
                    TunsqlRowModel sqlModel = (TunsqlRowModel)model.getRows()[0];
                    ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setSource(sqlModel.getOrigFull());
                    ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setBlock(sqlModel.getBlockFull());
                    ((DB2SQLDisplaySubpage)detachedView.getActivePage()).setTimestamp(sqlModel.getTimestamp());
                }
                ((DB2SQLDisplaySubpage)detachedView.getActivePage()).refreshHeader();
                detachedView.setPresentationName("SQL Statement: Stmt " + rowModel.getStmtNum());
            } else if (commandId.equals("com.ca.mat.commands.analysis.db2view.showdeclare")) {
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNSQL", 1);
                HashMap<String, Object[]> args = new HashMap<String, Object[]>();
                args.put("name", new Object[]{AnalysisUtils.createDB2DeclareKey(rowModel)});
                model = model.filterBy(args);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(DB2DeclareDisplaySubpage.class, "", dsn, type, presentation, "com.ca.mat.help.showdeclare", model);
                ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).setDBRMname(rowModel.getDbrm());
                ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).setStatement(rowModel.getStmtNum());
                ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).setRelease(jobInformation.getDB2Release());
                ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).setSSID(jobInformation.getDB2SSID());
                if (model.getRows().length > 0) {
                    TunsqlRowModel sqlModel = (TunsqlRowModel)model.getRows()[0];
                    ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).setTimestamp(sqlModel.getTimestamp());
                }
                ((DB2DeclareDisplaySubpage)detachedView.getActivePage()).refreshHeader();
                detachedView.setPresentationName("Select Declare for " + rowModel.getStmtNum() + ": Stmt " + rowModel.getDeclareStmt());
            } else if (commandId.equals("com.ca.mat.commands.analysis.db2view.explainsql")) {
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                HashMap<String, Object[]> args = new HashMap<String, Object[]>();
                args.put("expname", new Object[]{rowModel.getDbrmKey()});
                model = model.filterBy(args);
                String statement = rowModel.getStmtNum();
                if (model.isEmpty()) {
                    model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                    String declareKey = AnalysisUtils.createDB2DeclareKey(rowModel);
                    model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                    args.put("expname", new Object[]{declareKey});
                    model = model.filterBy(args);
                    statement = String.valueOf(rowModel.getDeclareStmt()) + " (declare for " + rowModel.getStmtNum() + ")";
                }
                if (!model.isEmpty()) {
                    int cfr_ignored_0 = model.getRows().length;
                    model = AnalysisUtils.createExplainSQL(model, dsn);
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.explainsql", model);
                    detachedView.setPresentationName("Explain SQL: Stmt " + statement);
                }
            } else if (commandId.equals("com.ca.mat.commands.analysis.db2view.explaininformation")) {
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                HashMap<String, Object[]> args = new HashMap<String, Object[]>();
                args.put("expname", new Object[]{rowModel.getDbrmKey()});
                model = model.filterBy(args);
                String statement = rowModel.getStmtNum();
                if (model.isEmpty()) {
                    model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                    String declareKey = AnalysisUtils.createDB2DeclareKey(rowModel);
                    model = Singletons.getAnalysisManager().getModel(dsn, "TUNEXPL", 1);
                    args.put("expname", new Object[]{declareKey});
                    model = model.filterBy(args);
                    statement = String.valueOf(rowModel.getDeclareStmt()) + " (declare for " + rowModel.getStmtNum() + ")";
                }
                if (!model.isEmpty()) {
                    int cfr_ignored_1 = model.getRows().length;
                    model = AnalysisUtils.createExplainInformation(model, dsn);
                    IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "", dsn, type, presentation, "com.ca.mat.help.explaininformation", model);
                    detachedView.setPresentationName("Explain Information: Stmt " + statement);
                }
            } else if (commandId.equals("com.ca.mat.commands.analysis.db2view.codedetails")) {
                HashMap<String, Object[]> codeViewArgs = new HashMap<String, Object[]>();
                ArrayList<String[]> codeViewTitles = new ArrayList<String[]>();
                codeViewArgs.put("DDN", new Object[]{rowModel.getDbrm()});
                codeViewArgs.put("Statement", new Object[]{rowModel.getStmtNum()});
                codeViewTitles.add(new String[]{"DBRM", rowModel.getDbrm()});
                codeViewTitles.add(new String[]{"DB Statement", rowModel.getStmtNum()});
                MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", presentation.getAnalysisType());
                model = model.filterBy(codeViewArgs);
                model = AnalysisUtils.calculateCodeView(model, dsn, type);
                IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(CodeViewPage.class, "", dsn, type, presentation, "com.ca.mat.help.codedetail", model);
                String partName = "Code Details:";
                for (String[] entry : codeViewTitles) {
                    partName = String.valueOf(partName) + " " + entry[0] + " " + entry[1];
                }
                detachedView.setPresentationName(partName);
                AnalysisPage newPage = detachedView.getCurrentPage();
                if (newPage != null && newPage instanceof CodeViewPage) {
                    CodeViewPage codeViewPage = (CodeViewPage)newPage;
                    codeViewPage.setFilterExpressions(codeViewArgs);
                    codeViewPage.setTitleExpressions(codeViewTitles);
                }
                if (newPage != null && newPage instanceof AnalysisPageCalculated) {
                    ((AnalysisPageCalculated)newPage).refreshHeader();
                }
            }
        }
        return null;
    }

    public void showExplain(String dsn, int type, IAnalysisPagePresentation presentation, String location, String statement, MATTableModel model) {
        IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, location, dsn, type, presentation, "com.ca.mat.help.explainsql", model);
        detachedView.setPresentationName(String.format("Explain SQL: Stmt %s", statement));
        if (detachedView.getCurrentPage() instanceof TextDisplaySubpage) {
            TextDisplaySubpage newPage = (TextDisplaySubpage)detachedView.getCurrentPage();
            newPage.setHeader(new String[]{"COLUMN            HEADING   |  EXPLAIN Data                          |  Description of EXPLAIN data     "});
        }
    }

    public void showExplainInformation(String dsn, int type, IAnalysisPagePresentation presentation, String location, String statement, MATTableModel model) {
        IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplaySubpage.class, location, dsn, type, presentation, "com.ca.mat.help.explaininformation", model);
        detachedView.setPresentationName(String.format("Explain Information: Stmt %s", statement));
    }
}

