/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers.analysis;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.subpages.TextDisplayTableFormatSubpage;
import java.text.NumberFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DB2ViewStatementDetail
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        event.getCommand().getId();
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        ISelection sel = page.getSelectionProvider().getSelection();
        if (!(sel instanceof StructuredSelection)) {
            return null;
        }
        StructuredSelection sSel = (StructuredSelection)sel;
        Object obj = sSel.getFirstElement();
        IAnalysisPagePresentation presentation = page.getPresentation();
        int type = presentation.getAnalysisType();
        String dsn = presentation.getDSN();
        if (obj instanceof DB2ViewRowModel) {
            DB2ViewRowModel row = (DB2ViewRowModel)obj;
            MATTableModel result = this.populateRowModel(row);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(TextDisplayTableFormatSubpage.class, "Statement details ", dsn, type, presentation, "com.ca.mat.help.statementdetail", result);
            detachedView.setPresentationName(String.format("Statement Detail: Stmt %s", row.getStmtNum()));
        }
        return null;
    }

    private MATTableModel populateRowModel(DB2ViewRowModel db2row) {
        NumberFormat form;
        String value;
        MATTableModel model = new MATTableModel();
        StatementDetailRowModel detail = null;
        if (!db2row.getDbrm().equals("")) {
            detail = new StatementDetailRowModel(model, "DBRM or Package", db2row.getDbrm());
            model.addRow(detail);
        }
        if (!db2row.getDS().equals("")) {
            String type = "";
            value = db2row.getDS();
            type = value.equalsIgnoreCase("D") ? "Dynamic" : "Static";
            detail = new StatementDetailRowModel(model, "SQL Type ", type);
            model.addRow(detail);
        }
        if (!db2row.getStmtNum().equals("")) {
            detail = new StatementDetailRowModel(model, "Stmt Number ", db2row.getStmtNum());
            model.addRow(detail);
        }
        if (!db2row.getType().equals("")) {
            detail = new StatementDetailRowModel(model, "Statement ", db2row.getType());
            model.addRow(detail);
        }
        if (!db2row.getCallCount().equals(-1) && !db2row.getCallCount().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "Call Count ", db2row.getCallCount().toString());
            model.addRow(detail);
        }
        if (!db2row.getTotalCPU().equals(-1.0) && !db2row.getTotalCPU().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getTotalCPU());
            detail = new StatementDetailRowModel(model, "Total CPU ", value);
            model.addRow(detail);
        }
        if (!db2row.getCPUPCall().equals(-1.0) && !db2row.getCPUPCall().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getCPUPCall());
            detail = new StatementDetailRowModel(model, "CPU per Call", value);
            model.addRow(detail);
        }
        if (!db2row.getTotalRespTime().equals(-1.0) && !db2row.getTotalRespTime().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getTotalRespTime());
            detail = new StatementDetailRowModel(model, "Total Resp Time ", value);
            model.addRow(detail);
        }
        if (!db2row.getAverageRespType().equals(-1.0) && !db2row.getAverageRespType().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getAverageRespType());
            detail = new StatementDetailRowModel(model, "Avg Resp Time ", value);
            model.addRow(detail);
        }
        if (!db2row.getEnclaveCPU().equals(-1.0) && !db2row.getEnclaveCPU().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getEnclaveCPU());
            detail = new StatementDetailRowModel(model, "Enclave CPU ", value);
            model.addRow(detail);
        }
        if (!db2row.getzIIPCPU().equals(-1.0) && !db2row.getzIIPCPU().equals(0.0)) {
            form = NumberFormat.getInstance();
            form.setMinimumFractionDigits(2);
            form.setMaximumFractionDigits(8);
            value = form.format(db2row.getzIIPCPU());
            detail = new StatementDetailRowModel(model, "zIIP CPU ", value);
            model.addRow(detail);
        }
        if (!db2row.getzIIPCPU().equals(-1.0) && !db2row.getzIIPCPU().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "zIIP Qualified ", db2row.getzIIPQualified().toString());
            model.addRow(detail);
        }
        if (!db2row.getzIIPOnStandard().equals(-1.0) && !db2row.getzIIPOnStandard().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "zIIP On Standard ", db2row.getzIIPOnStandard().toString());
            model.addRow(detail);
        }
        if (!db2row.getSection().equals("")) {
            detail = new StatementDetailRowModel(model, "Section ", db2row.getSection());
            model.addRow(detail);
        }
        if (!db2row.getGetPages().equals(-1) && !db2row.getGetPages().equals(0)) {
            detail = new StatementDetailRowModel(model, "Get Pages ", db2row.getGetPages().toString());
            model.addRow(detail);
        }
        if (!db2row.getPagesReadFromDASD().equals(-1) && !db2row.getPagesReadFromDASD().equals(0)) {
            detail = new StatementDetailRowModel(model, "Pages from DASD ", db2row.getPagesReadFromDASD().toString());
            model.addRow(detail);
        }
        if (!db2row.getFromDASDPercent().equals(-1.0) && !db2row.getFromDASDPercent().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "From DASD% ", db2row.getFromDASDPercent().toString());
            model.addRow(detail);
        }
        if (!db2row.getPagesReadFromPools().equals(-1) && !db2row.getPagesReadFromPools().equals(0)) {
            detail = new StatementDetailRowModel(model, "Pages from Pools ", db2row.getPagesReadFromPools().toString());
            model.addRow(detail);
        }
        if (!db2row.getFromPoolsPercent().equals(-1.0) && !db2row.getFromPoolsPercent().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "From Pools% ", db2row.getFromPoolsPercent().toString());
            model.addRow(detail);
        }
        if (!db2row.getAdditionalPagesRead().equals(-1.0) && !db2row.getAdditionalPagesRead().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "Additional Pages Read ", db2row.getAdditionalPagesRead().toString());
            model.addRow(detail);
        }
        if (!db2row.getIndexGetPages().equals(-1) && !db2row.getIndexGetPages().equals(0)) {
            detail = new StatementDetailRowModel(model, "Index Get Pages ", db2row.getIndexGetPages().toString());
            model.addRow(detail);
        }
        if (!db2row.getSyncPagesRead().equals(-1) && !db2row.getSyncPagesRead().equals(0)) {
            detail = new StatementDetailRowModel(model, "Synch Pages Read ", db2row.getSyncPagesRead().toString());
            model.addRow(detail);
        }
        if (!db2row.getAsyncPagesRead().equals(-1) && !db2row.getAsyncPagesRead().equals(0)) {
            detail = new StatementDetailRowModel(model, "Asynch Pages Read ", db2row.getAsyncPagesRead().toString());
            model.addRow(detail);
        }
        if (!db2row.getSequentialPreFetch().equals(-1) && !db2row.getSequentialPreFetch().equals(0)) {
            detail = new StatementDetailRowModel(model, "Sequential Pre Fetch ", db2row.getSequentialPreFetch().toString());
            model.addRow(detail);
        }
        if (!db2row.getListPreFetch().equals(-1) && !db2row.getListPreFetch().equals(0)) {
            detail = new StatementDetailRowModel(model, "List Pre Fetch ", db2row.getListPreFetch().toString());
            model.addRow(detail);
        }
        if (!db2row.getDynamicPreFetch().equals(-1) && !db2row.getDynamicPreFetch().equals(0)) {
            detail = new StatementDetailRowModel(model, "Dyn Pre Fetch ", db2row.getDynamicPreFetch().toString());
            model.addRow(detail);
        }
        if (!db2row.getLOBGetPages().equals(-1) && !db2row.getLOBGetPages().equals(0)) {
            detail = new StatementDetailRowModel(model, "LOB Get Pages ", db2row.getLOBGetPages().toString());
            model.addRow(detail);
        }
        if (!db2row.getRowsReturnedOrChanged().equals(-1) && !db2row.getRowsReturnedOrChanged().equals(0L)) {
            detail = new StatementDetailRowModel(model, "Rows Returned or Changed ", db2row.getRowsReturnedOrChanged().toString());
            model.addRow(detail);
        }
        if (!db2row.getParallelSubtasks().equals(-1) && !db2row.getParallelSubtasks().equals(0)) {
            detail = new StatementDetailRowModel(model, "Parallel Subtasks ", db2row.getParallelSubtasks().toString());
            model.addRow(detail);
        }
        if (!db2row.getParallelGroups().equals(-1) && !db2row.getParallelGroups().equals(0)) {
            detail = new StatementDetailRowModel(model, "Parallel Groups ", db2row.getParallelGroups().toString());
            model.addRow(detail);
        }
        if (!db2row.getStatementTriggers().equals(-1) && !db2row.getStatementTriggers().equals(0)) {
            detail = new StatementDetailRowModel(model, "Statement Triggers ", db2row.getStatementTriggers().toString());
            model.addRow(detail);
        }
        if (!db2row.getRowtTriggers().equals(-1) && !db2row.getRowtTriggers().equals(0)) {
            detail = new StatementDetailRowModel(model, "Row Triggers ", db2row.getRowtTriggers().toString());
            model.addRow(detail);
        }
        if (!db2row.getReoptimized().equals("") && !db2row.getReoptimized().trim().equals("0")) {
            detail = new StatementDetailRowModel(model, "Re- Optimized ", db2row.getReoptimized().toString());
            model.addRow(detail);
        }
        if (!db2row.getInCacheKeep().equals("") && !db2row.getInCacheKeep().trim().equals("0")) {
            detail = new StatementDetailRowModel(model, "In cache KEEPDYN(Y) ", db2row.getInCacheKeep());
            model.addRow(detail);
        }
        if (!db2row.getFoundInCache().equals(-1) && !db2row.getFoundInCache().equals(0)) {
            detail = new StatementDetailRowModel(model, "Found in cache ", db2row.getFoundInCache().toString());
            model.addRow(detail);
        }
        if (!db2row.getNotFoundInCache().equals(-1) && !db2row.getNotFoundInCache().equals(0)) {
            detail = new StatementDetailRowModel(model, "Not found in cache ", db2row.getNotFoundInCache().toString());
            model.addRow(detail);
        }
        if (!db2row.getIncrementalBinds().equals(-1) && !db2row.getIncrementalBinds().equals(0)) {
            detail = new StatementDetailRowModel(model, "Incremental Binds ", db2row.getIncrementalBinds().toString());
            model.addRow(detail);
        }
        if (!db2row.getDeclareStmt().equals("NA")) {
            detail = new StatementDetailRowModel(model, "Declare Statement ", db2row.getDeclareStmt().toString());
            model.addRow(detail);
        }
        if (!db2row.getLength().equals(-1) && !db2row.getLength().equals(0)) {
            detail = new StatementDetailRowModel(model, "Length ", db2row.getLength().toString());
            model.addRow(detail);
        }
        if (!db2row.getConnTyp().equals("")) {
            detail = new StatementDetailRowModel(model, "Connection Type ", db2row.getConnTyp().toString());
            model.addRow(detail);
        }
        if (!db2row.getRequestingLocation().equals("")) {
            detail = new StatementDetailRowModel(model, "Requesting Location ", db2row.getRequestingLocation());
            model.addRow(detail);
        }
        if (!db2row.getCorrelation().equals("")) {
            detail = new StatementDetailRowModel(model, "Correlation ", db2row.getCorrelation());
            model.addRow(detail);
        }
        if (!db2row.getOperId().equals("")) {
            detail = new StatementDetailRowModel(model, "OPER ID ", db2row.getOperId());
            model.addRow(detail);
        }
        if (!db2row.getPlan().equals("")) {
            detail = new StatementDetailRowModel(model, "Plan ", db2row.getPlan());
            model.addRow(detail);
        }
        if (!db2row.getCollection().equals("")) {
            detail = new StatementDetailRowModel(model, "Collection ", db2row.getCollection());
            model.addRow(detail);
        }
        if (!db2row.getThread().equals("") && !db2row.getThread().equals("00000000")) {
            detail = new StatementDetailRowModel(model, "Thread ", db2row.getThread().toString());
            model.addRow(detail);
        }
        if (!db2row.getThreadCount().equals(-1) && !db2row.getThreadCount().equals(0)) {
            detail = new StatementDetailRowModel(model, "Thread Count ", db2row.getThreadCount().toString());
            model.addRow(detail);
        }
        if (!db2row.getRequestingJobName().equals("")) {
            detail = new StatementDetailRowModel(model, "Req Job Name ", db2row.getRequestingJobName().toString());
            model.addRow(detail);
        }
        if (!db2row.getWLM().equals("")) {
            detail = new StatementDetailRowModel(model, "WLM ", db2row.getWLM().toString());
            model.addRow(detail);
        }
        if (!db2row.getExecutingJobName().equals("")) {
            detail = new StatementDetailRowModel(model, "Exec Job Name ", db2row.getExecutingJobName().toString());
            model.addRow(detail);
        }
        if (!db2row.getAPPLENV().equals("")) {
            detail = new StatementDetailRowModel(model, "APPLENV ", db2row.getAPPLENV().toString());
            model.addRow(detail);
        }
        if (!db2row.getCursorName().equals("")) {
            detail = new StatementDetailRowModel(model, "Cursor Name ", db2row.getCursorName().toString());
            model.addRow(detail);
        }
        if (!db2row.getRoutineName().equals("")) {
            detail = new StatementDetailRowModel(model, "Routine Name ", db2row.getRoutineName().toString());
            model.addRow(detail);
        }
        if (!db2row.getUniqueSamps().equals(-1) && !db2row.getUniqueSamps().equals(0L)) {
            detail = new StatementDetailRowModel(model, "Unique Samps ", db2row.getUniqueSamps().toString());
            model.addRow(detail);
        }
        if (!db2row.getTotalSamps().equals(-1) && !db2row.getTotalSamps().equals(0L)) {
            detail = new StatementDetailRowModel(model, "Total Samps ", db2row.getTotalSamps().toString());
            model.addRow(detail);
        }
        if (!db2row.getMaxConcSamps().equals(-1) && !db2row.getMaxConcSamps().equals(0L)) {
            detail = new StatementDetailRowModel(model, "MaxConc Samps ", db2row.getMaxConcSamps().toString());
            model.addRow(detail);
        }
        if (!db2row.getAct().equals(-1.0) && !db2row.getAct().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "Actv% ", db2row.getAct().toString());
            model.addRow(detail);
        }
        if (!db2row.getWait().equals(-1.0) && !db2row.getWait().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "Wait% ", db2row.getWait().toString());
            model.addRow(detail);
        }
        if (!db2row.getTotl().equals(-1.0) && !db2row.getTotl().equals(0.0)) {
            detail = new StatementDetailRowModel(model, "Totl% ", db2row.getTotl().toString());
            model.addRow(detail);
        }
        if (!db2row.getDataFrom().equals("")) {
            detail = new StatementDetailRowModel(model, "Data from ", db2row.getDataFrom().toString());
            model.addRow(detail);
        }
        return model;
    }

    public class StatementDetailRowModel
    extends MATTableRow {
        private String value;
        private String fieldName;

        public StatementDetailRowModel(MATTableModel model, String fieldName, String value) {
            super(model);
            this.fieldName = fieldName;
            this.value = value;
        }

        @Override
        protected Object[] getArray() {
            return new String[]{this.fieldName, this.value};
        }
    }
}

