/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.DelayLocationRowModel;
import com.ca.mat.rowmodels.IMSViewRowModel;
import com.ca.mat.rowmodels.TaskViewRowModel;
import com.ca.mat.rowmodels.TimeViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.IMSPage;
import com.ca.mat.views.pages.TaskViewPage;
import com.ca.mat.views.pages.TranViewPage;
import com.ca.mat.views.subpages.DelayLocationsSubpage;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class CallerIdPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("hasCallerId")) {
            MATTableRow rowModel;
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (page instanceof CodeViewPage) {
                CodeViewPage codeView = (CodeViewPage)page;
                if (!codeView.getModeType().equals(CodeViewRowModel.TYPE_CSECT)) {
                    return false;
                }
                if (receiver instanceof CodeViewRowModel && codeView.getTransactionId() == null && codeView.getTaskId() == null && codeView.getDBRM() == null) {
                    CodeViewRowModel rowModel2 = (CodeViewRowModel)receiver;
                    arguments.putAll(codeView.getFilterExpressions());
                    arguments.put("Csect", new Object[]{rowModel2.getCSECT()});
                    arguments.put("Module", new Object[]{rowModel2.getModule()});
                }
            } else if (page instanceof TaskViewPage && receiver instanceof TaskViewRowModel) {
                rowModel = (TaskViewRowModel)receiver;
                String taskId = ((TaskViewRowModel)rowModel).getTaskId();
                if (taskId.equals("**N/A**")) {
                    arguments.put("Task Id", new Object[]{""});
                } else {
                    arguments.put("Task Id", new Object[]{taskId});
                }
            } else if (page instanceof TranViewPage && receiver instanceof TranViewRowModel) {
                rowModel = (TranViewRowModel)receiver;
                String tranName = ((TranViewRowModel)rowModel).getTransactionName();
                if (tranName.equals("**N/A**")) {
                    arguments.put("Transaction", new Object[]{""});
                } else {
                    arguments.put("Transaction", new Object[]{tranName});
                }
            } else if (page instanceof IMSPage && receiver instanceof IMSViewRowModel) {
                rowModel = (IMSViewRowModel)receiver;
                arguments.put("Transaction", new Object[]{((IMSViewRowModel)rowModel).getTransactionId()});
            } else if (page instanceof DelayLocationsSubpage && receiver instanceof DelayLocationRowModel) {
                rowModel = (DelayLocationRowModel)receiver;
                DelayLocationsSubpage delayLocPage = (DelayLocationsSubpage)page;
                arguments.putAll(delayLocPage.getFilterExpressions());
                arguments.put("Module", new Object[]{((DelayLocationRowModel)rowModel).getModule()});
                arguments.put("Csect", new Object[]{((DelayLocationRowModel)rowModel).getCsect()});
                arguments.put("Offset", ((DelayLocationRowModel)rowModel).getAllCorrespondingOffsets().toArray());
            } else {
                return false;
            }
            if (model != null) {
                model = model.filterBy(arguments);
                MATTableRow[] mATTableRowArray = model.getRows();
                int n = mATTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MATTableRow row = mATTableRowArray[n2];
                    TimeViewRowModel timeRow = (TimeViewRowModel)row;
                    if (timeRow.getCallerModule().length() > 0) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return false;
    }
}

