/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.CodeViewRowModel;
import com.ca.mat.rowmodels.TaskViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.CodeViewPage;
import com.ca.mat.views.pages.TaskViewPage;
import com.ca.mat.views.pages.TranViewPage;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class DelayDetailsPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("hasDelayDetails")) {
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (page instanceof TaskViewPage && receiver instanceof TaskViewRowModel) {
                TaskViewRowModel rowModel = (TaskViewRowModel)receiver;
                String taskId = rowModel.getTaskId();
                if (taskId.equals("**N/A**")) {
                    arguments.put("Task Id", new Object[]{""});
                } else {
                    arguments.put("Task Id", new Object[]{taskId});
                }
            } else if (page instanceof TranViewPage && receiver instanceof TranViewRowModel) {
                TranViewRowModel rowModel = (TranViewRowModel)receiver;
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    arguments.put("Transaction", new Object[]{""});
                } else {
                    arguments.put("Transaction", new Object[]{tranName});
                }
            } else if (page instanceof CodeViewPage && receiver instanceof CodeViewRowModel) {
                CodeViewRowModel rowModel = (CodeViewRowModel)receiver;
                CodeViewPage codeView = (CodeViewPage)page;
                arguments.putAll(codeView.getFilterExpressions());
                arguments.put("Module", new Object[]{rowModel.getModule()});
                if (codeView.getModeType().equals(CodeViewRowModel.TYPE_CSECT)) {
                    arguments.put("Csect", new Object[]{rowModel.getCSECT()});
                }
            } else {
                return false;
            }
            return model != null && model.contains(arguments);
        }
        return false;
    }
}

