/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.Activator;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IMATView;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.pages.AnalysisPageBasic;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;

public class AnalysisView
extends ViewPart
implements IMATView,
ISelectionProvider,
IAnalysisPagePresentation {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String ID = "com.ca.mat.views.analysisview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.analysisview";
    protected Composite viewArea;
    private MenuManager menuMgr;
    protected String profile;
    protected String dsn;
    protected String secondaryId;
    protected int analysisType = 1;
    private AnalysisPage activePage = null;
    private Vector<IAnalysisPagePresentation> viewsToCloseUponClosing;
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    boolean detached = false;
    String fixedSubtitle;
    Label subTitleLabel;

    public AnalysisView() {
        this.viewsToCloseUponClosing = new Vector();
    }

    public void createPartControl(Composite parent) {
        this.createPartControl(parent, true);
    }

    public void createPartControl(Composite parent, boolean addCloseButton) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        parent.setLayout((Layout)layout);
        this.subTitleLabel = new Label(parent, 4);
        GridData gData = new GridData(4, 128, true, false);
        gData.horizontalIndent = 5;
        gData.verticalIndent = 0;
        this.subTitleLabel.setLayoutData((Object)gData);
        this.subTitleLabel.setVisible(false);
        this.viewArea = new Composite(parent, 4);
        this.viewArea.setLayout((Layout)new GridLayout(1, false));
        gData = new GridData(4, 4, true, true);
        gData.horizontalIndent = 0;
        gData.verticalIndent = 0;
        this.viewArea.setLayoutData((Object)gData);
        this.menuMgr = new MenuManager();
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(ID, this.menuMgr, (ISelectionProvider)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (addCloseButton) {
            Button button = new Button(parent, 8);
            gData = new GridData(0x1000000, 0x1000000, false, false);
            button.setLayoutData((Object)gData);
            button.setText("OK");
            final AnalysisView instance = this;
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    instance.getSite().getPage().hideView((IViewPart)instance);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            parent.getShell().setDefaultButton(button);
        }
    }

    @Override
    public void addPage(AnalysisPage page, boolean createControl) {
        page.setDSN(this.dsn);
        if (createControl) {
            page.createControl(this.viewArea);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            page.getControl().setLayoutData((Object)gData);
            page.getControl().setVisible(false);
            page.setType(this.analysisType);
        }
    }

    @Override
    public void showPage(AnalysisPage newPage) {
        if (this.activePage != null) {
            this.activePage.setMenu(null);
            this.activePage.getControl().setVisible(false);
            GridData gData = new GridData(4, 4, true, true);
            gData.exclude = true;
            this.activePage.getControl().setLayoutData((Object)gData);
        }
        if (newPage.getControl() == null) {
            newPage.createControl(this.viewArea);
        }
        this.hookSelectionListeners(this.activePage, newPage);
        this.activePage = newPage;
        Menu menu = this.menuMgr.createContextMenu(this.activePage.getControl());
        this.activePage.setMenu(menu);
        this.activePage.getControl().setVisible(true);
        this.activePage.setPresentation(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.activePage.getControl(), this.activePage.getContextHelpId());
        GridData gData = new GridData(4, 4, true, true);
        gData.exclude = false;
        this.activePage.getControl().setLayoutData((Object)gData);
        this.viewArea.layout();
        this.updateTitle();
    }

    public final void saveState(IMemento memento) {
        if (Activator.plugin.closing) {
            Shell shell = this.getSite().getShell();
            if (shell.getChildren().length == 1) {
                shell.close();
            } else {
                this.getSite().getPage().hideView((IViewPart)this);
            }
        }
    }

    @Override
    public AnalysisPage getActivePage() {
        return this.activePage;
    }

    @Override
    public String getDSN() {
        return this.dsn;
    }

    @Override
    public void setDSN(String dsn) {
        this.dsn = dsn;
        this.updateTitle();
    }

    @Override
    public void setAnalysisType(int type) {
        this.analysisType = type;
        this.updateTitle();
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
    }

    protected void updateTitle() {
        if (this.fixedSubtitle == null) {
            String additionalText;
            String type = "unknown";
            if (this.analysisType == 1) {
                type = "ALL";
            }
            if (this.analysisType == 0) {
                type = "NORMAL";
            }
            if (this.analysisType == 2) {
                type = "ACTIVE";
            }
            if (this.analysisType == 3) {
                type = "WAIT";
            }
            this.subTitleLabel.setVisible(true);
            String subTitleText = String.format("Analysis for: %1$s DSN: %2$s analysis type: %3$s", this.profile, this.dsn, type);
            if (this.activePage instanceof AnalysisPageBasic && !(additionalText = ((AnalysisPageBasic)this.activePage).getAdditionalTitleText()).equals("")) {
                subTitleText = String.valueOf(subTitleText) + ", " + additionalText;
            }
            this.subTitleLabel.setText(subTitleText);
        }
    }

    public void overrideSubtitle(String subtitle) {
        this.subTitleLabel.setText(subtitle);
    }

    @Override
    public void setPresentationName(String title) {
        super.setPartName(title);
    }

    public void dispose() {
        if (!Activator.plugin.closing) {
            for (IAnalysisPagePresentation presentation : (Vector)this.viewsToCloseUponClosing.clone()) {
                presentation.closePresentation();
                this.viewsToCloseUponClosing.remove(presentation);
            }
        }
        super.dispose();
    }

    public static boolean anyOpen() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] iWorkbenchPageArray = activeWindow.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference[] references;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = references = page.getViewReferences();
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference viewRef = iViewReferenceArray[n4];
                String id = viewRef.getId();
                if (id.equals(ID) || id.startsWith("com.ca.mat.views.analysisview:")) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getActivePageID() {
        if (this.activePage != null) {
            return this.activePage.getId();
        }
        return null;
    }

    protected void requestRefresh() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEvaluationService evaluationService = (IEvaluationService)window.getService(IEvaluationService.class);
        if (evaluationService != null) {
            evaluationService.requestEvaluation("com.ca.mat.isExpectedPage");
            evaluationService.requestEvaluation("com.ca.mat.canSwitchModeTo");
            evaluationService.requestEvaluation("com.ca.mat.isFilter");
        }
    }

    @Override
    public int getAnalysisType() {
        return this.analysisType;
    }

    public void setFocus() {
        if (this.getActivePage() != null) {
            Singletons.getAnalysisManager().analysisPageFocused(this.getActivePage());
            this.viewArea.setFocus();
        }
    }

    @Override
    public void addViewToCloseUponClosing(IAnalysisPagePresentation view) {
        if (!this.viewsToCloseUponClosing.contains(view)) {
            this.viewsToCloseUponClosing.add(view);
        }
    }

    @Override
    public void removeViewToCloseUponClosing(IAnalysisPagePresentation view) {
        if (this.viewsToCloseUponClosing.contains(view)) {
            this.viewsToCloseUponClosing.remove(view);
        }
    }

    @Override
    public AnalysisPage getCurrentPage() {
        return this.activePage;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
        if (this.activePage != null && this.activePage.getSelectionProvider() != null) {
            this.activePage.getSelectionProvider().addSelectionChangedListener(listener);
        }
    }

    @Override
    public ISelection getSelection() {
        if (this.activePage != null && this.activePage.getSelectionProvider() != null) {
            return this.activePage.getSelectionProvider().getSelection();
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
        if (this.activePage != null && this.activePage.getSelectionProvider() != null) {
            this.activePage.getSelectionProvider().removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.activePage != null && this.activePage.getSelectionProvider() != null) {
            this.activePage.getSelectionProvider().setSelection(selection);
        }
    }

    public void hookSelectionListeners(AnalysisPage oldPage, AnalysisPage newPage) {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            if (oldPage != null && oldPage.getSelectionProvider() != null) {
                oldPage.getSelectionProvider().addSelectionChangedListener(listener);
            }
            if (newPage == null || newPage.getSelectionProvider() == null) continue;
            newPage.getSelectionProvider().addSelectionChangedListener(listener);
        }
    }

    @Override
    public boolean isDialog() {
        return false;
    }

    @Override
    public IAnalysisPagePresentation getParent() {
        return null;
    }

    @Override
    public void closePresentation() {
        this.getSite().getPage().hideView((IViewPart)this);
    }
}

