/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.Activator;
import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableFilterWidget;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.connect.IServerList;
import com.ca.mat.connect.IServerListListener;
import com.ca.mat.connect.MATServer;
import com.ca.mat.handlers.RefreshHandler;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.IMonitorListener;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.views.IMATView;
import com.ca.mat.views.ServerWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.ViewPart;

public class MonitorTreeView
extends ViewPart
implements IMonitorListener,
IServerListListener,
ISelectionProvider,
IMATView {
    private static final String MONITOR_INFORMATION_UPDATED = "Monitor Information updated at %1tT";
    private static final String AUTONAVIGATION_COMMAND_ID = "com.ca.mat.commands.history.open";
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String DESCRIPTION_TEXT = "Use the Refresh Server button to update servers' status";
    public static final String ID = "com.ca.mat.views.monitortreeview";
    public static final String VIEWER_MEMENTO_TYPE = "com.ca.mat.views.monitortreeview";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.HID_1904185";
    public static final String COMMAND_OPENHIST = "com.ca.mat.commands.history.open";
    public static final String COMMAND_CONNECT = "com.ca.mat.commands.connect";
    public static final String COMMAND_REFRESH = "com.ca.mat.commands.refreshservers";
    private static final Image SERVER_FAILED = Activator.plugin.getImageRegistry().get("com.ca.mat.serverfailed");
    Composite wrapper;
    ServerWidget serverWidget;
    Button expandButton;
    MATServer selectedServer = null;
    IMATTableViewer activeTableViewer = null;
    ServerWidget serverWidgetTop;
    ServerWidget serverWidgetBottom;
    MATTableFilterWidget filterWidget;
    private IServerList serverList;
    Map<IMATTableViewer, MATTableFilterWidget> filterToViewer = new HashMap<IMATTableViewer, MATTableFilterWidget>();
    Map<MATServer, ServerItem> serverItemMap = new HashMap<MATServer, ServerItem>();
    Map<MATServer, IMATTableViewer> serverViewerMap = new HashMap<MATServer, IMATTableViewer>();
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();

    public void createPartControl(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.wrapper, CONTEXT_HELP_ID);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.wrapper.setLayout((Layout)layout);
        this.serverList = Singletons.getServerList();
        MATServer connectedServer = Singletons.getServerProxy().getConnectedServer();
        for (MATServer server : this.serverList.getServers()) {
            this.createServerItem(this.wrapper, server, server == connectedServer);
            this.createViewer(this.wrapper, server, false);
        }
        Singletons.getMonitorManager().addMonitorListener(this);
        this.serverList.addChangeListener(this);
        new RefreshHandler().refreshServers(this.wrapper.getDisplay());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void dispose() {
        super.dispose();
        Singletons.getMonitorManager().removeMonitorListener(this);
        this.serverList.removeChangeListener(this);
        for (ServerItem item : this.serverItemMap.values()) {
            item.dispose();
        }
    }

    private void setUpContextMenu(IMATTableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        Control control = viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        final MonitorTreeView inst = this;
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!MonitorTreeView.this.getSite().getPage().getActivePart().equals(inst)) {
                    MonitorTreeView.this.getSite().getPage().activate((IWorkbenchPart)inst);
                }
            }
        });
        control.setMenu(menu);
    }

    private void connectServer(MATServer serverToConnect) {
        Singletons.getServerProxy().connect(serverToConnect);
    }

    public void refreshServers() {
        new RefreshHandler().refreshServers(this.wrapper.getDisplay());
    }

    Menu buildServerContextMenu(final MATServer server, Control control) {
        final IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        final MenuManager menuMgr = new MenuManager("menu", "popup:com.ca.mat.views.monitortreeview.serverwidget?after=additions");
        menuService.populateContributionManager((ContributionManager)menuMgr, "popup:com.ca.mat.views.monitortreeview.serverwidget");
        Menu popupMenu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MonitorTreeView.this.selectedServer = server;
                menuService.populateContributionManager((ContributionManager)menuMgr, "popup:com.ca.mat.views.monitortreeview.serverwidget");
                IContributionItem[] iContributionItemArray = manager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.isVisible();
                    ++n2;
                }
            }
        });
        return popupMenu;
    }

    public MATServer getSelectedServer() {
        return this.selectedServer;
    }

    public void setFocus() {
        if (this.activeTableViewer != null) {
            this.activeTableViewer.getTable().setFocus();
        } else {
            this.wrapper.setFocus();
        }
    }

    public IMATTableViewer getActiveTableViewer() {
        return this.activeTableViewer;
    }

    private void autonavigate() {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService comm = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = comm.getCommand("com.ca.mat.commands.history.open");
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        MenuManager menuMgr = new MenuManager("menu", "popup:com.ca.mat.views.monitortreeview?after=additions");
        menuService.populateContributionManager((ContributionManager)menuMgr, "popup:com.ca.mat.views.monitortreeview");
        IContributionItem contribItem = menuMgr.find(command.getId());
        if (contribItem != null) {
            contribItem.isVisible();
        }
        try {
            if (command.isEnabled()) {
                service.executeCommand("com.ca.mat.commands.history.open", null);
            }
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }

    private void createServerItem(Composite parent, MATServer server, boolean connected) {
        ServerItem item = new ServerItem(parent, 0, server);
        GridData gData = new GridData(4, 128, true, false);
        item.setLayoutData(gData);
        this.serverItemMap.put(server, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createViewer(Composite parent, MATServer server, boolean ititialVisibility) {
        MATTableFilterWidget filterWidget = new MATTableFilterWidget(parent, 0);
        IMATTableViewer viewer = MATTableViewerFactory.createNew(parent);
        filterWidget.setViewer(viewer);
        this.setUpViewerColumns(viewer);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MonitorTreeView.this.autonavigate();
            }
        });
        Singletons.getViewerSynchronizationManager().addViewer("com.ca.mat.views.monitortreeview", viewer);
        viewer.setCATableModel(Singletons.getMonitorManager().getMonitorProfilesTable());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), CONTEXT_HELP_ID);
        List<ISelectionChangedListener> list = this.selectionListeners;
        synchronized (list) {
            for (ISelectionChangedListener listener : this.selectionListeners) {
                viewer.addSelectionChangedListener(listener);
            }
            this.serverViewerMap.put(server, viewer);
        }
        this.filterToViewer.put(viewer, filterWidget);
        this.showViewer(viewer, ititialVisibility);
    }

    private void showViewer(IMATTableViewer viewer, boolean visible) {
        viewer.getTable().setFocus();
        this.setUpContextMenu(viewer);
        this.filterWidget = this.filterToViewer.get(viewer);
        this.filterWidget.setVisible(visible);
        viewer.getTable().setVisible(visible);
        GridData fData = new GridData(0);
        GridData gData = new GridData(4, 4, true, true);
        fData.exclude = !visible;
        gData.exclude = !visible;
        viewer.getTable().setLayoutData((Object)gData);
        this.filterToViewer.get(viewer).setLayoutData(fData);
        this.wrapper.layout();
        if (visible) {
            this.activeTableViewer = viewer;
        } else {
            this.activeTableViewer = null;
            this.filterWidget.resetInputField();
        }
    }

    private MATServer getServerForViewer(IMATTableViewer tableViewer) {
        for (Map.Entry<MATServer, IMATTableViewer> entry : this.serverViewerMap.entrySet()) {
            if (tableViewer != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    private void setUpViewerColumns(IMATTableViewer viewer) {
        viewer.addColumn("Profile", 5, "Profile", 1, true, false);
        viewer.addColumn("Status", 5, "Status", 1, true, true);
        viewer.addColumn("Runs", 3, "Runs", 2, true, true);
        viewer.addColumn("Description", 7, "Description", 1, true, true);
        viewer.addColumn("Schedule", 3, "Schedule", 2, false, true);
        viewer.addColumn("Jobname", 5, "Jobname", 1, true, true);
        viewer.addColumn("Stepname", 5, "Stepname", 1, true, true);
        viewer.addColumn("ProcStep", 5, "ProcStep", 1, true, true);
        viewer.addColumn("Program", 5, "Program", 1, true, true);
        viewer.addColumn("No of Monitors", 5, "No of Monitors", 2, true, true);
        viewer.addColumn("No of Job Runs", 5, "No of Job Runs", 2, true, true);
        viewer.addColumn("Multi-Step", 5, "Multi-Step", 1, true, true);
        viewer.addColumn("Step Monitoring", 5, "Step Monitoring", 1, true, true);
        viewer.addColumn("Batch", 5, "Batch", 1, true, true);
        viewer.addColumn("Date", 7, "Date", 4, true, true);
        viewer.addColumn("Time", 7, "Time", 6, true, true);
        viewer.addColumn("Monitor Dataset Name", 6, "Monitor Dataset Name", 1, true, true);
        viewer.addColumn("TCB Incl. 1", 5, "TCB Incl. 1", 1, false, true);
        viewer.addColumn("TCB Incl. 2", 5, "TCB Incl. 2", 1, false, true);
        viewer.addColumn("TCB Incl. 3", 5, "TCB Incl. 3", 1, false, true);
        viewer.addColumn("TCB Incl. 4", 5, "TCB Incl. 4", 1, false, true);
        viewer.addColumn("TCB Excl. 1", 5, "TCB Excl. 1", 1, false, true);
        viewer.addColumn("TCB Excl. 2", 5, "TCB Excl. 2", 1, false, true);
        viewer.addColumn("TCB Excl. 3", 5, "TCB Excl. 3", 1, false, true);
        viewer.addColumn("TCB Excl. 4", 5, "TCB Excl. 4", 1, false, true);
        viewer.addColumn("Observation Interval", 5, "Observation Interval", 2, false, true);
        viewer.addColumn("Observations", 5, "Observations", 2, false, true);
        viewer.addColumn("Elapsed", 5, "Elapsed", 1, false, true);
        viewer.addColumn("Start Delay", 5, "Start Delay", 1, false, true);
        viewer.addColumn("Start Window", 5, "Start Window", 1, false, true);
        viewer.addColumn("End Window", 5, "End Window", 1, false, true);
        viewer.addColumn("DB Exit", 5, "DB Exit", 1, false, true);
        viewer.addColumn("4GL Exit", 5, "4GL Exit", 1, false, true);
        viewer.addColumn("IDL Exit", 5, "IDL Exit", 1, false, true);
        viewer.addColumn("Target System 1", 5, "Target System 1", 1, false, true);
        viewer.addColumn("Target System 2", 5, "Target System 2", 1, false, true);
        viewer.addColumn("Target System 3", 5, "Target System 3", 1, false, true);
        viewer.addColumn("Target System 4", 5, "Target System 4", 1, false, true);
        viewer.addColumn("Transaction 1", 5, "Transaction 1", 1, false, true);
        viewer.addColumn("Transaction 2", 5, "Transaction 2", 1, false, true);
        viewer.addColumn("Transaction 3", 5, "Transaction 3", 1, false, true);
        viewer.addColumn("Transaction 4", 5, "Transaction 4", 1, false, true);
        viewer.addColumn("Terminal ID 1", 5, "Terminal ID 1", 1, false, true);
        viewer.addColumn("Terminal ID 2", 5, "Terminal ID 2", 1, false, true);
        viewer.addColumn("Terminal ID 3", 5, "Terminal ID 3", 1, false, true);
        viewer.addColumn("Terminal ID 4", 5, "Terminal ID 4", 1, false, true);
        viewer.addColumn("User ID 1", 5, "User ID 1", 1, false, true);
        viewer.addColumn("User ID 2", 5, "User ID 2", 1, false, true);
        viewer.addColumn("User ID 3", 5, "User ID 3", 1, false, true);
        viewer.addColumn("User ID 4", 5, "User ID 4", 1, false, true);
        viewer.addColumn("Explain SQL", 5, "Explain SQL", 1, false, true);
        viewer.addColumn("Use DB2 Catalog", 5, "Use DB2 Catalog", 1, false, true);
        viewer.addColumn("Requestor Location", 5, "Requestor Location", 1, false, true);
        viewer.addColumn("Correlation ID", 5, "Correlation ID", 1, false, true);
        viewer.addColumn("Operator ID", 5, "Operator ID", 1, false, true);
        viewer.addColumn("Thread Address", 5, "Thread Address", 1, false, true);
        viewer.addColumn("Created By", 5, "Created By", 1, false, true);
        viewer.addColumn("Date Created", 5, "Date Created", 4, false, true);
        viewer.addColumn("Time Created", 5, "Time Created", 6, false, true);
        viewer.setSortColumn(0);
        viewer.setSortDirection(128);
        viewer.setSecondarySortColumn(13, 14);
        viewer.setSecondarySortColumn(56, 57);
    }

    @Override
    public void serverAdded(final MATServer server) {
        this.wrapper.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MonitorTreeView.this.createServerItem(MonitorTreeView.this.wrapper, server, false);
                MonitorTreeView.this.createViewer(MonitorTreeView.this.wrapper, server, false);
                MonitorTreeView.this.wrapper.layout();
            }
        });
    }

    @Override
    public void serverChanged(final MATServer server) {
        this.wrapper.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MonitorTreeView.this.serverItemMap.get(server).update();
            }
        });
    }

    @Override
    public void serverRemoved(final MATServer server) {
        this.wrapper.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ServerItem item = MonitorTreeView.this.serverItemMap.get(server);
                item.dispose();
                MonitorTreeView.this.serverItemMap.remove(server);
                MonitorTreeView.this.serverViewerMap.get(server).getTable().dispose();
                MonitorTreeView.this.serverViewerMap.remove(server);
                MonitorTreeView.this.wrapper.layout();
            }
        });
    }

    @Override
    public void monitorProfilesUpdated(MATTableModel profiles) {
        MATServer server = Singletons.getServerProxy().getConnectedServer();
        IMATTableViewer viewer = this.serverViewerMap.get(server);
        if (viewer != null) {
            MonitorProfileRowModel selection = null;
            if (viewer.getSelectedRows() != null && viewer.getSelectedRows().length > 0) {
                selection = (MonitorProfileRowModel)viewer.getSelectedRows()[0];
            }
            viewer.setCATableModel(profiles);
            if (selection != null) {
                int i = 0;
                TableItem[] tableItemArray = viewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData() != null && ((MonitorProfileRowModel)item.getData()).getProfileName().equals(selection.getProfileName())) {
                        viewer.getTable().select(i);
                    }
                    ++i;
                    ++n2;
                }
            }
            if (profiles == null || profiles.getRows().length == 0) {
                this.showViewer(viewer, false);
                this.selectedServer = null;
            } else {
                this.showViewer(viewer, true);
                this.selectedServer = this.getServerForViewer(viewer);
            }
        }
    }

    @Override
    public void monitorHistoryUpdated(MATServer server, String profile, MATTableModel history) {
    }

    @Override
    public void monitorSchedulesUpdated(MATTableModel schedules) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        List<ISelectionChangedListener> list = this.selectionListeners;
        synchronized (list) {
            this.selectionListeners.add(listener);
        }
        for (IMATTableViewer viewer : this.serverViewerMap.values()) {
            viewer.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.getActiveTableViewer() == null) {
            return null;
        }
        return this.getActiveTableViewer().getSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        List<ISelectionChangedListener> list = this.selectionListeners;
        synchronized (list) {
            this.selectionListeners.remove(listener);
        }
        for (IMATTableViewer viewer : this.serverViewerMap.values()) {
            viewer.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.getActiveTableViewer() == null) {
            return;
        }
        this.getActiveTableViewer().setSelection(selection);
    }

    private class ServerItem
    extends Composite
    implements IPropertyChangeListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        Label iconLabel;
        Label statusLabel;
        MATServer serverInstance;

        public ServerItem(Composite parent, int style, MATServer server) {
            super(parent, style | 0x800);
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 0;
            this.setLayout((Layout)layout);
            this.serverInstance = server;
            this.iconLabel = new Label((Composite)this, 0);
            GridData gData = new GridData(16384, 0x1000000, false, false);
            this.statusLabel = new Label((Composite)this, 0x800000);
            gData = new GridData(4, 128, true, false);
            this.statusLabel.setLayoutData((Object)gData);
            this.statusLabel.setAlignment(16384);
            this.update();
            this.statusLabel.setMenu(MonitorTreeView.this.buildServerContextMenu(this.serverInstance, (Control)this));
            this.statusLabel.addMouseListener((MouseListener)this);
            if (Activator.plugin.hasRAPFragment()) {
                this.statusLabel.setBackground(Display.getCurrent().getSystemColor(1));
            } else {
                this.serverInstance.addPropertyChangeListener(this);
            }
        }

        public void update() {
            if (Activator.plugin.hasRAPFragment()) {
                this.statusLabel.setText(" Server " + this.serverInstance.getStatusText());
                this.statusLabel.setForeground(this.serverInstance.getStatusColor());
            } else {
                this.statusLabel.setText(" " + this.serverInstance.getName() + " (" + this.serverInstance.getStatusText() + ")");
            }
            this.iconLabel.setImage(this.serverInstance.getStatusIcon());
            this.statusLabel.setToolTipText(this.serverInstance.getTooltip());
            this.layout();
            this.getParent().layout();
        }

        public void dispose() {
            super.dispose();
            this.serverInstance.removePropertyChangeListener(this);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                if (Singletons.getServerProxy().getConnectedServer() == this.serverInstance) {
                    MonitorTreeView.this.refreshServers();
                } else {
                    MonitorTreeView.this.selectedServer = this.serverInstance;
                    MonitorTreeView.this.connectServer(this.serverInstance);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            MonitorTreeView.this.wrapper.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ServerItem.this.update();
                }
            });
        }
    }
}

