/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.subpages;

import com.ca.mat.utils.HexUtil;
import com.ca.mat.views.pages.AnalysisPageBasic;
import com.ca.mat.views.pages.WASViewPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWASSubpage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    protected WASViewPage.WASContextRestrictions contextRestrictions = null;
    private Composite wrapper;
    private Label methodLabel;
    private Label classLabel;
    private Label lineNumberLabel;
    private Label transactionLabel;
    private Label modeLabel;
    private Label sqlStatementLabel;
    private Label typeLabel;

    public WASViewPage.WASContextRestrictions getContextRestrictions() {
        if (this.contextRestrictions == null) {
            return null;
        }
        return this.contextRestrictions.clone();
    }

    public void setContextRestrictions(WASViewPage.WASContextRestrictions contextRestrictions) {
        if (this.contextRestrictions == null) {
            this.contextRestrictions = contextRestrictions.clone();
        }
    }

    @Override
    public void createHeaderPart(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        this.wrapper.setLayout((Layout)new RowLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.wrapper.setLayoutData((Object)gridData);
        this.typeLabel = new Label(this.wrapper, 4);
        this.modeLabel = new Label(this.wrapper, 4);
        this.transactionLabel = new Label(this.wrapper, 4);
        this.classLabel = new Label(this.wrapper, 4);
        this.methodLabel = new Label(this.wrapper, 4);
        this.lineNumberLabel = new Label(this.wrapper, 4);
        this.sqlStatementLabel = new Label(this.wrapper, 4);
    }

    public void refreshHeader() {
        if (this.contextRestrictions != null) {
            if (this.contextRestrictions.getFrom() != null) {
                this.typeLabel.setText("Mode: " + this.contextRestrictions.getFrom() + "    ");
                if (this.getTitleText() != null) {
                    this.modeLabel.setText("Type: " + this.getTitleText() + "    ");
                }
            } else if (this.contextRestrictions.getDataMode() != null) {
                this.modeLabel.setText("Type: " + this.getTitleText() + "    ");
            }
            if (this.contextRestrictions.getWASMethodNameTranslated() != null) {
                this.methodLabel.setText("Method Name: " + this.contextRestrictions.getWASMethodNameTranslated() + "    ");
            }
            if (this.contextRestrictions.getWASClassNameTranslated() != null) {
                this.classLabel.setText("Class Name: " + this.contextRestrictions.getWASClassNameTranslated() + "    ");
            }
            if (this.contextRestrictions.getWASTransaction() != null) {
                this.transactionLabel.setText("Transaction: " + HexUtil.Squeeze(this.contextRestrictions.getWASTransactionTranslated()) + "     ");
            }
            if (this.contextRestrictions.getLineNumber() != null) {
                String line = this.contextRestrictions.getLineNumber().trim();
                if (line.equals("")) {
                    line = "NotAvail";
                }
                this.lineNumberLabel.setText("Line Number: " + line + "     ");
            }
            if (this.contextRestrictions.getSqlStatement() != null) {
                this.sqlStatementLabel.setText("SQL Statement: " + this.contextRestrictions.getSqlStatement() + "    ");
            }
            this.wrapper.getParent().layout(true, true);
        }
    }

    private String getTitleText() {
        String mode = "";
        String modeSubtype = this.contextRestrictions.getDataMode();
        if (modeSubtype == null) {
            return null;
        }
        mode = modeSubtype.equals("data_mode_application") ? "Application" : (modeSubtype.equals("data_mode_via") ? "Via" : (modeSubtype.equals("data_mode_current") ? "Current" : "Unknown"));
        return mode;
    }
}

