/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.xml;

import com.ca.mat.MATException;
import com.ca.mat.utils.HexUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocument
implements Serializable {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    protected static final boolean optimizeEncode = Boolean.getBoolean("com.ca.testingtools.common.XMLFile.encodeoptimize");
    private static final long serialVersionUID = -3947711094998392848L;
    protected Document document = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected Element root = null;

    public static String decodeAttribute(Element element, String attribute) {
        String value = element.getAttribute(attribute == null ? "recstring" : attribute);
        if (optimizeEncode && value != null && value.indexOf(37) == -1) {
            return value;
        }
        return URLDecoder.decode(value);
    }

    public static void encodeAttribute(Element element, String record, String attribute) {
        record = record == null ? "" : HexUtil.rightTrim(record);
        String value = URLEncoder.encode(record);
        if (optimizeEncode && value.indexOf(37) == -1) {
            value = record;
        }
        element.setAttribute(attribute == null ? "recstring" : attribute, value);
    }

    public static Integer getInt(String name, Element element) {
        return XMLDocument.getInt(name, element, 0);
    }

    public static Integer getInt(String name, Element element, Integer value) {
        String result = element.getAttribute(name);
        if (result == null) {
            return value;
        }
        try {
            return Integer.decode(result);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    public static String getName(Element element) {
        return XMLDocument.decodeAttribute(element, "name");
    }

    public static void removeEmptyTextNodes(Node node) {
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int x = nodeList.getLength() - 1;
        while (x >= 0) {
            Node childNode = nodeList.item(x);
            if (childNode.getNodeType() == 3) {
                String value = childNode.getNodeValue().trim();
                if (value.isEmpty()) {
                    node.removeChild(childNode);
                } else if (value.equals(HexUtil.LF)) {
                    node.removeChild(childNode);
                } else if (value.equals("\n")) {
                    node.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                XMLDocument.removeEmptyTextNodes(childNode);
            }
            --x;
        }
    }

    public static void setName(Element element, String name) {
        if (element == null) {
            return;
        }
        if (name == null) {
            name = "";
        }
        XMLDocument.encodeAttribute(element, name, "name");
    }

    public XMLDocument() {
        this.newDocument();
    }

    public XMLDocument(File file) throws MATException {
        FileReader inReader = null;
        try {
            try {
                inReader = new FileReader(file);
                InputSource input = new InputSource(inReader);
                this.buildXML(input, file.getName());
            }
            catch (FileNotFoundException e) {
                throw new MATException(e);
            }
        }
        catch (Throwable throwable) {
            if (inReader != null) {
                try {
                    inReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inReader != null) {
            try {
                inReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public XMLDocument(InputStream input, String source) throws MATException {
        InputSource insource = new InputSource(input);
        this.buildXML(insource, source);
    }

    protected void buildXML(InputSource input, String source) throws MATException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(input);
        }
        catch (SAXParseException spe) {
            this.log.log(Level.INFO, "", "Error parsing xml on line " + spe.getLineNumber() + ", source:" + source);
            this.log.log(Level.INFO, "", " " + spe.getMessage());
            if (spe.getException() != null) {
                this.log.log(Level.INFO, "", spe.getException());
            }
            throw new MATException(spe);
        }
        catch (SAXException sxe) {
            if (sxe.getException() != null) {
                this.log.log(Level.INFO, "", sxe.getException());
            }
            throw new MATException(sxe);
        }
        catch (ParserConfigurationException pce) {
            this.log.log(Level.INFO, "", pce);
            throw new MATException(pce);
        }
        catch (IOException ioe) {
            this.log.log(Level.INFO, "", ioe);
            throw new MATException(ioe);
        }
        if (this.document == null) {
            throw new MATException("Missing document");
        }
        this.setRoot();
    }

    public Element createElement(String name) {
        try {
            return this.document.createElement(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void fromString(String xmlsource) throws MATException {
        StringReader xmlin = new StringReader(xmlsource);
        InputSource input = new InputSource(xmlin);
        this.buildXML(input, "String");
    }

    public Element getRoot() {
        if (this.document == null) {
            this.newDocument();
        }
        if (this.root == null) {
            this.setRoot();
        }
        return this.root;
    }

    public Node getTag(Node node, String tag) {
        Node worknode = node.getFirstChild();
        while (worknode != null) {
            if (worknode.getNodeName().equalsIgnoreCase(tag)) {
                return worknode;
            }
            worknode = node.getNextSibling();
        }
        return null;
    }

    protected void newDocument() {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    protected void setRoot() {
    }

    public void toFile(OutputStream stream) {
        this.toFile(stream, false);
    }

    public void toFile(OutputStream stream, boolean formatted) {
        this.document.normalizeDocument();
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(stream);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            if (formatted) {
                xformer.setOutputProperty("indent", "yes");
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    public void toFile(String filename) throws MATException {
        try {
            FileWriter writer = new FileWriter(filename, false);
            this.toFile(writer, false);
            writer.close();
        }
        catch (IOException e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    public void toFile(String filename, boolean formatted) throws MATException {
        try {
            FileWriter writer = new FileWriter(filename, false);
            this.toFile(writer, formatted);
            writer.close();
        }
        catch (IOException e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    public void toFile(Writer writer) {
        this.toFile(writer, false);
    }

    public void toFile(Writer writer, boolean formatted) {
        this.document.normalizeDocument();
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(writer);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            if (formatted) {
                xformer.setOutputProperty("indent", "yes");
            }
            xformer.transform(source, result);
        }
        catch (Exception e) {
            this.log.log(Level.INFO, "", e);
        }
    }

    public InputStream toInputStream() {
        try {
            File file = File.createTempFile("CAVH", ".xml");
            file.deleteOnExit();
            this.toFile(file.getAbsolutePath(), false);
            FileInputStream is = new FileInputStream(file);
            return is;
        }
        catch (Exception e) {
            this.log.log(Level.INFO, "", e);
            return null;
        }
    }

    public String toString() {
        try {
            StringWriter xmlout = new StringWriter();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(xmlout);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
            return xmlout.toString();
        }
        catch (Exception e) {
            this.log.log(Level.INFO, "", e);
            return this.document.toString();
        }
    }
}

