/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.customlayout.wizards;

import com.ca.filemaster.common.CRLClass;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.customlayout.wizards.CRLServerPage;
import com.ca.filemaster.customlayout.wizards.CRLUpdate1Page;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CRLUpdate1
extends Wizard
implements INewWizard {
    static final String cacopyright = "Copyright (c) 2016 CA";
    private CRLUpdate1Page page;
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private FileMasterServer server;
    private FileMasterDataset dataset;
    private FileMasterMember member;
    private boolean createNew;
    private CRLClass crl;
    private String title;
    private Object object;
    private CRLServerPage serverPage;

    public CRLUpdate1(boolean createNew) {
        this.createNew = createNew;
        this.title = createNew ? "Custom Layout Definition" : "Custom Layout Update";
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TrayDialog.setDialogHelpAvailable((boolean)true);
        this.setWindowTitle(this.title);
        this.crl = new CRLClass();
        boolean isLayout = false;
        this.object = selection.getFirstElement();
        if (this.object != null) {
            TT_TreeItem treeItem = this.layoutModel.findObject(this.object);
            if (treeItem != null) {
                this.server = null;
                if (treeItem.getParent() != null) {
                    this.member = (FileMasterMember)treeItem.getAdapter(FileMasterMember.class);
                    this.dataset = (FileMasterDataset)treeItem.getParent().getAdapter(FileMasterDataset.class);
                } else {
                    this.member = null;
                    this.dataset = (FileMasterDataset)treeItem.getAdapter(FileMasterDataset.class);
                }
            } else {
                this.member = null;
                this.dataset = null;
                this.server = null;
            }
            TT_TreeItem result = treeItem.getParent(FileMasterMember.class);
            if (result != null && treeItem.getValue() instanceof FileMasterMember) {
                ((FileMasterMember)treeItem.getValue()).getType().equalsIgnoreCase("CRL");
                isLayout = ((FileMasterMember)treeItem.getValue()).getType().equalsIgnoreCase("LAYOUT");
            }
            if (isLayout) {
                TT_TreeItem[] layouts = (TT_TreeItem[])treeItem.getChildren();
                int i = 0;
                while (i < layouts.length) {
                    CRLClass.Layout tempLayout = this.crl.addLayout(this.dataset.getName(), this.member.getName());
                    layouts[i].getElement().getAttribute("level");
                    String length = layouts[i].getElement().getAttribute("length");
                    int lengthValue = 0;
                    if (!length.isEmpty()) {
                        lengthValue = Integer.parseInt(length);
                    }
                    tempLayout.addField(layouts[i].getElement().getAttribute("name"), Integer.parseInt(layouts[i].getElement().getAttribute("level")), true, true, Integer.parseInt(layouts[i].getElement().getAttribute("position")), "", Integer.parseInt(layouts[i].getElement().getAttribute("integerLength")), Integer.parseInt(layouts[i].getElement().getAttribute("fractionLength")), lengthValue, 0, 0, "");
                    int j = 0;
                    while (j < layouts[i].getChildren().length) {
                        length = ((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("length");
                        lengthValue = 0;
                        if (!length.isEmpty()) {
                            lengthValue = Integer.parseInt(length);
                        }
                        tempLayout.addField(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("name"), Integer.parseInt(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("level")), true, true, Integer.parseInt(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("position")), ((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("signed").equalsIgnoreCase("Y") ? String.valueOf(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("formatChar")) + "S" : ((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("formatChar"), Integer.parseInt(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("integerLength")), Integer.parseInt(((TT_TreeItem)layouts[i].getChildren()[j]).getElement().getAttribute("fractionLength")), lengthValue, 0, 0, "");
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if (this.dataset != null) {
            this.crl.setDatasetName(this.dataset.getName());
        }
        if (this.member != null && !this.createNew) {
            this.crl.setMemberName(this.member.getName());
        }
    }

    public void addPages() {
        if (this.createNew) {
            this.page = new CRLUpdate1Page(this.title, this.crl, this.createNew, this.server);
            this.addPage((IWizardPage)this.page);
        } else {
            this.setForcePreviousAndNextButtons(true);
            this.serverPage = new CRLServerPage("Select Server", this.dataset, this.member, this.object);
            this.addPage((IWizardPage)this.serverPage);
        }
    }

    public boolean canFinish() {
        if (!this.getContainer().getCurrentPage().getName().equalsIgnoreCase("Select Server")) {
            return ((CRLUpdate1Page)this.getContainer().getCurrentPage()).isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        if (this.page == null) {
            return ((CRLUpdate1Page)this.serverPage.getUpdatePage()).doFinish();
        }
        return this.page.doFinish();
    }
}

