/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.wizards;

import com.ca.filemaster.Activator;
import com.ca.filemaster.common.FMLayoutTreeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.osgi.framework.Bundle;

public class LayoutWizardImportPage
extends WizardDataTransferPage
implements Runnable {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String STORE_SOURCE_NAMES_ID = "destination_names";
    Logger log = Logger.getLogger(this.getClass().getName());
    protected Combo sourceNameField;
    private final String CONTEXT_HELP_ID = "com.ca.testingtools.help.importWizardPage";
    private Button sourceBrowseButton;
    private Thread platformRestart;
    private Runnable runnableObj = this;
    private Runnable restartPlatform = new Runnable(){

        @Override
        public void run() {
            PlatformUI.getWorkbench().restart();
        }
    };

    protected LayoutWizardImportPage(String pageName) {
        super(pageName);
        this.setTitle("Layout Settings");
        this.setDescription("Select Layout import file using browse, the drop-down list, or type it in.");
    }

    protected LayoutWizardImportPage() {
        super("Import");
    }

    public boolean cancel() {
        this.saveWidgetValues();
        return true;
    }

    public boolean finish() {
        boolean restart;
        String message = "Importing this file requires restarting in order to be enabled.";
        MessageDialog dialog = new MessageDialog(this.getShell(), "Import Profile", null, message, 6, new String[]{"Restart now", "Restart later", "Cancel import"}, 0);
        int response = dialog.open();
        switch (response) {
            case 0: {
                restart = true;
                break;
            }
            case 1: {
                restart = false;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            int len;
            File importfile = new File(this.getSourceValue());
            FileInputStream fileReader = new FileInputStream(importfile);
            String filename = FMLayoutTreeModel.setFileName();
            IPath propertyPath = Platform.getStateLocation((Bundle)Activator.plugin.getBundle());
            String fullPathName = propertyPath.append(filename).toOSString();
            FileOutputStream fileWriter = new FileOutputStream(fullPathName);
            byte[] buf = new byte[8096];
            while ((len = fileReader.read(buf)) != -1) {
                fileWriter.write(buf, 0, len);
            }
            fileReader.close();
            fileWriter.close();
            this.saveWidgetValues();
            if (restart) {
                this.platformRestart = new Thread(this.runnableObj, "test");
                this.platformRestart.start();
            }
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, e.getClass().getSimpleName(), e);
            this.setErrorMessage("Error occurred trying to import settings");
            return false;
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.importWizardPage");
        this.setControl((Control)composite);
    }

    protected void createSourceGroup(Composite parent) {
        Font parentFont = parent.getFont();
        Composite sourceSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceSelectionGroup.setLayout((Layout)layout);
        sourceSelectionGroup.setLayoutData((Object)new GridData(768));
        sourceSelectionGroup.setFont(parentFont);
        Label dest = new Label(sourceSelectionGroup, 0);
        dest.setText("Import File");
        dest.setFont(parentFont);
        this.sourceNameField = new Combo(sourceSelectionGroup, 2052);
        this.sourceNameField.addListener(24, (Listener)this);
        this.sourceNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parentFont);
        this.sourceBrowseButton = new Button(sourceSelectionGroup, 8);
        this.sourceBrowseButton.setText("Browse");
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setFont(parentFont);
    }

    protected String getSourceValue() {
        return this.sourceNameField.getText().trim();
    }

    protected void setSourceValue(String value) {
        this.sourceNameField.setText(value);
    }

    protected void handleSourceBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        dialog.setText("Export to File");
        dialog.setFilterPath(this.getSourceValue());
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setSourceValue(selectedFileName);
        }
    }

    protected int getFileDialogStyle() {
        return 4096;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setSourceValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addSourceItem(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void addSourceItem(String value) {
        this.sourceNameField.add(value);
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getSourceValue());
            settings.put(STORE_SOURCE_NAMES_ID, directoryNames);
        }
    }

    protected boolean validateSourceGroup() {
        if (!this.validSource()) {
            this.setErrorMessage(this.getInvalidSourceMessage());
            return false;
        }
        return true;
    }

    private String getInvalidSourceMessage() {
        return "No source file defined";
    }

    protected boolean validSource() {
        File file = new File(this.getSourceValue());
        return file.exists() && !file.isDirectory();
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroup(Composite parent) {
    }

    @Override
    public void run() {
        try {
            Thread.sleep(500L);
            Display.getDefault().asyncExec(this.restartPlatform);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

