/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.layout.wizards;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.layout.wizards.UpdateLayoutPage;
import com.ca.testingtools.ui.TextUtil;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ViewLayoutServerPage
extends WizardPage {
    protected Composite container;
    protected Composite serverComposite;
    protected Label serverLabel;
    protected String serverName;
    public Combo serverCombo;
    private FileMasterServer server;
    private FMServerTreeModel fmstModel = FMServerTreeModel.getInstance();
    private UpdateLayoutPage nextPage;

    protected ViewLayoutServerPage(String pageName, String datasetName, String memberName) {
        super(pageName);
        this.setTitle("Select Server");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.serverComposite = new Composite(this.container, 0);
        this.serverComposite.setLayout((Layout)new GridLayout(2, false));
        this.serverLabel = new Label(this.serverComposite, 0);
        this.serverLabel.setText("Se&rver:");
        this.serverCombo = new Combo(this.serverComposite, 2056);
        this.serverCombo.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Combo)this.serverCombo, (int)37);
        this.serverCombo.setTextLimit(44);
        this.serverCombo.setItems(this.getServers());
        if (this.serverCombo.getItemCount() > 0) {
            boolean lastServerExists = false;
            String lastServerUsed = FMHistory.getServer((String)"ServerAddLayoutPage1");
            int count = 0;
            while (count < this.serverCombo.getItemCount()) {
                if (this.serverCombo.getItem(count).toString().equalsIgnoreCase(lastServerUsed)) {
                    lastServerExists = true;
                    this.serverCombo.setText(this.serverCombo.getItem(count).toString());
                    break;
                }
                ++count;
            }
            if (!lastServerExists) {
                this.serverCombo.setText(this.serverCombo.getItem(0));
            }
            this.changeServer();
        }
        this.serverCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewLayoutServerPage.this.changeServer();
            }
        });
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    private void changeServer() {
        String TestServer = "";
        int servers = 0;
        while (servers < this.fmstModel.getServers().length) {
            TestServer = this.fmstModel.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.serverCombo.getText())) {
                this.server = (FileMasterServer)this.fmstModel.getServers()[servers].getAdapter(FileMasterServer.class);
                break;
            }
            ++servers;
        }
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.fmstModel.getServers().length];
        int serverCount = 0;
        while (serverCount < this.fmstModel.getServers().length) {
            listOfServers[serverCount] = this.fmstModel.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        return listOfServers;
    }

    public IWizardPage getNextPage() {
        FMHistory.clearList((String)"ServerAddLayoutPage1");
        FMHistory.insertHistory((Combo)this.serverCombo, (String)"ServerAddLayoutPage1");
        this.nextPage = (UpdateLayoutPage)this.getWizard().getPage("View Layout");
        this.nextPage.setServer(this.server);
        ArrayList fmLayoutList = new ArrayList();
        if (this.nextPage.process("")) {
            this.nextPage.setFmLayoutList(fmLayoutList);
            return this.nextPage;
        }
        return null;
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.serverCombo.setFocus();
    }
}

