/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.IBreakpointMessage;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BreakpointMessage
extends DebugMessage
implements IDebugMessage,
IBreakpointMessage {
    String cacopyright = "Copyright (c) 2016 CA";
    private static final String FORMAT_2 = "%1$s";
    private static final String FORMAT_1 = "%1$s Stmt:%2$d Line:%3$d";
    protected long breakpointID = 0L;
    protected int skipcount = 0;
    protected byte flag1 = 0;
    protected boolean enabled = true;
    protected boolean isCICS = false;
    protected int linenumber = 0;
    protected int statement = 1;
    protected boolean stopAfter = false;

    protected BreakpointMessage() {
        this(true);
    }

    protected BreakpointMessage(boolean b) {
        super(true);
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.putProgram());
        this.buffer.put(this.putAvailable());
        this.buffer.putLong(this.breakpointID);
        this.buildSubBPMessage();
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    protected abstract void buildSubBPMessage() throws ITException, UnsupportedEncodingException;

    @Override
    public long getBreakpointID() {
        return this.breakpointID;
    }

    @Override
    public void setBreakpointID(long breakpointID) {
        this.breakpointID = breakpointID;
    }

    @Override
    public int getSkipcount() {
        return this.skipcount;
    }

    @Override
    public void setSkipcount(int skipcount) {
        this.skipcount = skipcount;
    }

    @Override
    protected boolean _checkID(short messageID) {
        return messageID == this._defaultID() || messageID == 5;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getStatement() {
        return this.statement;
    }

    @Override
    public void setStatement(int statement) {
        this.statement = statement;
    }

    @Override
    public void setStatement(Object statement) {
        if (statement == null) {
            return;
        }
        if (statement instanceof Number) {
            this.setStatement(((Number)statement).intValue());
        } else {
            try {
                this.setStatement(Integer.parseInt(statement.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setBreakpointID(Object breakpointID) {
        if (breakpointID == null) {
            return;
        }
        if (breakpointID instanceof Number) {
            this.setBreakpointID(((Number)breakpointID).longValue());
        } else {
            try {
                this.setBreakpointID(Long.parseLong(breakpointID.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setEnabled(Object enabled) {
        if (enabled == null) {
            return;
        }
        if (enabled instanceof Boolean) {
            this.setEnabled((Boolean)enabled);
        } else {
            this.setEnabled(Boolean.parseBoolean(enabled.toString()));
        }
    }

    @Override
    public void setProgram(Object program) {
        if (program == null) {
            return;
        }
        this.setProgram(program.toString());
    }

    @Override
    public void setSkipcount(Object skipcount) {
        if (skipcount == null) {
            return;
        }
        if (skipcount instanceof Number) {
            this.setSkipcount(((Number)skipcount).intValue());
        } else {
            try {
                this.setSkipcount(Integer.parseInt(skipcount.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    protected void fillOffsets(ByteBuffer buffer, String offset) {
        byte[] workarea = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(workarea);
        if (offset != null && offset.length() > 0) {
            int count = 0;
            Pattern pattern = Pattern.compile("[\\+\\-@%][\\w]+");
            Matcher matcher = pattern.matcher(offset);
            try {
                block2: while (matcher.find() && count < 5) {
                    String spec = matcher.group();
                    if (spec.length() <= 1) continue;
                    String prefix = spec.substring(0, 1);
                    String number = spec.substring(1);
                    int value = Integer.decode("0x" + number);
                    int j = 0;
                    while (j < IDebugMessage.OFFSET_SYMBOLS.length) {
                        if (IDebugMessage.OFFSET_SYMBOLS[j].matches(prefix)) {
                            buf.put(IDebugMessage.OFFSET_FLAGS[j]);
                            buf.putInt(value);
                            ++count;
                            continue block2;
                        }
                        ++j;
                    }
                }
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
        buffer.put(workarea);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + this.linenumber;
        result = 31 * result + this.getProgram().hashCode();
        result = 31 * result + this.skipcount;
        result = 31 * result + this.statement;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IBreakpointMessage)) {
            return false;
        }
        IBreakpointMessage other = (IBreakpointMessage)obj;
        if (this.enabled != other.isEnabled()) {
            return false;
        }
        if (!this.getProgram().equals(other.getProgram())) {
            return false;
        }
        if (this.skipcount != other.getSkipcount()) {
            return false;
        }
        if (this.statement != other.getStatement()) {
            return false;
        }
        if (this.stopAfter != other.getStopAfter()) {
            return false;
        }
        return this.submessageID == other.getSubmessageID();
    }

    @Override
    public boolean getStopAfter() {
        return this.stopAfter;
    }

    @Override
    public void setStopAfter(boolean stopAfter) {
        this.stopAfter = stopAfter;
    }

    @Override
    public void setStopAfter(Object stopAfter) {
        if (stopAfter == null) {
            return;
        }
        if (stopAfter instanceof Boolean) {
            this.setStopAfter((Boolean)stopAfter);
        } else {
            try {
                this.setStopAfter(Boolean.parseBoolean(stopAfter.toString()));
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        if (this.stopAfter) {
            submessageID = (short)(submessageID + 10);
        }
        super.setSubmessageID(submessageID);
    }

    @Override
    public boolean isCICS() {
        return this.isCICS;
    }

    @Override
    public void setIsCICS(boolean isCics) {
        this.isCICS = isCics;
    }

    @Override
    public void setIsCICS(Object isCics) {
        if (isCics == null) {
            return;
        }
        if (isCics instanceof Boolean) {
            this.setIsCICS((Boolean)isCics);
        } else {
            this.setIsCICS(false);
        }
    }

    @Override
    protected String _toString() {
        return String.format(this.linenumber == 0 ? FORMAT_2 : FORMAT_1, this.getProgram(), this.getStatement());
    }
}

