/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class QueueListMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final int SELECTION_SIZE = 56;
    private ArrayList<String> entries = new ArrayList();
    public static final short OK = 0;

    public short getResult() {
        return this.submessageID;
    }

    @Override
    protected short _defaultID() {
        return 32;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.putShort((short)this.entries.size());
        for (String item : this.entries) {
            this.buffer.put(item.getBytes("IBM1047"));
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.entries.clear();
        int size = Numbers.getUShort(this.buffer.getShort());
        int stride = this.getSubmessageID() == 0 ? 56 : (int)this.submessageID;
        int i = 0;
        while (i < size) {
            byte[] bytes = new byte[stride];
            this.buffer.get(bytes);
            this.entries.add(new String(bytes, "IBM1047"));
            ++i;
        }
    }

    public String[] getEntries() {
        return this.entries.toArray(new String[this.entries.size()]);
    }

    public String getEntry(int ix) {
        if (ix < this.entries.size() && ix >= 0) {
            return this.entries.get(ix);
        }
        return null;
    }

    @Override
    protected int _getMessageSize() {
        int capacity = 2;
        int stride = this.submessageID != 0 ? (int)this.submessageID : 56;
        return capacity += this.entries.size() * stride;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

