/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class SignonMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final short OBFUSCATED = 0;
    public static final short ENCRYPTED = 1;
    public static final short CLEAR = 2;
    protected static short defaultencryption = 0;
    private static final int OBFUSCATED_SIZE = 9;
    private static final int ENCRYPTED_SIZE = 16;
    protected String userid = "";
    protected String password = "";

    public SignonMessage() {
        this.submessageID = defaultencryption;
    }

    @Override
    protected short _defaultID() {
        return 35;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        byte[] user = new byte[8];
        this.buffer.get(user);
        this.userid = HexUtil.rightTrim(new String(user, "IBM1047"));
        switch (this.getSubmessageID()) {
            case 1: {
                throw new ITException("Encrypted password not implemented");
            }
            case 0: {
                byte[] passwrd = new byte[9];
                this.buffer.get(passwrd);
                if (passwrd[0] == 0) {
                    int i = 0;
                    while (i < 9 && passwrd[i] == 0) {
                        ++i;
                    }
                    byte[] temp = new byte[9 - i];
                    System.arraycopy(passwrd, i, temp, 0, temp.length);
                    passwrd = temp;
                }
                BigInteger clearpassword = new BigInteger(passwrd);
                BigInteger userint = new BigInteger(user);
                clearpassword = clearpassword.subtract(userint);
                this.password = HexUtil.rightTrim(new String(clearpassword.toByteArray(), "IBM1047"));
                break;
            }
            case 2: {
                this.buffer.get(user);
                this.password = HexUtil.rightTrim(new String(user, "IBM1047"));
                break;
            }
            default: {
                throw new ITException("Invalid encryption type");
            }
        }
    }

    @Override
    protected int _getMessageSize() {
        switch (this.getSubmessageID()) {
            case 1: {
                return 24;
            }
            case 0: {
                return 17;
            }
        }
        return 0;
    }

    @Override
    protected void buildMessage() throws Exception {
        byte[] buff = HexUtil.spaceFill(this.getUserid(), 8).getBytes("IBM1047");
        this.buffer.put(buff);
        switch (this.submessageID) {
            case 0: {
                BigInteger password = new BigInteger(HexUtil.spaceFill(this.getPassword(), 8).getBytes("IBM1047"));
                BigInteger userint = new BigInteger(buff);
                password = password.add(userint);
                buff = password.toByteArray();
                if (buff.length < 9) {
                    byte[] newbytes = new byte[9];
                    int ix = buff.length;
                    System.arraycopy(buff, 0, newbytes, 9 - ix, ix);
                    buff = newbytes;
                } else if (buff.length > 9) {
                    throw new ITException("Invalid Password key length");
                }
                this.buffer.put(buff);
                break;
            }
            case 2: {
                buff = HexUtil.spaceFill(this.getPassword(), 8).getBytes("IBM1047");
                this.buffer.put(buff);
                break;
            }
            case 1: {
                throw new ITException("Encrypted password not implemented");
            }
            default: {
                throw new ITException("Invalid encryption type");
            }
        }
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public short getSecurityType() {
        return this.getSubmessageID();
    }

    public void setSecurityType(short securityType) throws ITException {
        this.setSubmessageID(securityType);
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        switch (submessageID) {
            case 0: 
            case 2: {
                super.setSubmessageID(submessageID);
                break;
            }
            case 1: {
                throw new ITException("Encrypted password not implemented");
            }
            default: {
                throw new ITException("Invalid encryption type");
            }
        }
    }

    @Override
    protected String _toString() {
        return String.format("User:%s Password:%s", this.userid, this.userid == null ? null : "*****");
    }
}

