/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;

public abstract class FileMasterLabelProviderBase
extends OwnerDrawLabelProvider {
    private Logger log = Logger.getLogger(FileMasterLabelProviderBase.class.getName());

    protected void measure(Event event, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof FileMasterRecord)) {
            return;
        }
        if (event == null) {
            return;
        }
        Point size = event.gc.textExtent("");
        FileMasterRecord fileMasterRecord = (FileMasterRecord)element;
        if (fileMasterRecord.isExcluded()) {
            size = new Point(640, 16);
        } else if (fileMasterRecord.getRecordFields() != null && fileMasterRecord.getRecordFields().size() > 0) {
            FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(0);
            size = event.gc.textExtent("H");
            event.height = fileMasterRecordField.getHexData1() != null ? (int)Math.ceil((double)size.y * 3.125) : size.y;
        }
    }

    public void update(ViewerCell cell) {
        cell.setText(" ");
        super.update(cell);
    }

    protected abstract void paint(Event var1, Object var2);
}

