/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.TTLoginCancelledException;
import com.ca.testingtools.common.TTSecurityException;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.PropertyChangeManager;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.UserLogonDialog;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class TTServer
extends PropertyChangeManager
implements IAdaptable,
Comparable<TTServer>,
ITreeWrappedItem {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    private static final String sourceClass = TTServer.class.getName();
    static Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = log.getLevel();
    public static final String SERVER_NAME = "Name";
    public static final String SERVER_STATUS = "Status";
    public static final String SERVER_CONNECTING = "Connecting..";
    public static final String SERVER_UPDATEING = "Refreshing..";
    public static final String SERVER_CONNECTED = "Connected";
    public static final String SERVER_UNKNOWN = "Unknown";
    public static final String SERVER_ACTIVE = "Active";
    public static final String SERVER_HOST = "Host";
    public static final String SERVER_PORT = "Port";
    public static final String SERVER_USER = "UserID";
    public static final String SERVER_TYPE = "Type";
    public static final String SERVER_PASSWD = "Password";
    public static final String SERVER_SESSION = "Session";
    public static final String SERVER_SECUTITY_ENABLED = "SecurityEnabled";
    public static final String SERVER_UUID = "UUID";
    public static final String SERVER_SAVE_PASSWD = "SAVE_PASSWD";
    public static final int SERVER_STATUS_CONNECTING = 1;
    public static final int SERVER_STATUS_CONNECTED = 2;
    public static final int SERVER_STATUS_AVAILABLE = 3;
    private static final int SERVER_STATUS_ACTIVE_THREASHOLD = 10;
    public static final int SERVER_STATUS_UNKNOWN = 11;
    public static final int SERVER_STATUS_ERROR = 12;
    private static final boolean savepasswordEnabled = Boolean.getBoolean("com.ca.testingtools.savepassword");
    protected String name = "";
    protected String hostname = "";
    private boolean userDialog = false;
    protected int port = 0;
    private String user = "";
    private String password = "";
    private boolean savepassword = false;
    protected String prefix;
    protected ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.testingtools");
    public static final String toStringFormat = "%1$s(%2$s %3$d) %4$s";
    private String statusText = "Unknown";
    private int status = 11;
    protected String UUIDString = "";
    protected Element serverElement;
    private TT_TreeItem parent;

    public TTServer(Element server) {
        this(server.getAttribute(SERVER_NAME), server.getAttribute(SERVER_HOST), server.getAttribute(SERVER_PORT), server.getAttribute(SERVER_UUID));
    }

    public TTServer(String name, String host, String port, String uuid) {
        this.name = name == null ? "" : name;
        this.hostname = host.trim();
        this.port = Integer.decode(port.trim());
        this.UUIDString = uuid;
        this.setUUIDString();
        this.prefix = String.valueOf(uuid) + "_";
        if (!savepasswordEnabled) {
            this.setSavepassword(false);
        }
        this.savepassword = this.store.getBoolean(String.valueOf(this.prefix) + SERVER_SAVE_PASSWD);
        this.user = this.store.getString(String.valueOf(this.prefix) + SERVER_USER);
        if (this.savepassword) {
            this.password = this.store.getString(String.valueOf(this.prefix) + SERVER_PASSWD);
            this.password = HexUtil.decryptPassword((String)this.user, (String)this.password);
        }
    }

    @Override
    public int compareTo(TTServer anotherServer) {
        if (this == anotherServer) {
            return 0;
        }
        if (anotherServer == null) {
            return -1;
        }
        if (this == null) {
            return 1;
        }
        int result = this.name.compareToIgnoreCase(anotherServer.getName());
        if (result == 0) {
            result = this.port == anotherServer.getPort() ? 0 : (this.port < anotherServer.getPort() ? -1 : 1);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TTServer) {
            return this.getUUIDString().equals(((TTServer)obj).getUUIDString());
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (this.getClass().equals(adapter)) {
            return this;
        }
        return null;
    }

    public String getHostname() {
        return this.hostname == null ? null : this.hostname.trim();
    }

    public void logOff() {
        this.userDialog = false;
        this.setPassword("");
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_PASSWD, null, (Object)"");
        this.firePropertyChange(event);
    }

    public boolean isUserLoggedon() {
        return this.userDialog && this.user.length() >= 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized String getLogonUser() throws TTException {
        if (!this.userDialog || this.user.length() < 1) {
            Display display = Display.getDefault();
            final UserLogonDialog dialog = new UserLogonDialog(null, this);
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.create();
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() != 0) {
                int result = dialog.getErrorResult();
                if (result != 0) {
                    Object exception = dialog.getReturnCode() == -1 ? new TTSecurityException() : new TTException();
                    exception.setErrorLevel(result);
                    exception.setErrorMessage(dialog.getErrorText());
                    exception.setReasonCode(dialog.getReason());
                    throw exception;
                }
                throw new TTLoginCancelledException();
            }
        }
        this.userDialog = true;
        return this.user;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSavepassword() {
        return this.savepassword;
    }

    public boolean setHostname(String newhostname) {
        String string = newhostname = newhostname == null ? "" : newhostname.trim();
        if (!newhostname.equals(this.hostname)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_HOST, (Object)this.hostname, (Object)newhostname);
            this.hostname = newhostname;
            this.firePropertyChange(event);
            this.logOff();
            this.getElement();
            this.serverElement.setAttribute(SERVER_HOST, newhostname);
            return true;
        }
        return false;
    }

    public Element getElement() {
        if (this.serverElement == null) {
            this.serverElement = this.parent == null ? TTServer.BuildElement(this.name, this.hostname, this.port, this.UUIDString) : this.parent.getElement();
        }
        return this.serverElement;
    }

    public void setPassword(String password) {
        String string = password = password == null ? "" : password.trim();
        if (!this.password.equals(password)) {
            this.password = password;
            if (this.savepassword) {
                String tempassword = HexUtil.encryptPassword((String)this.user, (String)password);
                this.store.setValue(String.valueOf(this.prefix) + SERVER_PASSWD, tempassword);
                try {
                    this.store.save();
                }
                catch (IOException iOException) {}
            } else {
                this.clearPassword();
            }
        }
    }

    private void clearPassword() {
        this.store.setToDefault(String.valueOf(this.prefix) + SERVER_PASSWD);
        try {
            this.store.save();
        }
        catch (IOException iOException) {}
    }

    public boolean setPort(int port) {
        if (this.port != port) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_PORT, (Object)this.port, (Object)port);
            this.port = port;
            this.firePropertyChange(event);
            this.logOff();
            this.getElement();
            this.serverElement.setAttribute(SERVER_PORT, Integer.toString(port));
            return true;
        }
        return false;
    }

    public void setSavepassword(boolean savepassword) {
        if (this.savepassword != savepassword) {
            this.savepassword = savepassword;
            this.store.setValue(String.valueOf(this.prefix) + SERVER_SAVE_PASSWD, this.savepassword);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
            if (!savepassword) {
                this.clearPassword();
            }
        }
    }

    public boolean setUser(String user) {
        String string = user = user == null ? "" : user.trim();
        if (!this.user.equals(user)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_USER, (Object)this.user, (Object)user);
            this.user = user;
            this.firePropertyChange(event);
            this.store.setValue(String.valueOf(this.prefix) + SERVER_USER, this.user);
            try {
                this.store.save();
            }
            catch (IOException iOException) {}
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getText();
    }

    private final void setUUIDString() {
        if (this.UUIDString == null || this.UUIDString.length() == 0) {
            this.UUIDString = UUID.randomUUID().toString();
            this.getElement();
            this.serverElement.setAttribute(SERVER_UUID, this.UUIDString);
        }
    }

    public String getUUIDString() {
        this.setUUIDString();
        return this.UUIDString;
    }

    @Override
    public void setName(String name) {
        String string = name = name == null ? "" : name.trim();
        if (!this.name.equals(name)) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, SERVER_NAME, (Object)this.name, (Object)name);
            this.name = name;
            this.firePropertyChange(event);
            this.getElement();
            this.serverElement.setAttribute(SERVER_NAME, name);
        }
    }

    public String getStatusText() {
        return this.statusText == null ? SERVER_UNKNOWN : this.statusText;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatusText(int status, String statusText) {
        PropertyChangeEvent event;
        String string = statusText = statusText == null ? "" : statusText.trim();
        if (!this.statusText.equals(statusText)) {
            event = new PropertyChangeEvent((Object)this, "StatusText", (Object)this.statusText, (Object)statusText);
            this.statusText = statusText;
            this.firePropertyChange(event);
        }
        if (this.status != status) {
            event = new PropertyChangeEvent((Object)this, "status", (Object)this.status, (Object)status);
            this.status = status;
            this.firePropertyChange(event);
            if (!this.isActive()) {
                this.logOff();
            }
        }
    }

    public boolean isActive() {
        return this.status < 10;
    }

    public static Element BuildElement(String name, String hostname, int port, String uuidString) {
        Element element = ServerTreeModel.getInstance().createElement("com.ca.testingtools.server");
        if (uuidString == null || uuidString.length() == 0) {
            uuidString = UUID.randomUUID().toString();
        }
        element.setAttribute(SERVER_NAME, name);
        element.setAttribute(SERVER_HOST, hostname);
        element.setAttribute(SERVER_PORT, String.valueOf(port));
        element.setAttribute(SERVER_UUID, uuidString);
        return element;
    }

    @Override
    public TT_TreeItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TT_TreeItem parent) {
        this.parent = parent;
        this.serverElement = parent.getElement();
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public String getText() {
        return String.format(toStringFormat, this.getName(), this.getHostname(), this.getPort(), this.getStatusText());
    }

    public static void checkStatus() {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IHandlerService handlerService = this.getHandlerService();
                ICommandService commandService = this.getCommandService();
                Command generateCmd = commandService.getCommand("com.ca.testingtools.commands.refreshserver");
                ExecutionEvent executionEvent = handlerService.createExecutionEvent(generateCmd, new Event());
                try {
                    generateCmd.executeWithChecks(executionEvent);
                }
                catch (Exception e) {
                    log.log(Level.INFO, e.getClass().getSimpleName(), e);
                }
                return null;
            }

            private ICommandService getCommandService() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                Object serviceObject = workbench.getAdapter(ICommandService.class);
                if (serviceObject != null) {
                    ICommandService service = (ICommandService)serviceObject;
                    return service;
                }
                return null;
            }

            private IHandlerService getHandlerService() {
                Object serviceObject;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (serviceObject = wb.getAdapter(IHandlerService.class)) != null) {
                    IHandlerService service = (IHandlerService)serviceObject;
                    return service;
                }
                return null;
            }
        };
        job.schedule(2000L);
    }

    public String getEPassword() {
        return HexUtil.encryptPassword((String)this.user, (String)this.getPassword());
    }
}

