/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyDSN;
import com.ca.testingtools.ui.views.profile.ProfileView;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class DatasetWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected Dataset dataset;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.testingtools.help.adddataset";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.testingtools.help.updatedataset";
    protected boolean newdataset = true;
    protected Text name;
    protected final TT_TreeItem datasetParent;
    protected boolean changed = false;
    protected ServerTreeModel model = ServerTreeModel.getInstance();
    protected ArrayList<String> names = new ArrayList();
    protected boolean canHaveblankDSN = false;
    private Button makeDefault;

    public DatasetWizardPage(Dataset dataset, TT_TreeItem datasetParent, boolean newItem, String title) {
        super(newItem ? "New Dataset" : dataset.getName(), title, null);
        TT_TreeItem[] siblings;
        Object node;
        this.setDescription("Specify Dataset Details");
        this.newdataset = newItem;
        this.dataset = newItem ? null : dataset;
        this.datasetParent = datasetParent;
        if (datasetParent != null && (node = datasetParent.getAdapter(ProfileNode.class)) instanceof ProfileNode) {
            this.canHaveblankDSN = ((ProfileNode)node).callHaveDefaultChild();
        }
        if (this.newdataset || dataset == null) {
            siblings = (TT_TreeItem[])datasetParent.getChildren();
            this.newdataset = true;
        } else {
            siblings = dataset.getParent().getSiblings();
        }
        TT_TreeItem[] tT_TreeItemArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            String name = item.getName().trim();
            this.names.add(name);
            if (name.isEmpty()) {
                this.canHaveblankDSN = false;
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText("Name");
        label.setAlignment(131072);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.name = new Text(two_col, 2048);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.name.setLayoutData((Object)data);
        if (this.newdataset) {
            this.name.setText("");
        } else {
            this.name.setText(this.dataset.getName());
        }
        this.name.addModifyListener((ModifyListener)this);
        TextUtil.setWidth(this.name, 44);
        this.name.addVerifyListener((VerifyListener)new verifyDSN());
        if (this.canHaveblankDSN) {
            this.makeDefault = new Button(two_col, 32);
            this.makeDefault.setSelection(false);
            if (!this.newdataset && this.name.getText().isEmpty()) {
                this.makeDefault.setSelection(true);
            }
            this.makeDefault.setText("Use Default Dataset");
            data = new GridData(768);
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 1;
            data.horizontalSpan = 2;
            this.makeDefault.setLayoutData((Object)data);
            this.makeDefault.addSelectionListener((SelectionListener)this);
            this.name.setEnabled(!this.makeDefault.getSelection());
        }
        if (this.newdataset) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.adddataset");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.testingtools.help.updatedataset");
        }
        this.setControl((Control)top);
    }

    public void modifyText(ModifyEvent e) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        String[] segments;
        this.setErrorMessage(null);
        if (!this.name.isEnabled()) {
            return true;
        }
        String testname = this.name.getText().trim();
        if (testname.length() == 0 && this.canHaveblankDSN) {
            return true;
        }
        if (testname.length() == 0) {
            this.setErrorMessage("Missing Name");
            return false;
        }
        if (testname.length() > 44) {
            this.setErrorMessage("Name is too long");
            return false;
        }
        if (testname.startsWith(".") || testname.endsWith(".")) {
            this.setErrorMessage("Name is malformed");
            return false;
        }
        String[] stringArray = segments = testname.split("[.]");
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            int size = segment.length();
            if (size > 8 || size < 1) {
                this.setErrorMessage("Name is malformed");
                return false;
            }
            ++n2;
        }
        if (this.names.contains(testname)) {
            this.setErrorMessage("Duplicate name");
            return false;
        }
        this.setErrorMessage(null);
        return this.changed;
    }

    public boolean doFinish() {
        CheckboxTreeViewer viewer;
        String datasetName = this.name.isEnabled() ? this.name.getText().trim() : "";
        if (this.newdataset) {
            TT_TreeItem nodeItem = this.model.findObject(this.datasetParent);
            Element nodeElement = nodeItem.getElement();
            Element datasetElement = this.model.addNodeChild(nodeElement, datasetName);
            TT_TreeItem datasetItem = this.model.insertNodeChild(nodeItem, datasetElement);
            this.dataset = (Dataset)datasetItem.getValue();
        } else {
            this.dataset.setName(datasetName);
        }
        this.model.save();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        IWorkbenchPage page = window.getActivePage();
        IViewPart view = page.findView("com.ca.testingtools.ui.views.profileview");
        if (view instanceof ProfileView && (viewer = ((ProfileView)view).getViewer()) != null) {
            viewer.refresh(true);
            TT_TreeItem selection = this.dataset.getParent();
            viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        this.name.setEnabled(!this.makeDefault.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

