/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.handlers;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMLayoutTreeModel;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.filemaster.views.properties.PropertiesServer;
import com.ca.filemaster.views.properties.PropertiesView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.w3c.dom.Element;

public class PropertiesHandler
extends AbstractHandler
implements IElementUpdater {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private FileMasterDataset dataSet;
    private FileMasterServer server;
    public static FileMasterServer serverProperties;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private FMSelectionTreeModel selectionModel = FMSelectionTreeModel.getInstance();
    private FMLayoutTreeModel layoutModel = FMLayoutTreeModel.getInstance();
    private int result = 1;
    private boolean selectionView = false;
    private boolean layoutView = false;
    private boolean oldDatasetTypeIsChange = false;
    private String oldDatasetType;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TT_TreeItem obj;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        TT_TreeItem treeItem = obj = (TT_TreeItem)((IStructuredSelection)selection).getFirstElement();
        IWorkbenchPage page = window.getActivePage();
        DirectoryListView directoryListView = (DirectoryListView)page.findView("com.ca.filemaster.views.directorylist");
        if (!this.model.isActiveView(page, page.findView("com.ca.filemaster.views.directorylist")) && !(this.selectionView = this.model.isActiveView(page, page.findView("com.ca.filemaster.selection.views.selectionview")))) {
            this.layoutView = true;
        }
        try {
            IViewPart view = page.showView("com.ca.filemaster.views.propertiesview");
            view.setFocus();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        if (treeItem.getValue() instanceof FileMasterDataset) {
            this.dataSet = (FileMasterDataset)treeItem.getValue();
            this.oldDatasetType = this.dataSet.getDsOrg();
            this.server = (FileMasterServer)treeItem.getServer();
            if (this.server == null) {
                PropertiesServer wizard = new PropertiesServer("Properties", this.dataSet.getName());
                TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
                dialog.create();
                this.result = dialog.open();
                this.server = this.result == 0 ? PropertiesHandler.getServerProperties() : null;
                if (this.server == null && this.result != 1) {
                    int count = 0;
                    while (count < this.model.getServers().length) {
                        if (this.model.getServers()[count].getServer().getStatusText().equals("Active")) {
                            this.server = (FileMasterServer)this.model.getServers()[count].getServer();
                            break;
                        }
                        ++count;
                    }
                }
            }
            if (this.server == null && this.result == 1) {
                return null;
            }
            if (this.server == null) {
                MessageDialog.openError(null, (String)"Server Error", (String)"No active server was found. Please define one.");
                return null;
            }
            if (this.server.getStatusText().equals("Unknown host")) {
                MessageDialog.openError(null, (String)"Server Error", (String)("The server " + this.server.getName() + " is unknown."));
                return null;
            }
            if (this.server.getStatusText().equals("Connection refused")) {
                MessageDialog.openError(null, (String)"Server Error", (String)("The server " + this.server.getName() + " is not active."));
                return null;
            }
            this.dataSet = CommonMFCalls.getFQDSN(this.dataSet.getName(), "", this.server);
            String message = CommonMFCalls.MESSAGE;
            if (message.length() == 0) {
                Element datasetElement = null;
                TT_TreeItem datasetItem = null;
                if (this.selectionView) {
                    datasetElement = treeItem.getElement();
                    datasetItem = treeItem;
                    this.selectionModel.updateAttributeS(datasetElement, this.dataSet);
                    this.selectionModel.updateModel(datasetItem, datasetElement);
                } else if (this.layoutView) {
                    datasetElement = treeItem.getElement();
                    datasetItem = treeItem;
                    this.layoutModel.updateAttributeS(datasetElement, this.dataSet);
                    this.layoutModel.updateModel(datasetItem, datasetElement);
                } else {
                    this.oldDatasetTypeIsChange = this.FileTypeIsChanged(this.dataSet, this.oldDatasetType);
                    if (this.oldDatasetTypeIsChange) {
                        Element dsElement = this.model.addDataset(this.server.getElement(), this.dataSet);
                        TT_TreeItem serverItem = this.model.dlistMap.get(this.server.getUUIDString().hashCode());
                        this.model.insertDataset(serverItem, dsElement);
                    } else {
                        TT_TreeItem serverItem = this.model.dlistMap.get(this.server.getUUIDString().hashCode());
                        datasetItem = this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.dataSet.getName()).hashCode());
                        datasetElement = datasetItem.getElement();
                        this.model.updateAttributeS(datasetElement, this.dataSet);
                        this.model.updateModel(serverItem, datasetElement);
                    }
                    directoryListView.getViewer().refresh();
                }
                this.model.save();
                this.selectionModel.save();
                this.layoutModel.save();
                this.selectionView = false;
                this.layoutView = false;
                PropertiesView.propertiesTreeViewer.setInput((Object)this.dataSet);
            } else {
                PropertiesView.propertiesTreeViewer.setInput(null);
            }
        } else {
            PropertiesView.propertiesTreeViewer.setInput(null);
        }
        return null;
    }

    private boolean FileTypeIsChanged(FileMasterDataset dataSet, String oldDatasetType) {
        if (oldDatasetType.equalsIgnoreCase("PDS") && (dataSet.getDsOrg().equalsIgnoreCase("VSAM") || dataSet.getDsOrg().equalsIgnoreCase("Sequential"))) {
            this.model.removeItem(this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + dataSet.getName()).hashCode()));
            return true;
        }
        return false;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    public static FileMasterServer getServerProperties() {
        return serverProperties;
    }

    public static void setServerProperties(FileMasterServer serverProperties) {
        PropertiesHandler.serverProperties = serverProperties;
    }
}

