/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.runners;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunGetUpdateRecords
implements Runnable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private XMLRequest xml = null;
    private FileMasterServer server;
    private String displayMode;
    private String uuid;
    private boolean canRetry = true;
    private FileMasterRecord fmRecord;
    private FileMasterRecordField fmRecordField;
    private static final String SERVICE = "filemaster/fmp";
    private String hexMode = "N";
    private Logger log = Logger.getLogger(RunGetUpdateRecords.class.getName());

    public RunGetUpdateRecords(FileMasterServer server, String uuid, String displayMode, String hexMode, FileMasterRecord fmRecord) {
        this.displayMode = displayMode;
        this.server = server;
        this.hexMode = hexMode;
        this.uuid = uuid;
        this.fmRecord = fmRecord;
    }

    @Override
    public void run() {
        ServerConnect connection = new ServerConnect((TTServer)this.server, SERVICE);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            long t1;
            map.put("uuid", this.uuid);
            long t0 = System.currentTimeMillis();
            while ((t1 = System.currentTimeMillis()) - t0 < 200L) {
            }
            XMLDocument xmlDocument = this.createXml();
            if (xmlDocument == null) {
                this.log.log(Level.WARNING, "xmlDocument is null");
                return;
            }
            this.xml = connection.connect("find", map, false, xmlDocument);
            if (this.xml.getAttachedFile() != null) {
                File file = this.xml.getAttachedFile();
                FileInputStream is = new FileInputStream(file);
                this.xml = new XMLRequest((InputStream)is);
            } else {
                this.xml.getRoot();
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
        }
    }

    public XMLRequest getXml() {
        return this.xml;
    }

    private XMLDocument createXml() {
        String charData = "";
        String command = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><GUIRequest GUIsession=\"" + this.uuid + "\" requestID=\"1\">" + "<Edit displayMode=\"" + this.displayMode + "\" hex=\"" + this.hexMode + "\">";
        command = String.valueOf(command) + "<UpdateRecords>";
        command = String.valueOf(command) + "<RecordList>";
        command = String.valueOf(command) + "<Record number=\"" + this.fmRecord.getNumber() + "\">";
        command = String.valueOf(command) + "<RecordFields>";
        int i = 0;
        while (i < this.fmRecord.getRecordFields().size()) {
            this.fmRecordField = this.fmRecord.getRecordFields().get(i);
            charData = this.fmRecordField.getCharData();
            charData = charData.replace("&", "&amp;");
            charData = charData.replace(">", "&gt;");
            charData = charData.replace("<", "&lt;");
            charData = charData.replace("\"", "&quot;");
            charData = charData.replace("'", "&apos;");
            if (this.displayMode.contains("S") || this.displayMode.equalsIgnoreCase("M") || this.displayMode.equalsIgnoreCase("C")) {
                String charDataHex = this.fmRecordField.getCharDataHex();
                if (charDataHex.equalsIgnoreCase("Y")) {
                    command = String.valueOf(command) + "<RecordField ";
                    command = String.valueOf(command) + "id=\"" + this.fmRecordField.getLayoutField().getId() + "\" ";
                    command = String.valueOf(command) + Constants.ATTRIBUTE_CHARDATAWASHEX + "=\"Y\"";
                    command = String.valueOf(command) + ">";
                } else {
                    command = String.valueOf(command) + "<RecordField id=\"" + this.fmRecordField.getLayoutField().getId() + "\" >";
                }
            } else {
                command = String.valueOf(command) + "<RecordField>";
            }
            command = charData.isEmpty() ? String.valueOf(command) + "<CharData/>" : String.valueOf(command) + "<CharData>" + charData + "</CharData>";
            if (this.hexMode.equals("Y") && this.fmRecordField.getHexData1() != null) {
                command = String.valueOf(command) + "<HexData1>" + this.fmRecordField.getHexData1() + "</HexData1>";
                command = String.valueOf(command) + "<HexData2>" + this.fmRecordField.getHexData2() + "</HexData2>";
            }
            command = String.valueOf(command) + "</RecordField>";
            ++i;
        }
        command = String.valueOf(command) + "</RecordFields>";
        command = String.valueOf(command) + "</Record>";
        command = String.valueOf(command) + "</RecordList>";
        command = String.valueOf(command) + "</UpdateRecords></Edit></GUIRequest>";
        XMLDocument result = CommonMFCalls.createXMLDoc(command);
        return result;
    }
}

