/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.selection.views;

import com.ca.filemaster.common.ContextSwitch;
import com.ca.filemaster.common.FMSelectionTreeModel;
import com.ca.filemaster.selection.views.SelectionViewComparator;
import com.ca.filemaster.selection.views.SelectionViewContentProvider;
import com.ca.filemaster.selection.views.SelectionViewLabelProvider;
import com.ca.testingtools.core.TT_TreeItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class SelectionView
extends ViewPart {
    public static final String ID = "com.ca.filemaster.selection.views.selectionview";
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.selectionView";
    private TreeViewer viewer;
    private FMSelectionTreeModel model;
    private boolean show = true;
    private MenuManager menuMgr;

    public void init(IViewSite site) throws PartInitException {
        this.model = FMSelectionTreeModel.getInstance();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68354);
        SelectionViewContentProvider contentprovider = new SelectionViewContentProvider();
        SelectionViewLabelProvider labelProvider = new SelectionViewLabelProvider();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.viewer.setContentProvider((IContentProvider)contentprovider);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setComparator((ViewerComparator)new SelectionViewComparator());
        this.menuMgr = new MenuManager();
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        if (this.show) {
            this.menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SelectionView.this.show = false;
                    SelectionView.this.menuMgr.removeAll();
                }
            });
        }
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = this.menuMgr.createContextMenu(control);
        control.setMenu(menu);
        TT_TreeItem[] datasets = this.model.getDatasets();
        this.viewer.setInput((Object)datasets);
        this.viewer.collapseAll();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setFocus() {
        ContextSwitch.activate("com.ca.filemaster.selection");
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }
}

