/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.ui.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.Constants;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.runners.RunGetDSlists;
import com.ca.filemaster.runners.RunGetWCdsn;
import com.ca.filemaster.ui.wizards.BLKSizeLabelProvider;
import com.ca.filemaster.ui.wizards.DSNLabelProvider;
import com.ca.filemaster.ui.wizards.DSOrgLabelProvider;
import com.ca.filemaster.ui.wizards.DateCreatedLabelProvider;
import com.ca.filemaster.ui.wizards.DateReferencedLabelProvider;
import com.ca.filemaster.ui.wizards.ExtentsLabelProvider;
import com.ca.filemaster.ui.wizards.FileTypeLabelProvider;
import com.ca.filemaster.ui.wizards.FilesDataArrayContentProvider;
import com.ca.filemaster.ui.wizards.FilesDatasetWizardPageSorter;
import com.ca.filemaster.ui.wizards.GenericImportWizard;
import com.ca.filemaster.ui.wizards.LRECLLabelProvider;
import com.ca.filemaster.ui.wizards.RECFMLabelProvider;
import com.ca.filemaster.ui.wizards.TracksLabelProvider;
import com.ca.filemaster.ui.wizards.VolumeLabelProvider;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilesDatasetWizardPage
extends WizardPage
implements ModifyListener,
Listener {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private FileMasterDataset dataset;
    private FileMasterServer server;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.filemaster.help.filesAddDatasetWizardPage";
    private final String OLD_CONTEXT_HELP_ID = "com.ca.filemaster.help.filesDatasetWizardPageOld";
    private boolean newdataset = true;
    protected boolean changed = false;
    ArrayList<FileMasterDataset> fmdsList = new ArrayList();
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    private ArrayList<String> names = new ArrayList();
    protected Combo datasetname;
    private Combo servername;
    protected Combo volumename;
    protected Button select;
    private Button dsnList;
    private Button selectAll;
    private Text numberOfDS;
    protected CheckboxTableViewer viewer;
    private Group group;
    public static final int DSN = 0;
    public static final int Volume = 1;
    public static final int FileType = 2;
    public static final int dsorgStr = 3;
    public static final int lrecl = 4;
    public static final int blkSize = 5;
    public static final int recfm = 6;
    public static final int tracks = 7;
    public static final int extents = 8;
    public static final int dateCreated = 9;
    public static final int dateReferenced = 10;
    private Listener sortListener;

    public FilesDatasetWizardPage(FileMasterDataset dataset, FileMasterServer server, boolean newItem, String title) {
        super(dataset == null ? "New Data Set" : dataset.getName(), title, null);
        this.setDescription("Specify Data Set Name");
        this.newdataset = newItem;
        this.dataset = newItem ? null : dataset;
        this.server = server;
        TT_TreeItem[] siblings = this.newdataset || this.dataset == null ? (TT_TreeItem[])server.getParent().getChildren() : dataset.getParent().getSiblings();
        TT_TreeItem[] tT_TreeItemArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            TT_TreeItem item = tT_TreeItemArray[n2];
            this.names.add(item.getName());
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        Composite subParent = new Composite(parent, 0);
        subParent.setLayout((Layout)new GridLayout(4, false));
        Label labelServer = new Label(subParent, 16385);
        labelServer.setText("Se&rver:");
        this.servername = new Combo(subParent, 2056);
        this.servername.setItems(this.getServers());
        this.servername.setText(this.server.getText());
        this.servername.addListener(13, (Listener)this);
        this.servername.addModifyListener((ModifyListener)this);
        new Label(subParent, 16385);
        new Label(subParent, 16385);
        Label labelDatasetName = new Label(subParent, 16384);
        labelDatasetName.setText("&Data set name:");
        this.datasetname = new Combo(subParent, 2048);
        FMHistory.intializeComboBoxes(this.datasetname, "DatasetListFilesDatasetWizard");
        this.datasetname.addModifyListener((ModifyListener)this);
        this.datasetname.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.datasetname.setLayoutData((Object)data);
        this.datasetname.setTextLimit(44);
        this.select = new Button(subParent, 8);
        this.select.setText("&Select");
        this.select.setEnabled(false);
        this.select.addListener(13, (Listener)this);
        this.dsnList = new Button(subParent, 8);
        this.dsnList.setText("DSN &List");
        this.dsnList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilesDatasetWizardPage.this.datasetname.getText().isEmpty()) {
                    if (!FilesDatasetWizardPage.this.server.getFmpPreferences().getFmParmFilePrefs().getDSNLists().isEmpty()) {
                        GenericImportWizard wizard = new GenericImportWizard("Select DSN List", FilesDatasetWizardPage.this.server, false);
                        TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(FilesDatasetWizardPage.this.getShell(), (IWizard)wizard);
                        dialog.open();
                    } else {
                        MessageDialog.openWarning((Shell)FilesDatasetWizardPage.this.getShell(), (String)"Warning", (String)Validator.errorMsg[20]);
                    }
                } else {
                    FilesDatasetWizardPage.this.doDSNList();
                }
            }
        });
        this.dsnList.setVisible(false);
        Label labelVolume = new Label(subParent, 0);
        labelVolume.setText("&Volume serial:");
        this.volumename = new Combo(subParent, 2048);
        FMHistory.intializeComboBoxes(this.volumename, "VolumeListFilesDatasetWizard");
        this.volumename.setTextLimit(6);
        this.volumename.addModifyListener((ModifyListener)this);
        this.volumename.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.volumename.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        parent.setLayout((Layout)layout);
        GridLayout layout1 = new GridLayout(2, false);
        this.group = new Group(parent, 32);
        this.group.setText("Add data set");
        this.group.setLayout((Layout)layout1);
        this.group.setSize(this.group.computeSize(-1, -1));
        this.group.setLayoutData((Object)data);
        this.group.setRedraw(true);
        this.createViewer((Composite)this.group);
        this.selectAll = new Button((Composite)this.group, 8);
        this.selectAll.setText("Select &All");
        GridData gd_selectAllClearButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_selectAllClearButton.widthHint = 120;
        this.selectAll.setLayoutData((Object)gd_selectAllClearButton);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilesDatasetWizardPage.this.viewer.getTable().getItems().length > 0) {
                    if (FilesDatasetWizardPage.this.selectAll.getText().toString().equalsIgnoreCase("Select &All")) {
                        int i = 0;
                        while (i < FilesDatasetWizardPage.this.viewer.getTable().getItems().length) {
                            FilesDatasetWizardPage.this.viewer.getTable().getItem(i).setChecked(true);
                            ++i;
                        }
                        FilesDatasetWizardPage.this.selectAll.setText("&Clear Selections");
                    } else {
                        FilesDatasetWizardPage.this.selectAll.setText("Select &All");
                        int i = 0;
                        while (i < FilesDatasetWizardPage.this.viewer.getTable().getItems().length) {
                            FilesDatasetWizardPage.this.viewer.getTable().getItem(i).setChecked(false);
                            ++i;
                        }
                    }
                }
                FilesDatasetWizardPage.this.setPageComplete(FilesDatasetWizardPage.this.isPageComplete());
            }
        });
        this.numberOfDS = new Text((Composite)this.group, 8);
        this.numberOfDS.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        TextUtil.setWidth((Text)this.numberOfDS, (int)14);
        this.numberOfDS.setEnabled(false);
        if (this.newdataset) {
            this.datasetname.setText("");
        } else {
            this.datasetname.setText(this.dataset.getName());
        }
        if (this.newdataset) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.filesAddDatasetWizardPage");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.filesDatasetWizardPageOld");
        }
        this.setControl((Control)parent);
        Control Data = null;
        int controlCount = 0;
        while (controlCount < subParent.getChildren().length) {
            Data = subParent.getChildren()[controlCount];
            if (Data.toString().substring(0, 5).equalsIgnoreCase("Combo")) {
                TextUtil.setWidth((Combo)((Combo)Data), (int)25);
            }
            ++controlCount;
        }
        this.getShell().getDefaultButton().setText("OK");
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
    }

    private void createViewer(Composite parent) {
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68354);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.heightHint = 130;
        this.viewer.getTable().setLayoutData((Object)gd_table);
        this.setupColumnListener();
        this.createColumns(parent, (TableViewer)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new FilesDataArrayContentProvider());
        this.viewer.setInput(null);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilesDatasetWizardPage.this.setPageComplete(FilesDatasetWizardPage.this.isPageComplete());
            }
        });
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source instanceof Combo) {
            this.changeServer();
        } else if (source instanceof Button && ((Button)source).getText().equals("&Select")) {
            this.doSelect();
        }
    }

    private void doSelect() {
        int oldCheckedElements = this.viewer.getCheckedElements().length;
        this.fmdsList = new ArrayList();
        int count = 0;
        while (count < oldCheckedElements) {
            this.fmdsList.add((FileMasterDataset)((Object)this.viewer.getCheckedElements()[count]));
            ++count;
        }
        this.viewer.getTable().removeAll();
        String datasetName = this.datasetname.getText().trim().toUpperCase();
        String volumeName = this.volumename.getText().trim().toUpperCase();
        String DSLength = Integer.toHexString(this.datasetname.getText().length());
        if (datasetName.startsWith("\"")) {
            datasetName = datasetName.substring(1, datasetName.length() - 1);
        }
        this.dataset = new FileMasterDataset(null);
        this.dataset.setName(datasetName);
        this.dataset.setVolume(volumeName);
        this.dataset.setDSLength(DSLength);
        RunGetWCdsn runner = new RunGetWCdsn(this.dataset, this.server, volumeName, true);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getRoot();
            if (element.getAttribute("errorlevel").equalsIgnoreCase("32")) {
                TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + element.getAttribute("errorlevel")), (Throwable)new Throwable(String.valueOf(element.getAttribute("msg").replace("+", " ")) + ". " + element.getAttribute("reason").replace("+", " ")));
                this.numberOfDS.setText("No data sets returned.");
                this.numberOfDS.setEnabled(true);
            } else {
                NodeList nodes = element.getElementsByTagName("DataSetInfo");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                String message = "";
                if (nodes.getLength() == 0) {
                    int i = 0;
                    while (i < messages.getLength()) {
                        Node msgNode = messages.item(i);
                        Element msgElement = (Element)msgNode;
                        message = String.valueOf(message) + FilesDatasetWizardPage.getTagValue("Message", msgElement);
                        ++i;
                    }
                    Node rcNode = retCode.item(0);
                    Element rcElement = (Element)rcNode;
                    String returnCode = FilesDatasetWizardPage.getTagValue("ReturnCode", rcElement);
                    TT_ErrorDialog.openError(null, (String)"Error", (String)("Return Code: " + returnCode), (Throwable)new Throwable(message));
                    this.numberOfDS.setText("No data sets returned.");
                    this.numberOfDS.setEnabled(true);
                } else {
                    if (messages.getLength() > 0) {
                        Node msgNode = messages.item(0);
                        Element msgElement = (Element)msgNode;
                        message = FilesDatasetWizardPage.getTagValue("Message", msgElement);
                        if (message.startsWith("CAWA")) {
                            message = message.substring(8);
                        }
                        MessageDialog.openWarning(null, (String)"Warning", (String)message);
                    }
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Element dsElement = (Element)nodes.item(i);
                        FileMasterDataset dataset = new FileMasterDataset(null);
                        dataset.setName(dsElement.getAttribute("dsname"));
                        dataset.setFileType(dsElement.getAttribute("fileType"));
                        dataset.setVolume(dsElement.getAttribute("volser"));
                        dataset.setDSLength(DSLength);
                        if (dataset.getFileType().equalsIgnoreCase("CLUSTER")) {
                            dataset.setDsOrg("VSAM");
                        } else {
                            dataset.setDsOrg(dsElement.getAttribute("dsorgStr"));
                        }
                        dataset.setLrecl(dsElement.getAttribute("lrecl"));
                        dataset.setBlksize(dsElement.getAttribute("blksize"));
                        dataset.setRecfm(dsElement.getAttribute("recfm"));
                        dataset.setTracks(dsElement.getAttribute("tracks"));
                        dataset.setExtents(dsElement.getAttribute("extents"));
                        dataset.setDateCreated(dsElement.getAttribute("dateCreated"));
                        dataset.setDateReferenced(dsElement.getAttribute("dateReferenced"));
                        if (!this.fmdsList.contains((Object)dataset)) {
                            this.fmdsList.add(dataset);
                        }
                        ++i;
                    }
                    this.viewer.setInput((Object)this.fmdsList.toArray(new FileMasterDataset[this.fmdsList.size()]));
                    int count2 = 0;
                    while (count2 < oldCheckedElements) {
                        FileMasterDataset dsToChk = this.fmdsList.get(count2);
                        int count22 = 0;
                        while (count22 < this.viewer.getTable().getItemCount()) {
                            if (((FileMasterDataset)((Object)this.viewer.getElementAt(count22))).getName().equalsIgnoreCase(dsToChk.getName())) {
                                this.viewer.getTable().getItem(count22).setChecked(true);
                            }
                            ++count22;
                        }
                        ++count2;
                    }
                    this.viewer.refresh();
                    if (nodes.getLength() == 1) {
                        this.numberOfDS.setText(String.valueOf(nodes.getLength()) + " data set returned.");
                    } else {
                        this.numberOfDS.setText(String.valueOf(nodes.getLength()) + " data sets returned.");
                    }
                    this.numberOfDS.setEnabled(true);
                }
            }
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Data Set Name", "Volume", "File Type", "DSOrgStr", "LRECL", "BlkSize", "RecFM", "Tracks", "Extents", "Date Created", "Date Referenced"};
        int[] bounds = new int[]{300, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
        Table table = viewer.getTable();
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn tableColumn = new TableViewerColumn(viewer, bounds[i]);
            tableColumn.getColumn().setWidth(10 * Constants.getPixelSizeOfCharacter());
            switch (i) {
                case 0: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DSNLabelProvider());
                    tableColumn.getColumn().setWidth(44 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 1: {
                    tableColumn.setLabelProvider((CellLabelProvider)new VolumeLabelProvider());
                    tableColumn.getColumn().setWidth(8 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 2: {
                    tableColumn.setLabelProvider((CellLabelProvider)new FileTypeLabelProvider());
                    tableColumn.getColumn().setWidth(10 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 3: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DSOrgLabelProvider());
                    tableColumn.getColumn().setWidth(8 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 4: {
                    tableColumn.setLabelProvider((CellLabelProvider)new LRECLLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    tableColumn.getColumn().setWidth(6 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 5: {
                    tableColumn.setLabelProvider((CellLabelProvider)new BLKSizeLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    tableColumn.getColumn().setWidth(6 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 6: {
                    tableColumn.setLabelProvider((CellLabelProvider)new RECFMLabelProvider());
                    tableColumn.getColumn().setWidth(6 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 7: {
                    tableColumn.setLabelProvider((CellLabelProvider)new TracksLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    tableColumn.getColumn().setWidth(6 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 8: {
                    tableColumn.setLabelProvider((CellLabelProvider)new ExtentsLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    tableColumn.getColumn().setWidth(7 * Constants.getPixelSizeOfCharacter());
                    break;
                }
                case 9: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DateCreatedLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    break;
                }
                case 10: {
                    tableColumn.setLabelProvider((CellLabelProvider)new DateReferencedLabelProvider());
                    tableColumn.getColumn().setAlignment(131072);
                    tableColumn.getColumn().setWidth(13 * Constants.getPixelSizeOfCharacter());
                }
            }
            tableColumn.getColumn().setText(titles[i]);
            tableColumn.getColumn().addListener(13, this.sortListener);
            ++i;
        }
        viewer.setSorter((ViewerSorter)new FilesDatasetWizardPageSorter());
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
    }

    private void setupColumnListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = FilesDatasetWizardPage.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                FilesDatasetWizardPage.this.viewer.refresh();
            }
        };
    }

    public void modifyText(ModifyEvent e) {
        this.changed = true;
        this.getWizard().getContainer().updateButtons();
        this.isPageComplete();
    }

    public boolean isPageComplete() {
        String error = new String();
        this.changeServer();
        String datasetNameTrimmed = this.datasetname.getText();
        datasetNameTrimmed = datasetNameTrimmed.trim().toUpperCase();
        if (this.datasetname != null && this.volumename != null) {
            switch (Validator.dataset(datasetNameTrimmed, true)) {
                case 3: {
                    error = String.valueOf(error) + Validator.errorMsg[3] + "\n";
                    if (this.viewer.getCheckedElements().length > 0) {
                        error = new String();
                    }
                    this.select.setEnabled(true);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.dataset(datasetNameTrimmed, true)] + "\n ";
                    this.select.setEnabled(false);
                    break;
                }
                case 0: {
                    this.select.setEnabled(false);
                }
            }
            switch (Validator.volume(this.volumename.getText(), false)) {
                case 9: {
                    error = String.valueOf(error) + Validator.errorMsg[Validator.volume(this.volumename.getText(), false)] + "\n ";
                }
            }
        }
        if (error.length() > 0) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return this.changed;
    }

    public boolean doFinish() {
        TreeViewer viewer;
        IViewPart view;
        FMHistory.insertHistory(this.datasetname, "DatasetListFilesDatasetWizard");
        FMHistory.insertHistory(this.volumename, "VolumeListFilesDatasetWizard");
        int result = 0;
        int selectedItems = -1;
        String datasetName = this.datasetname.getText().trim().toUpperCase();
        datasetName = datasetName.replace("%", "%25");
        if (datasetName.startsWith("\"")) {
            datasetName = datasetName.substring(1, datasetName.length() - 1);
        }
        if (this.newdataset) {
            if (!this.tableItemsChecked()) {
                TT_TreeItem datasetItem;
                Element datasetElement;
                this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + datasetName).hashCode());
                FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(datasetName, this.volumename.getText(), this.server, true);
                if (this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + datasetName).hashCode()) != null) {
                    if (FMDataSet.getDsType().equalsIgnoreCase("P")) {
                        datasetElement = null;
                        TT_TreeItem datasetItem2 = null;
                        datasetItem2 = this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + datasetName).hashCode());
                        datasetElement = datasetItem2.getElement();
                        this.model.updateAttributeS(datasetElement, FMDataSet);
                        this.dataset = (FileMasterDataset)datasetItem2.getValue();
                        result = 0;
                    } else {
                        this.model.removeItem(this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + datasetName).hashCode()));
                        if (CommonMFCalls.RETURN_CODE.equals("0")) {
                            datasetElement = this.model.addDataset(this.server.getElement(), FMDataSet);
                            TT_TreeItem serverItem = this.model.dlistMap.get(this.server.getUUIDString().hashCode());
                            datasetItem = this.model.insertDataset(serverItem, datasetElement);
                            this.dataset = (FileMasterDataset)datasetItem.getValue();
                            result = 0;
                        } else {
                            result = -1;
                        }
                    }
                } else if (CommonMFCalls.RETURN_CODE.equals("0")) {
                    datasetElement = this.model.addDataset(this.server.getElement(), FMDataSet);
                    TT_TreeItem serverItem = this.model.dlistMap.get(this.server.getUUIDString().hashCode());
                    datasetItem = this.model.insertDataset(serverItem, datasetElement);
                    this.dataset = (FileMasterDataset)datasetItem.getValue();
                    result = 0;
                } else {
                    result = -1;
                }
            } else {
                selectedItems = 0;
                TT_TreeItem treeItem = this.model.dlistMap.get(this.server.getUUIDString().hashCode());
                TT_TreeItem datasetItem = null;
                int i = 0;
                while (i < this.viewer.getTable().getItems().length) {
                    if (this.viewer.getTable().getItem(i).getChecked()) {
                        TT_TreeItem dsItem;
                        Element datasetElement;
                        FileMasterDataset dataset;
                        ++selectedItems;
                        FileMasterDataset fmd = (FileMasterDataset)((Object)this.viewer.getTable().getItem(i).getData());
                        datasetItem = this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + ((FileMasterDataset)((Object)this.viewer.getTable().getItem(i).getData())).getName()).hashCode());
                        if (datasetItem != null) {
                            if (fmd.getDsOrg().equalsIgnoreCase("PDS")) {
                                Element datasetElement2 = null;
                                datasetElement2 = datasetItem.getElement();
                                this.model.updateAttributeS(datasetElement2, fmd);
                                this.dataset = (FileMasterDataset)datasetItem.getValue();
                                result = 0;
                            } else {
                                this.model.removeItem(datasetItem);
                                dataset = new FileMasterDataset(null);
                                dataset.setName(fmd.getName());
                                dataset.setFileType(fmd.getFileType());
                                dataset.setVolume(fmd.getVolume());
                                dataset.setDSLength(Integer.toHexString(fmd.getName().toString().length()));
                                dataset.setDsOrg(fmd.getDsOrg());
                                if (fmd.getFileType().equalsIgnoreCase("VSAM PATH") || fmd.getFileType().equalsIgnoreCase("VSAM AIX")) {
                                    fmd.setDsOrg("VSAM");
                                    fmd.setFileType("VSAM");
                                }
                                this.fmdsList.add(dataset);
                                result = 0;
                                datasetElement = this.model.addDataset(this.server.getElement(), fmd);
                                dsItem = this.model.insertDataset(treeItem, datasetElement);
                                this.dataset = (FileMasterDataset)dsItem.getValue();
                                this.model.save();
                            }
                        } else {
                            dataset = new FileMasterDataset(null);
                            dataset.setName(fmd.getName());
                            dataset.setFileType(fmd.getFileType());
                            dataset.setVolume(fmd.getVolume());
                            dataset.setDSLength(Integer.toHexString(fmd.getName().toString().length()));
                            dataset.setDsOrg(fmd.getDsOrg());
                            if (fmd.getFileType().equalsIgnoreCase("VSAM PATH") || fmd.getFileType().equalsIgnoreCase("VSAM AIX")) {
                                fmd.setDsOrg("VSAM");
                                fmd.setFileType("VSAM");
                            }
                            this.fmdsList.add(dataset);
                            result = 0;
                            datasetElement = this.model.addDataset(this.server.getElement(), fmd);
                            dsItem = this.model.insertDataset(treeItem, datasetElement);
                            this.dataset = (FileMasterDataset)dsItem.getValue();
                        }
                    }
                    ++i;
                }
                if (selectedItems == 0) {
                    TT_ErrorDialog.openError(null, (String)"Dataset Error", (String)"No data set matching the wildcard entry selected.", (Throwable)new Throwable("Data Set name mispelled\nData Set not defined\nData Set Deleted"));
                    return false;
                }
            }
        }
        this.model.save();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        shell.setMinimized(false);
        shell.forceActive();
        shell.forceFocus();
        if (result == 0 && selectedItems != 0) {
            try {
                IWorkbenchPage page = window.getActivePage();
                view = page.showView("com.ca.filemaster.views.directorylist");
                if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                    TT_TreeItem selection = this.model.dlistMap.get((String.valueOf(this.server.getUUIDString()) + this.dataset.getName()).hashCode());
                    TT_TreeItem parent = selection.getParent();
                    viewer.refresh((Object)parent, true);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                    view.setFocus();
                }
            }
            catch (PartInitException partInitException) {}
            return true;
        }
        try {
            IWorkbenchPage page = window.getActivePage();
            view = page.showView("com.ca.filemaster.views.directorylist");
            if (view instanceof DirectoryListView && (viewer = ((DirectoryListView)view).getViewer()) != null) {
                viewer.refresh();
                view.setFocus();
            }
        }
        catch (PartInitException partInitException) {}
        this.model.save();
        return false;
    }

    private String[] getServers() {
        String[] listOfServers = new String[this.model.getServers().length];
        int serverCount = 0;
        while (serverCount < this.model.getServers().length) {
            listOfServers[serverCount] = this.model.getServers()[serverCount].getServer().getText();
            ++serverCount;
        }
        return listOfServers;
    }

    protected void changeServer() {
        this.names.clear();
        String TestServer = "";
        int servers = 0;
        while (servers < this.model.getServers().length) {
            TestServer = this.model.getServers()[servers].getText();
            if (TestServer.equalsIgnoreCase(this.servername.getText())) {
                this.server = (FileMasterServer)((Object)this.model.getServers()[servers].getAdapter(FileMasterServer.class));
                break;
            }
            ++servers;
        }
        if (this.server != null) {
            TT_TreeItem[] siblings = this.newdataset || this.dataset == null ? (TT_TreeItem[])this.server.getParent().getChildren() : this.dataset.getParent().getSiblings();
            TT_TreeItem[] tT_TreeItemArray = siblings;
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                TT_TreeItem item = tT_TreeItemArray[n2];
                this.names.add(item.getName());
                ++n2;
            }
        }
    }

    public boolean doDSNList() {
        this.viewer.getTable().removeAll();
        FileMasterMember member = new FileMasterMember(null);
        member.setName(this.datasetname.getText());
        RunGetDSlists runner = new RunGetDSlists(member, this.server);
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xml = runner.getXml();
        if (xml != null) {
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("datasetnode");
            if (nodes.getLength() == 0) {
                TT_ErrorDialog.openError(null, (String)"DSN List retrival Error", (String)"No DSN List found with that name.", (Throwable)new Throwable("DSN List name mispelled\nDSN List not defined\nMainframe communication error"));
            } else {
                ArrayList<FileMasterDataset> fmdsList = new ArrayList<FileMasterDataset>();
                int i = 0;
                while (i < nodes.getLength()) {
                    Element dsElement = (Element)nodes.item(i);
                    FileMasterDataset dataset = new FileMasterDataset(null);
                    dataset.setName(dsElement.getAttribute("name"));
                    dataset.setFileType(dsElement.getAttribute("filetype"));
                    dataset.setVolume(dsElement.getAttribute("volume"));
                    dataset.setDSLength(Integer.toHexString(dsElement.getAttribute("name").toString().length()));
                    dataset.setDsOrg(dsElement.getAttribute("dsorg"));
                    fmdsList.add(dataset);
                    ++i;
                }
                this.viewer.setInput((Object)fmdsList.toArray(new FileMasterDataset[fmdsList.size()]));
                this.viewer.refresh();
            }
        }
        return true;
    }

    protected boolean tableItemsChecked() {
        int i = 0;
        while (i < this.viewer.getTable().getItems().length) {
            if (this.viewer.getTable().getItem(i).getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue();
    }
}

