/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.views.properties;

import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.views.properties.IFMFile;
import com.ca.filemaster.views.properties.Parameter;
import com.ca.filemaster.views.properties.ParametersCategory;
import java.util.ArrayList;

public class FMNonVSAM
implements IFMFile {
    private FileMasterDataset dataSet;

    public FMNonVSAM(FileMasterDataset dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Object[] buildParametersForDisplay() {
        ArrayList<ParametersCategory> categories = new ArrayList<ParametersCategory>();
        ParametersCategory category = null;
        if (this.dataSet.getDsOrg().contains("Sequential")) {
            category = new ParametersCategory("Alias of");
            categories.add(category);
        }
        String allocUnit = "";
        if (this.dataSet.getAllocatedallocUnit().equalsIgnoreCase("cyls")) {
            allocUnit = "cylinders";
        } else if (this.dataSet.getAllocatedallocUnit().equalsIgnoreCase("trk") || this.dataSet.getAllocatedallocUnit().equalsIgnoreCase("tracks")) {
            allocUnit = "tracks";
        } else if (this.dataSet.getAllocatedallocUnit().equalsIgnoreCase("blk") || this.dataSet.getAllocatedallocUnit().equalsIgnoreCase("blocks")) {
            allocUnit = "blocks";
        }
        category = new ParametersCategory("Data Set Definition");
        categories.add(category);
        category.getParameters().add(new Parameter("Name", this.dataSet.getName()));
        if (this.dataSet.getVolumes() != null && this.dataSet.getVolumes().size() > 0) {
            String volumes = "";
            int count = 0;
            while (count < this.dataSet.getVolumes().size()) {
                volumes = String.valueOf(volumes) + ", " + this.dataSet.getVolumes().get(count);
                ++count;
            }
            category.getParameters().add(new Parameter("Volume serial", volumes.replaceFirst(", ", "")));
        } else {
            category.getParameters().add(new Parameter("Volume serial", this.dataSet.getVolume()));
        }
        category.getParameters().add(new Parameter("Unit device type", this.dataSet.getUnitType()));
        category.getParameters().add(new Parameter("Record format", this.dataSet.getRecfm()));
        category.getParameters().add(new Parameter("Record length", this.dataSet.getLrecl()));
        category.getParameters().add(new Parameter("Block size", this.dataSet.getBlksize()));
        if (!allocUnit.isEmpty()) {
            category.getParameters().add(new Parameter("Allocation unit", String.valueOf(allocUnit.toUpperCase().charAt(0)) + allocUnit.substring(1)));
        }
        category.getParameters().add(new Parameter("First extent " + allocUnit, this.dataSet.getPrimaryAlloc()));
        category.getParameters().add(new Parameter("Secondary extent " + allocUnit, this.dataSet.getSecondaryAlloc()));
        if (this.dataSet.getDsOrg().contains("Sequential")) {
            category.getParameters().add(new Parameter("Data set organization", "Sequential Data Set"));
        } else if (this.dataSet.getDsOrg().contains("PDSE")) {
            category.getParameters().add(new Parameter("Data set organization", "Partitioned Data Set Extended"));
        } else if (this.dataSet.getDsOrg().contains("PDS")) {
            category.getParameters().add(new Parameter("Data set organization", "Partitioned Data Set"));
        }
        category.getParameters().add(new Parameter("Data set type", this.dataSet.getDsOrg()));
        category = new ParametersCategory("SMS Information");
        categories.add(category);
        category.getParameters().add(new Parameter("Storage class", this.dataSet.getSmsStorage()));
        category.getParameters().add(new Parameter("Data class", this.dataSet.getSmsData()));
        category.getParameters().add(new Parameter("Management class", this.dataSet.getSmsManagement()));
        category = new ParametersCategory("Allocated and Used");
        categories.add(category);
        if (this.dataSet.getDsOrg().equals("PDS") || this.dataSet.getDsOrg().equals("PDSE") || this.dataSet.getDsOrg().equals("HFS")) {
            category.getParameters().add(new Parameter("Number of members", this.dataSet.getNumMembers()));
        }
        if (this.dataSet.getDsOrg().equals("HFS")) {
            category.getParameters().add(new Parameter("Number of pages", this.dataSet.getNumberPages()));
        }
        category.getParameters().add(new Parameter("Allocated " + allocUnit, this.dataSet.getAllocatedallocValue()));
        if (this.dataSet.getDsOrg().equals("PDSE")) {
            category.getParameters().add(new Parameter("Used PDSE 4K pages", this.dataSet.getUsedAllocValue()));
        }
        if (!this.dataSet.getDsOrg().equals("PDSE")) {
            category.getParameters().add(new Parameter("Used " + allocUnit, this.dataSet.getUsedAllocValue()));
        }
        category.getParameters().add(new Parameter("Allocated extents", this.dataSet.getExtentsAllocated()));
        category.getParameters().add(new Parameter("Used extents", this.dataSet.getExtentsUsed()));
        if (this.dataSet.getDsOrg().equals("PDS") || this.dataSet.getDsOrg().equals("HFS")) {
            category.getParameters().add(new Parameter("Max directory blocks", this.dataSet.getDircMax()));
            category.getParameters().add(new Parameter("Used directory blocks", this.dataSet.getDircUsed()));
        }
        category = new ParametersCategory("Activity Dates");
        categories.add(category);
        category.getParameters().add(new Parameter("Creation date", this.dataSet.getDateCreated()));
        category.getParameters().add(new Parameter("Last referenced date", this.dataSet.getDateReferenced()));
        category.getParameters().add(new Parameter("Expiration date", this.dataSet.getExpirationDate()));
        return categories.toArray();
    }
}

